/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.cortex.voxy.client.VoxyClientInstance;
import me.cortex.voxy.client.core.IGetVoxyRenderSystem;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.commonImpl.VoxyCommon;
import me.cortex.voxy.commonImpl.WorldIdentifier;
import me.cortex.voxy.commonImpl.importers.DHImporter;
import me.cortex.voxy.commonImpl.importers.WorldImporter;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_761;

public class VoxyCommands {
    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        LiteralArgumentBuilder imports = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"import").then(ClientCommandManager.literal((String)"world").then(ClientCommandManager.argument((String)"world_name", (ArgumentType)StringArgumentType.string()).suggests(VoxyCommands::importWorldSuggester).executes(VoxyCommands::importWorld)))).then(ClientCommandManager.literal((String)"bobby").then(ClientCommandManager.argument((String)"world_name", (ArgumentType)StringArgumentType.string()).suggests(VoxyCommands::importBobbySuggester).executes(VoxyCommands::importBobby)))).then(ClientCommandManager.literal((String)"raw").then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.string()).executes(VoxyCommands::importRaw)))).then(ClientCommandManager.literal((String)"zip").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"zipPath", (ArgumentType)StringArgumentType.string()).executes(VoxyCommands::importZip)).then(ClientCommandManager.argument((String)"innerPath", (ArgumentType)StringArgumentType.string()).executes(VoxyCommands::importZip))))).then(ClientCommandManager.literal((String)"cancel").executes(VoxyCommands::cancelImport));
        if (DHImporter.HasRequiredLibraries) {
            imports = (LiteralArgumentBuilder)imports.then(ClientCommandManager.literal((String)"distant_horizons").then(ClientCommandManager.argument((String)"sqlDbPath", (ArgumentType)StringArgumentType.string()).executes(VoxyCommands::importDistantHorizons)));
        }
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"voxy").then(ClientCommandManager.literal((String)"reload").executes(VoxyCommands::reloadInstance))).then((ArgumentBuilder)imports);
    }

    private static int reloadInstance(CommandContext<FabricClientCommandSource> ctx) {
        VoxyClientInstance instance = (VoxyClientInstance)VoxyCommon.getInstance();
        if (instance == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"Voxy must be enabled in settings to use this"));
            return 1;
        }
        class_761 wr = class_310.method_1551().field_1769;
        if (wr != null) {
            ((IGetVoxyRenderSystem)wr).shutdownRenderer();
        }
        VoxyCommon.shutdownInstance();
        System.gc();
        VoxyCommon.createInstance();
        class_761 r = class_310.method_1551().field_1769;
        if (r != null) {
            r.method_3279();
        }
        return 0;
    }

    private static int importDistantHorizons(CommandContext<FabricClientCommandSource> ctx) {
        VoxyClientInstance instance = (VoxyClientInstance)VoxyCommon.getInstance();
        if (instance == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"Voxy must be enabled in settings to use this"));
            return 1;
        }
        File dbFile = new File((String)ctx.getArgument("sqlDbPath", String.class));
        if (!dbFile.exists()) {
            return 1;
        }
        if (dbFile.isDirectory() && !(dbFile = dbFile.toPath().resolve("DistantHorizons.sqlite").toFile()).exists()) {
            return 1;
        }
        File dbFile_ = dbFile;
        WorldEngine engine = WorldIdentifier.ofEngine((class_1937)class_310.method_1551().field_1687);
        if (engine == null) {
            return 1;
        }
        return instance.getImportManager().makeAndRunIfNone(engine, () -> new DHImporter(dbFile_, engine, (class_1937)class_310.method_1551().field_1687, instance.getServiceManager(), instance.savingServiceRateLimiter)) ? 0 : 1;
    }

    private static boolean fileBasedImporter(File directory) {
        VoxyClientInstance instance = (VoxyClientInstance)VoxyCommon.getInstance();
        if (instance == null) {
            return false;
        }
        WorldEngine engine = WorldIdentifier.ofEngine((class_1937)class_310.method_1551().field_1687);
        if (engine == null) {
            return false;
        }
        return instance.getImportManager().makeAndRunIfNone(engine, () -> {
            WorldImporter importer = new WorldImporter(engine, (class_1937)class_310.method_1551().field_1687, instance.getServiceManager(), instance.savingServiceRateLimiter);
            importer.importRegionDirectoryAsync(directory);
            return importer;
        });
    }

    private static int importRaw(CommandContext<FabricClientCommandSource> ctx) {
        if (VoxyCommon.getInstance() == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"Voxy must be enabled in settings to use this"));
            return 1;
        }
        return VoxyCommands.fileBasedImporter(new File((String)ctx.getArgument("path", String.class))) ? 0 : 1;
    }

    private static int importBobby(CommandContext<FabricClientCommandSource> ctx) {
        if (VoxyCommon.getInstance() == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"Voxy must be enabled in settings to use this"));
            return 1;
        }
        File file = new File(".bobby").toPath().resolve((String)ctx.getArgument("world_name", String.class)).toFile();
        return VoxyCommands.fileBasedImporter(file) ? 0 : 1;
    }

    private static CompletableFuture<Suggestions> importWorldSuggester(CommandContext<FabricClientCommandSource> ctx, SuggestionsBuilder sb) {
        return VoxyCommands.fileDirectorySuggester(class_310.method_1551().field_1697.toPath().resolve("saves"), sb);
    }

    private static CompletableFuture<Suggestions> importBobbySuggester(CommandContext<FabricClientCommandSource> ctx, SuggestionsBuilder sb) {
        return VoxyCommands.fileDirectorySuggester(class_310.method_1551().field_1697.toPath().resolve(".bobby"), sb);
    }

    private static CompletableFuture<Suggestions> fileDirectorySuggester(Path dir, SuggestionsBuilder sb) {
        String str = sb.getRemaining().replace("\\\\", "\\").replace("\\", "/");
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        String remaining = str;
        if (str.contains("/")) {
            int idx = str.lastIndexOf(47);
            remaining = str.substring(idx + 1);
            try {
                dir = dir.resolve(str.substring(0, idx));
            }
            catch (Exception e) {
                return Suggestions.empty();
            }
            str = str.substring(0, idx + 1);
        } else {
            str = "";
        }
        try {
            List<Path> worlds = Files.list(dir).toList();
            for (Path world : worlds) {
                Object wn;
                if (!world.toFile().isDirectory() || ((String)(wn = world.getFileName().toString())).equals(remaining) || !class_2172.method_27136((String)remaining, (String)wn) && !class_2172.method_27136((String)remaining, (String)("\"" + (String)wn))) continue;
                wn = str + (String)wn + "/";
                sb.suggest(StringArgumentType.escapeIfRequired((String)wn));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.buildFuture();
    }

    private static int importWorld(CommandContext<FabricClientCommandSource> ctx) {
        if (VoxyCommon.getInstance() == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"Voxy must be enabled in settings to use this"));
            return 1;
        }
        String name = (String)ctx.getArgument("world_name", String.class);
        Path file = new File("saves").toPath().resolve(name);
        if ((name = name.toLowerCase()).endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if (!name.endsWith("region")) {
            file = file.resolve("region");
        }
        return VoxyCommands.fileBasedImporter(file.toFile()) ? 0 : 1;
    }

    private static int importZip(CommandContext<FabricClientCommandSource> ctx) {
        File zip = new File((String)ctx.getArgument("zipPath", String.class));
        String innerDir = "region/";
        try {
            innerDir = (String)ctx.getArgument("innerPath", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        VoxyClientInstance instance = (VoxyClientInstance)VoxyCommon.getInstance();
        if (instance == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"Voxy must be enabled in settings to use this"));
            return 1;
        }
        String finalInnerDir = innerDir;
        WorldEngine engine = WorldIdentifier.ofEngine((class_1937)class_310.method_1551().field_1687);
        if (engine != null) {
            return instance.getImportManager().makeAndRunIfNone(engine, () -> {
                WorldImporter importer = new WorldImporter(engine, (class_1937)class_310.method_1551().field_1687, instance.getServiceManager(), instance.savingServiceRateLimiter);
                importer.importZippedRegionDirectoryAsync(zip, finalInnerDir);
                return importer;
            }) ? 0 : 1;
        }
        return 1;
    }

    private static int cancelImport(CommandContext<FabricClientCommandSource> ctx) {
        VoxyClientInstance instance = (VoxyClientInstance)VoxyCommon.getInstance();
        if (instance == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43471((String)"Voxy must be enabled in settings to use this"));
            return 1;
        }
        WorldEngine world = WorldIdentifier.ofEngineNullable((class_1937)class_310.method_1551().field_1687);
        if (world != null) {
            return instance.getImportManager().cancelImport(world) ? 0 : 1;
        }
        return 1;
    }
}

