/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.compat;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.playback.ReplayServer;
import com.moulberry.flashback.record.FlashbackMeta;
import java.io.File;
import java.nio.file.Path;
import me.cortex.voxy.client.compat.IFlashbackMeta;
import me.cortex.voxy.common.Logger;
import net.fabricmc.loader.api.FabricLoader;

public class FlashbackCompat {
    public static final boolean FLASHBACK_INSTALLED = FabricLoader.getInstance().isModLoaded("flashback");

    public static Path getReplayStoragePath() {
        if (!FLASHBACK_INSTALLED) {
            return null;
        }
        return FlashbackCompat.getReplayStoragePath0();
    }

    private static Path getReplayStoragePath0() {
        File path;
        FlashbackMeta meta;
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer != null && (meta = replayServer.getMetadata()) != null && (path = ((IFlashbackMeta)meta).getVoxyPath()) != null) {
            Logger.info("Flashback replay server exists and meta exists");
            if (path.exists()) {
                Logger.info("Flashback voxy path exists in filesystem, using this as lod data source");
                return path.toPath();
            }
            Logger.warn("Flashback meta had voxy path saved but path doesnt exist");
        }
        return null;
    }
}

