/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.config;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import me.cortex.voxy.client.RenderStatistics;
import me.cortex.voxy.client.VoxyClientInstance;
import me.cortex.voxy.client.config.VoxyConfig;
import me.cortex.voxy.client.core.IGetVoxyRenderSystem;
import me.cortex.voxy.client.core.VoxyRenderSystem;
import me.cortex.voxy.common.util.cpu.CpuLayout;
import me.cortex.voxy.commonImpl.VoxyCommon;
import me.cortex.voxy.commonImpl.VoxyInstance;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionFlag;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.caffeinemc.mods.sodium.client.gui.options.storage.OptionStorage;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public abstract class VoxyConfigScreenPages {
    public static OptionPage voxyOptionPage = null;
    private static final int SUBDIV_IN_MAX = 100;
    private static final double SUBDIV_MIN = 28.0;
    private static final double SUBDIV_MAX = 256.0;
    private static final double SUBDIV_CONST = Math.log(9.142857142857142) / Math.log(2.0);

    private VoxyConfigScreenPages() {
    }

    public static OptionPage page() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        VoxyConfig storage = VoxyConfig.CONFIG;
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.enabled")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.enabled.tooltip")).setControl(TickBoxControl::new).setBinding((s, v) -> {
            s.enabled = v;
            if (v.booleanValue()) {
                if (VoxyClientInstance.isInGame) {
                    VoxyCommon.createInstance();
                    IGetVoxyRenderSystem vrsh = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
                    if (vrsh != null && s.enableRendering) {
                        vrsh.createRenderer();
                    }
                }
            } else {
                IGetVoxyRenderSystem vrsh = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
                if (vrsh != null) {
                    vrsh.shutdownRenderer();
                }
                VoxyCommon.shutdownInstance();
            }
        }, s -> s.enabled).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.serviceThreads")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.serviceThreads.tooltip")).setControl(opt -> new SliderControl((Option)opt, 1, CpuLayout.CORES.length, 1, v -> class_2561.method_43470((String)Integer.toString(v)))).setBinding((s, v) -> {
            s.serviceThreads = v;
            VoxyInstance instance = VoxyCommon.getInstance();
            if (instance != null) {
                instance.updateDedicatedThreads();
            }
        }, s -> s.serviceThreads).setImpact(OptionImpact.HIGH).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.useSodiumBuilder")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.useSodiumBuilder.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.VARIES).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).setBinding((s, v) -> {
            s.dontUseSodiumBuilderThreads = v == false;
            VoxyInstance instance = VoxyCommon.getInstance();
            if (instance != null) {
                instance.updateDedicatedThreads();
            }
        }, s -> !s.dontUseSodiumBuilderThreads).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.ingest")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.ingest.tooltip")).setControl(TickBoxControl::new).setBinding((s, v) -> {
            s.ingestEnabled = v;
        }, s -> s.ingestEnabled).setImpact(OptionImpact.MEDIUM).build()).build());
        groups.add(OptionGroup.createBuilder().add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.rendering")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.rendering.tooltip")).setControl(TickBoxControl::new).setBinding((s, v) -> {
            s.enableRendering = v;
            IGetVoxyRenderSystem vrsh = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
            if (vrsh != null) {
                if (v.booleanValue()) {
                    vrsh.createRenderer();
                } else {
                    vrsh.shutdownRenderer();
                }
            }
        }, s -> s.enableRendering).setImpact(OptionImpact.HIGH).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.subDivisionSize")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.subDivisionSize.tooltip")).setControl(opt -> new SliderControl((Option)opt, 0, 100, 1, v -> class_2561.method_43470((String)Integer.toString(Math.round(VoxyConfigScreenPages.ln2subDiv(v)))))).setBinding((s, v) -> {
            s.subDivisionSize = VoxyConfigScreenPages.ln2subDiv(v);
        }, s -> VoxyConfigScreenPages.subDiv2ln(s.subDivisionSize)).setImpact(OptionImpact.HIGH).build()).add((Option)OptionImpl.createBuilder(Integer.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.renderDistance")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.renderDistance.tooltip")).setControl(opt -> new SliderControl((Option)opt, 2, 64, 1, v -> class_2561.method_43470((String)Integer.toString(v * 32)))).setBinding((s, v) -> {
            VoxyRenderSystem vrs;
            s.sectionRenderDistance = v;
            IGetVoxyRenderSystem vrsh = (IGetVoxyRenderSystem)class_310.method_1551().field_1769;
            if (vrsh != null && (vrs = vrsh.getVoxyRenderSystem()) != null) {
                vrs.setRenderDistance((int)v);
            }
        }, s -> s.sectionRenderDistance).setImpact(OptionImpact.LOW).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.environmental_fog")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.environmental_fog.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.VARIES).setBinding((s, v) -> {
            s.useEnvironmentalFog = v;
        }, s -> s.useEnvironmentalFog).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.vanilla_fog")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.vanilla_fog.tooltip")).setControl(TickBoxControl::new).setBinding((s, v) -> {
            s.renderVanillaFog = v;
        }, s -> s.renderVanillaFog).build()).add((Option)OptionImpl.createBuilder(Boolean.TYPE, (OptionStorage)storage).setName((class_2561)class_2561.method_43471((String)"voxy.config.general.render_statistics")).setTooltip((class_2561)class_2561.method_43471((String)"voxy.config.general.render_statistics.tooltip")).setControl(TickBoxControl::new).setBinding((s, v) -> {
            RenderStatistics.enabled = v;
        }, s -> RenderStatistics.enabled).setFlags(new OptionFlag[]{OptionFlag.REQUIRES_RENDERER_RELOAD}).build()).build());
        return new OptionPage((class_2561)class_2561.method_43471((String)"voxy.config.title"), ImmutableList.copyOf(groups));
    }

    private static float ln2subDiv(int in) {
        return (float)(28.0 * Math.pow(2.0, SUBDIV_CONST * ((double)in / 100.0)));
    }

    private static int subDiv2ln(float in) {
        return (int)(Math.log((double)in / 28.0) / Math.log(2.0) / SUBDIV_CONST * 100.0);
    }
}

