/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core;

import java.util.function.BooleanSupplier;
import me.cortex.voxy.client.config.VoxyConfig;
import me.cortex.voxy.client.core.AbstractRenderPipeline;
import me.cortex.voxy.client.core.gl.GlFramebuffer;
import me.cortex.voxy.client.core.gl.GlTexture;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import me.cortex.voxy.client.core.rendering.Viewport;
import me.cortex.voxy.client.core.rendering.hierachical.AsyncNodeManager;
import me.cortex.voxy.client.core.rendering.hierachical.HierarchicalOcclusionTraverser;
import me.cortex.voxy.client.core.rendering.hierachical.NodeCleaner;
import me.cortex.voxy.client.core.rendering.post.FullscreenBlit;
import me.cortex.voxy.client.core.rendering.util.DepthFramebuffer;
import net.minecraft.class_310;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.ARBComputeShader;
import org.lwjgl.opengl.ARBShaderImageLoadStore;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.MemoryStack;

public class NormalRenderPipeline
extends AbstractRenderPipeline {
    private GlTexture colourTex;
    private GlTexture colourSSAOTex;
    private final GlFramebuffer fbSSAO = new GlFramebuffer();
    private final DepthFramebuffer fb = new DepthFramebuffer(35056);
    private final boolean useEnvFog;
    private final FullscreenBlit finalBlit;
    private final Shader ssaoCompute = Shader.make(new IShaderProcessor[0]).add(ShaderType.COMPUTE, "voxy:post/ssao.comp").compile();

    protected NormalRenderPipeline(AsyncNodeManager nodeManager, NodeCleaner nodeCleaner, HierarchicalOcclusionTraverser traversal, BooleanSupplier frexSupplier) {
        super(nodeManager, nodeCleaner, traversal, frexSupplier);
        this.useEnvFog = VoxyConfig.CONFIG.useEnvironmentalFog;
        this.finalBlit = new FullscreenBlit("voxy:post/blit_texture_depth_cutout.frag", a -> a.defineIf("USE_ENV_FOG", this.useEnvFog).define("EMIT_COLOUR"));
    }

    @Override
    protected int setup(Viewport<?> viewport, int sourceFB, int srcWidth, int srcHeight) {
        if (this.colourTex == null || this.colourTex.getHeight() != viewport.height || this.colourTex.getWidth() != viewport.width) {
            if (this.colourTex != null) {
                this.colourTex.free();
                this.colourSSAOTex.free();
            }
            this.fb.resize(viewport.width, viewport.height);
            this.colourTex = new GlTexture().store(32856, 1, viewport.width, viewport.height);
            this.colourSSAOTex = new GlTexture().store(32856, 1, viewport.width, viewport.height);
            this.fb.framebuffer.bind(36064, this.colourTex).verify();
            this.fbSSAO.bind(33306, this.fb.getDepthTex()).bind(36064, this.colourSSAOTex).verify();
            GL45C.glTextureParameterf((int)this.colourTex.id, (int)10241, (float)9728.0f);
            GL45C.glTextureParameterf((int)this.colourTex.id, (int)10240, (float)9728.0f);
            GL45C.glTextureParameterf((int)this.colourSSAOTex.id, (int)10241, (float)9728.0f);
            GL45C.glTextureParameterf((int)this.colourSSAOTex.id, (int)10240, (float)9728.0f);
            GL45C.glTextureParameterf((int)this.fb.getDepthTex().id, (int)37098, (float)6402.0f);
        }
        this.initDepthStencil(sourceFB, this.fb.framebuffer.id, viewport.width, viewport.height, viewport.width, viewport.height);
        return this.fb.getDepthTex().id;
    }

    @Override
    protected void postOpaquePreTranslucent(Viewport<?> viewport) {
        this.ssaoCompute.bind();
        try (MemoryStack stack = MemoryStack.stackPush();){
            long ptr = stack.nmalloc(64);
            viewport.MVP.getToAddress(ptr);
            GL30C.nglUniformMatrix4fv((int)3, (int)1, (boolean)false, (long)ptr);
            viewport.MVP.invert(new Matrix4f()).getToAddress(ptr);
            GL30C.nglUniformMatrix4fv((int)4, (int)1, (boolean)false, (long)ptr);
        }
        ARBShaderImageLoadStore.glBindImageTexture((int)0, (int)this.colourSSAOTex.id, (int)0, (boolean)false, (int)0, (int)35002, (int)32856);
        GL45C.glBindTextureUnit((int)1, (int)this.fb.getDepthTex().id);
        GL45C.glBindTextureUnit((int)2, (int)this.colourTex.id);
        ARBComputeShader.glDispatchCompute((int)((viewport.width + 31) / 32), (int)((viewport.height + 31) / 32), (int)1);
        GL30C.glBindFramebuffer((int)36160, (int)this.fbSSAO.id);
    }

    @Override
    protected void finish(Viewport<?> viewport, int sourceFrameBuffer, int srcWidth, int srcHeight) {
        this.finalBlit.bind();
        if (this.useEnvFog) {
            float start = viewport.fogParameters.environmentalStart();
            float end = viewport.fogParameters.environmentalEnd();
            float invEndFogDelta = 1.0f / (end - start);
            float endDistance = class_310.method_1551().field_1773.method_3193() * 1.5f;
            GL30C.glUniform3f((int)4, (float)endDistance, (float)invEndFogDelta, (float)(Math.abs(start) * invEndFogDelta));
            GL30C.glUniform3f((int)5, (float)viewport.fogParameters.red(), (float)viewport.fogParameters.green(), (float)viewport.fogParameters.blue());
        }
        GL45C.glBindTextureUnit((int)3, (int)this.colourSSAOTex.id);
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        AbstractRenderPipeline.transformBlitDepth(this.finalBlit, this.fb.getDepthTex().id, sourceFrameBuffer, viewport, new Matrix4f((Matrix4fc)viewport.vanillaProjection).mul((Matrix4fc)viewport.modelView));
        GL30C.glDisable((int)3042);
    }

    @Override
    public void setupAndBindOpaque(Viewport<?> viewport) {
        this.fb.bind();
    }

    @Override
    public void setupAndBindTranslucent(Viewport<?> viewport) {
        GL30C.glBindFramebuffer((int)36160, (int)this.fbSSAO.id);
    }

    @Override
    public void free() {
        this.finalBlit.delete();
        this.ssaoCompute.free();
        this.fb.free();
        this.fbSSAO.free();
        if (this.colourTex != null) {
            this.colourTex.free();
            this.colourSSAOTex.free();
        }
        super.free0();
    }
}

