/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.gl;

import me.cortex.voxy.client.core.gl.shader.ShaderType;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GLCapabilities;

public class Capabilities {
    public static final Capabilities INSTANCE = new Capabilities();
    public final boolean repFragTest;
    public final boolean meshShaders;
    public final boolean INT64_t;
    public final long ssboMaxSize;
    public final boolean isMesa;
    public final boolean canQueryGpuMemory;
    public final long totalDedicatedMemory;
    public final long totalDynamicMemory;
    public final boolean compute;
    public final boolean indirectParameters;
    public final boolean isIntel;
    public final boolean subgroup;
    public final boolean sparseBuffer;
    public final boolean isNvidia;

    public Capabilities() {
        GLCapabilities cap = GL.getCapabilities();
        this.sparseBuffer = cap.GL_ARB_sparse_buffer;
        this.compute = cap.glDispatchComputeIndirect != 0L;
        this.indirectParameters = cap.glMultiDrawElementsIndirectCountARB != 0L;
        this.repFragTest = cap.GL_NV_representative_fragment_test;
        this.meshShaders = cap.GL_NV_mesh_shader;
        this.canQueryGpuMemory = cap.GL_NVX_gpu_memory_info;
        this.INT64_t = Capabilities.testShaderCompilesOk(ShaderType.COMPUTE, "#version 430\n#extension GL_ARB_gpu_shader_int64 : require\nlayout(local_size_x=32) in;\nvoid main() {\n    uint64_t a = 1234;\n}\n");
        this.subgroup = cap.GL_KHR_shader_subgroup ? Capabilities.testShaderCompilesOk(ShaderType.COMPUTE, "#version 430\n#extension GL_KHR_shader_subgroup_basic : require\n#extension GL_KHR_shader_subgroup_arithmetic : require\nlayout(local_size_x=32) in;\nvoid main() {\n    uint a = subgroupExclusiveAdd(gl_LocalInvocationIndex);\n}\n") : false;
        this.ssboMaxSize = GL32.glGetInteger64((int)37086);
        this.isMesa = GL11.glGetString((int)7938).toLowerCase().contains("mesa");
        this.isIntel = GL11.glGetString((int)7936).toLowerCase().contains("intel");
        this.isNvidia = GL11.glGetString((int)7936).toLowerCase().contains("nvidia");
        if (this.canQueryGpuMemory) {
            this.totalDedicatedMemory = GL32.glGetInteger64((int)36935) * 1024L;
            this.totalDynamicMemory = GL32.glGetInteger64((int)36936) * 1024L - this.totalDedicatedMemory;
        } else {
            this.totalDedicatedMemory = -1L;
            this.totalDynamicMemory = -1L;
        }
    }

    public static void init() {
    }

    private static boolean testShaderCompilesOk(ShaderType type, String src) {
        int shader = GL20C.glCreateShader((int)type.gl);
        GL20C.glShaderSource((int)shader, (CharSequence)src);
        GL20C.glCompileShader((int)shader);
        int result = GL20C.glGetShaderi((int)shader, (int)35713);
        GL20C.glDeleteShader((int)shader);
        return result == 1;
    }

    public long getFreeDedicatedGpuMemory() {
        if (!this.canQueryGpuMemory) {
            throw new IllegalStateException("Cannot query gpu memory, missing extension");
        }
        return GL32.glGetInteger64((int)36937) * 1024L;
    }
}

