/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.gl;

import me.cortex.voxy.client.core.gl.GlDebug;
import me.cortex.voxy.common.util.TrackedObject;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.MemoryUtil;

public class GlBuffer
extends TrackedObject {
    public final int id;
    private final long size;
    private final int flags;
    private static int COUNT;
    private static long TOTAL_SIZE;
    private static final long SCRATCH;

    public GlBuffer(long size) {
        this(size, 0);
    }

    public GlBuffer(long size, boolean zero) {
        this(size, 0, zero);
    }

    public GlBuffer(long size, int flags) {
        this(size, flags, true);
    }

    public GlBuffer(long size, int flags, boolean zero) {
        this.flags = flags;
        this.id = GL45C.glCreateBuffers();
        this.size = size;
        GL45C.glNamedBufferStorage((int)this.id, (long)size, (int)flags);
        if ((flags & 0x400) == 0 && zero) {
            this.zero();
        }
        ++COUNT;
        TOTAL_SIZE += size;
    }

    @Override
    public void free() {
        this.free0();
        GL15.glDeleteBuffers((int)this.id);
        --COUNT;
        TOTAL_SIZE -= this.size;
    }

    public boolean isSparse() {
        return (this.flags & 0x400) != 0;
    }

    public long size() {
        return this.size;
    }

    public GlBuffer zero() {
        GL45C.nglClearNamedBufferData((int)this.id, (int)33330, (int)36244, (int)5121, (long)0L);
        return this;
    }

    public GlBuffer zeroRange(long offset, long size) {
        GL45C.nglClearNamedBufferSubData((int)this.id, (int)33330, (long)offset, (long)size, (int)36244, (int)5121, (long)0L);
        return this;
    }

    public GlBuffer fill(int data) {
        GL45C.glPixelStorei((int)3315, (int)0);
        GL45C.glPixelStorei((int)3316, (int)0);
        MemoryUtil.memPutInt((long)SCRATCH, (int)data);
        GL45C.nglClearNamedBufferData((int)this.id, (int)33334, (int)36244, (int)5125, (long)SCRATCH);
        return this;
    }

    public static int getCount() {
        return COUNT;
    }

    public static long getTotalSize() {
        return TOTAL_SIZE;
    }

    public GlBuffer name(String name) {
        return GlDebug.name(name, this);
    }

    static {
        SCRATCH = MemoryUtil.nmemAlloc((long)4L);
    }
}

