/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.gl;

import me.cortex.voxy.client.core.gl.GlDebug;
import me.cortex.voxy.client.core.gl.GlRenderBuffer;
import me.cortex.voxy.client.core.gl.GlTexture;
import me.cortex.voxy.common.util.TrackedObject;
import org.lwjgl.opengl.GL45C;

public class GlFramebuffer
extends TrackedObject {
    public final int id = GL45C.glCreateFramebuffers();

    public GlFramebuffer bind(int attachment, GlTexture texture) {
        return this.bind(attachment, texture, 0);
    }

    public GlFramebuffer bind(int attachment, GlTexture texture, int lvl) {
        GL45C.glNamedFramebufferTexture((int)this.id, (int)attachment, (int)texture.id, (int)lvl);
        return this;
    }

    public GlFramebuffer bind(int attachment, GlRenderBuffer buffer) {
        GL45C.glNamedFramebufferRenderbuffer((int)this.id, (int)attachment, (int)36161, (int)buffer.id);
        return this;
    }

    public GlFramebuffer setDrawBuffers(int ... buffers) {
        GL45C.glNamedFramebufferDrawBuffers((int)this.id, (int[])buffers);
        return this;
    }

    @Override
    public void free() {
        super.free0();
        GL45C.glDeleteFramebuffers((int)this.id);
    }

    public GlFramebuffer verify() {
        int code = GL45C.glCheckNamedFramebufferStatus((int)this.id, (int)36160);
        if (code != 36053) {
            throw new IllegalStateException("Framebuffer incomplete with error code: " + code);
        }
        return this;
    }

    public GlFramebuffer name(String name) {
        return GlDebug.name(name, this);
    }
}

