/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.gl;

import me.cortex.voxy.client.core.gl.GlDebug;
import me.cortex.voxy.common.util.TrackedObject;
import org.lwjgl.opengl.GL45C;

public class GlTexture
extends TrackedObject {
    public final int id;
    private final int type;
    private int format;
    private int width;
    private int height;
    private int levels;
    private boolean hasAllocated;
    private static int COUNT;
    private static long ESTIMATED_TOTAL_SIZE;

    public GlTexture() {
        this(3553);
    }

    public GlTexture(int type) {
        this.id = GL45C.glCreateTextures((int)type);
        this.type = type;
        ++COUNT;
    }

    private GlTexture(int type, boolean useGenTypes) {
        this.id = useGenTypes ? GL45C.glGenTextures() : GL45C.glCreateTextures((int)type);
        this.type = type;
        ++COUNT;
    }

    public GlTexture store(int format, int levels, int width, int height) {
        if (this.hasAllocated) {
            throw new IllegalStateException("Texture already allocated");
        }
        this.hasAllocated = true;
        this.format = format;
        if (this.type != 3553) {
            throw new IllegalStateException("Unknown texture type");
        }
        GL45C.glTextureStorage2D((int)this.id, (int)levels, (int)format, (int)width, (int)height);
        this.width = width;
        this.height = height;
        this.levels = levels;
        ESTIMATED_TOTAL_SIZE += this.getEstimatedSize();
        return this;
    }

    public GlTexture createView() {
        this.assertAllocated();
        GlTexture view = new GlTexture(this.type, true);
        GL45C.glTextureView((int)view.id, (int)this.type, (int)this.id, (int)this.format, (int)0, (int)1, (int)0, (int)1);
        return view;
    }

    @Override
    public void free() {
        if (this.hasAllocated) {
            ESTIMATED_TOTAL_SIZE -= this.getEstimatedSize();
        }
        --COUNT;
        this.hasAllocated = false;
        super.free0();
        GL45C.glDeleteTextures((int)this.id);
    }

    public GlTexture name(String name) {
        this.assertAllocated();
        return GlDebug.name(name, this);
    }

    public int getWidth() {
        this.assertAllocated();
        return this.width;
    }

    public int getHeight() {
        this.assertAllocated();
        return this.height;
    }

    public int getLevels() {
        this.assertAllocated();
        return this.levels;
    }

    private long getEstimatedSize() {
        this.assertAllocated();
        long elemSize = switch (this.format) {
            case 32856, 33326, 33334, 35056 -> 4L;
            case 33190 -> 4L;
            case 36012 -> 4L;
            case 33191 -> 4L;
            default -> throw new IllegalStateException("Unknown element size");
        };
        long size = 0L;
        for (int lvl = 0; lvl < this.levels; ++lvl) {
            size += Math.max((long)this.width >> lvl, 1L) * Math.max((long)this.height >> lvl, 1L) * elemSize;
        }
        return size;
    }

    public void assertAllocated() {
        if (!this.hasAllocated) {
            throw new IllegalStateException("Texture not yet allocated");
        }
    }

    public static int getCount() {
        return COUNT;
    }

    public static long getEstimatedTotalSize() {
        return ESTIMATED_TOTAL_SIZE;
    }
}

