/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.gl.shader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.cortex.voxy.client.core.gl.Capabilities;
import me.cortex.voxy.client.core.gl.GlDebug;
import me.cortex.voxy.client.core.gl.shader.AutoBindingShader;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.ShaderLoader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.ThreadUtils;
import me.cortex.voxy.common.util.TrackedObject;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Shader
extends TrackedObject {
    private final int id;

    Shader(int program) {
        this.id = program;
    }

    public int id() {
        return this.id;
    }

    public void bind() {
        GL20.glUseProgram((int)this.id);
    }

    @Override
    public void free() {
        super.free0();
        GL20.glDeleteProgram((int)this.id);
    }

    public Shader name(String name) {
        return GlDebug.name(name, this);
    }

    public static Builder<Shader> make(IShaderProcessor ... processor) {
        return Shader.makeInternal((a, b) -> new Shader(b), processor);
    }

    public static Builder<AutoBindingShader> makeAuto(IShaderProcessor ... processor) {
        return Shader.makeInternal(AutoBindingShader::new, processor);
    }

    static <T extends Shader> Builder<T> makeInternal(Builder.IShaderObjectConstructor<T> constructor, IShaderProcessor[] processors) {
        ArrayList<IShaderProcessor> aa = new ArrayList<IShaderProcessor>(List.of(processors));
        Collections.reverse(aa);
        IShaderProcessor applicator = (type, source) -> source;
        for (IShaderProcessor processor : processors) {
            IShaderProcessor finalApplicator = applicator;
            applicator = (type, source) -> finalApplicator.process(type, processor.process(type, source));
        }
        return new Builder<T>(constructor, applicator);
    }

    public static class Builder<T extends Shader> {
        final Map<String, String> defines = new HashMap<String, String>();
        private final Map<ShaderType, String> sources = new HashMap<ShaderType, String>();
        private final IShaderProcessor processor;
        private final IShaderObjectConstructor<T> constructor;

        private Builder(IShaderObjectConstructor<T> constructor, IShaderProcessor processor) {
            this.constructor = constructor;
            this.processor = processor;
        }

        public Builder<T> clone() {
            Builder<T> clone = new Builder<T>(this.constructor, this.processor);
            clone.defines.putAll(this.defines);
            clone.sources.putAll(this.sources);
            return clone;
        }

        public Builder<T> define(String name) {
            this.defines.put(name, "");
            return this;
        }

        public Builder<T> defineIf(String name, boolean condition) {
            if (condition) {
                this.defines.put(name, "");
            }
            return this;
        }

        public Builder<T> defineIf(String name, boolean condition, int value) {
            if (condition) {
                this.defines.put(name, Integer.toString(value));
            }
            return this;
        }

        public Builder<T> define(String name, int value) {
            this.defines.put(name, Integer.toString(value));
            return this;
        }

        public Builder<T> define(String name, String value) {
            this.defines.put(name, value);
            return this;
        }

        public Builder<T> add(ShaderType type, String id) {
            this.addSource(type, ShaderLoader.parse(id));
            return this;
        }

        public Builder<T> addSource(ShaderType type, String source) {
            this.sources.put(type, this.processor.process(type, source));
            return this;
        }

        private int compileToProgram() {
            int program = GL20C.glCreateProgram();
            int[] shaders = new int[this.sources.size()];
            String defs = this.defines.entrySet().stream().map(a -> "#define " + (String)a.getKey() + " " + (String)a.getValue() + "\n").collect(Collectors.joining());
            int i = 0;
            for (Map.Entry<ShaderType, String> entry : this.sources.entrySet()) {
                Object src = entry.getValue();
                src = ((String)src).substring(0, ((String)src).indexOf(10) + 1) + defs + ((String)src).substring(((String)src).indexOf(10) + 1);
                shaders[i++] = Builder.createShader(entry.getKey(), (String)src);
            }
            for (int i2 : shaders) {
                GL20C.glAttachShader((int)program, (int)i2);
            }
            GL20C.glLinkProgram((int)program);
            for (int i3 : shaders) {
                GL20C.glDetachShader((int)program, (int)i3);
                GL20C.glDeleteShader((int)i3);
            }
            Builder.printProgramLinkLog(program);
            Builder.verifyProgramLinked(program);
            return program;
        }

        public T compile() {
            this.defineIf("IS_INTEL", Capabilities.INSTANCE.isIntel);
            this.defineIf("IS_WINDOWS", ThreadUtils.isWindows);
            return this.constructor.make(this, this.compileToProgram());
        }

        private static void printProgramLinkLog(int program) {
            String log = GL20C.glGetProgramInfoLog((int)program);
            if (!log.isEmpty()) {
                Logger.error(log);
            }
        }

        private static void verifyProgramLinked(int program) {
            int result = GL20C.glGetProgrami((int)program, (int)35714);
            if (result != 1) {
                throw new RuntimeException("Shader program linking failed, see log for details");
            }
        }

        private static int createShader(ShaderType type, String src) {
            int result;
            int shader = GL20C.glCreateShader((int)type.gl);
            long ptr = MemoryUtil.memAddress((ByteBuffer)MemoryUtil.memUTF8((CharSequence)src, (boolean)true));
            try (MemoryStack stack = MemoryStack.stackPush();){
                GL20C.nglShaderSource((int)shader, (int)1, (long)stack.pointers(ptr).address0(), (long)0L);
            }
            MemoryUtil.nmemFree((long)ptr);
            GL20C.glCompileShader((int)shader);
            String log = GL20C.glGetShaderInfoLog((int)shader);
            if (!log.isEmpty()) {
                Logger.warn(log);
            }
            if ((result = GL20C.glGetShaderi((int)shader, (int)35713)) != 1) {
                GL20C.glDeleteShader((int)shader);
                try {
                    Files.writeString(Path.of("SHADER_DUMP.txt", new String[0]), (CharSequence)src, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                throw new RuntimeException("Shader compilation failed of type " + type.name() + ", see log for details, dumped shader");
            }
            return shader;
        }

        protected static interface IShaderObjectConstructor<J extends Shader> {
            public J make(Builder<J> var1, int var2);
        }
    }
}

