/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.model;

import me.cortex.voxy.client.core.model.ColourDepthTextureData;
import net.caffeinemc.mods.sodium.client.util.color.ColorSRGB;
import net.minecraft.class_4725;

public class TextureUtils {
    public static final int WRITE_CHECK_STENCIL = 1;
    public static final int WRITE_CHECK_DEPTH = 2;
    public static final int WRITE_CHECK_ALPHA = 3;
    public static final int DEPTH_MODE_AVG = 1;
    public static final int DEPTH_MODE_MAX = 2;
    public static final int DEPTH_MODE_MIN = 3;

    public static int getWrittenPixelCount(ColourDepthTextureData texture, int checkMode) {
        int count = 0;
        for (int i = 0; i < texture.colour().length; ++i) {
            count += TextureUtils.wasPixelWritten(texture, checkMode, i) ? 1 : 0;
        }
        return count;
    }

    public static boolean isSolid(ColourDepthTextureData texture) {
        for (int pixel : texture.colour()) {
            if ((pixel >> 24 & 0xFF) == 255) continue;
            return false;
        }
        return true;
    }

    private static boolean wasPixelWritten(ColourDepthTextureData data, int mode, int index) {
        if (mode == 1) {
            return (data.depth()[index] & 0xFF) != 0;
        }
        if (mode == 2) {
            return data.depth()[index] >>> 8 != 0xFFFFFF;
        }
        if (mode == 3) {
            return (data.colour()[index] >>> 24 & 0xFF) > 1;
        }
        throw new IllegalArgumentException();
    }

    public static int computeFaceTint(ColourDepthTextureData texture, int checkMode) {
        boolean allTinted = true;
        boolean someTinted = false;
        boolean wasWriten = false;
        int[] colourData = texture.colour();
        int[] depthData = texture.depth();
        for (int i = 0; i < colourData.length; ++i) {
            if (!TextureUtils.wasPixelWritten(texture, checkMode, i) || (colourData[i] & 0xFFFFFF) == 0 || colourData[i] >>> 24 == 0) continue;
            boolean pixelTinited = (depthData[i] & 0x80) != 0;
            wasWriten |= true;
            allTinted &= pixelTinited;
            someTinted |= pixelTinited;
        }
        if (!wasWriten) {
            return 0;
        }
        return someTinted ? (allTinted ? 3 : 2) : 1;
    }

    public static float computeDepth(ColourDepthTextureData texture, int mode, int checkMode) {
        int[] colourData = texture.colour();
        int[] depthData = texture.depth();
        long a = 0L;
        long b = 0L;
        if (mode == 3) {
            a = Long.MAX_VALUE;
        }
        if (mode == 2) {
            a = Long.MIN_VALUE;
        }
        for (int i = 0; i < colourData.length; ++i) {
            if (!TextureUtils.wasPixelWritten(texture, checkMode, i)) continue;
            int depth = depthData[i] >>> 8;
            if (mode == 1) {
                ++a;
                b += (long)depth;
                continue;
            }
            if (mode == 2) {
                a = Math.max(a, (long)depth);
                continue;
            }
            if (mode != 3) continue;
            a = Math.min(a, (long)depth);
        }
        if (mode == 1) {
            if (a == 0L) {
                return -1.0f;
            }
            return TextureUtils.u2fdepth((int)(b / a));
        }
        if (mode == 2) {
            if (a == Long.MIN_VALUE) {
                return -1.0f;
            }
            return TextureUtils.u2fdepth((int)a);
        }
        if (mode == 3) {
            if (a == Long.MAX_VALUE) {
                return -1.0f;
            }
            return TextureUtils.u2fdepth((int)a);
        }
        throw new IllegalArgumentException();
    }

    private static float u2fdepth(int depth) {
        float depthF = (float)((double)depth / 1.6777215E7);
        if ((depthF *= 2.0f) > 1.00001f) {
            depthF = 1.0f;
        }
        return depthF;
    }

    public static int[] computeBounds(ColourDepthTextureData data, int checkMode) {
        int minX = 0;
        block0: do {
            for (int y = 0; y < data.height(); ++y) {
                int idx = minX + y * data.width();
                if (TextureUtils.wasPixelWritten(data, checkMode, idx)) break block0;
            }
        } while (++minX != data.width());
        int maxX = data.width() - 1;
        block2: do {
            for (int y = data.height() - 1; y != -1; --y) {
                int idx = maxX + y * data.width();
                if (TextureUtils.wasPixelWritten(data, checkMode, idx)) break block2;
            }
        } while (--maxX != -1);
        int minY = 0;
        block4: do {
            for (int x = 0; x < data.width(); ++x) {
                int idx = minY * data.height() + x;
                if (TextureUtils.wasPixelWritten(data, checkMode, idx)) break block4;
            }
        } while (++minY != data.height());
        int maxY = data.height() - 1;
        block6: do {
            for (int x = data.width() - 1; x != -1; --x) {
                int idx = maxY * data.height() + x;
                if (TextureUtils.wasPixelWritten(data, checkMode, idx)) break block6;
            }
        } while (--maxY != -1);
        return new int[]{minX, maxX, minY, maxY};
    }

    public static int mipColours(int one, int two, int three, int four) {
        return class_4725.method_24101((int)one, (int)two, (int)three, (int)four, (boolean)false);
    }

    private static int weightedAverageColor(int a, int b) {
        if ((a & 0xFF000000) == 0) {
            return b;
        }
        if ((b & 0xFF000000) == 0) {
            return a;
        }
        if (((a ^ b) & 0xFF000000) == 0) {
            return ColorSRGB.linearToSrgb((float)TextureUtils.addHalfLinear(0, a, b), (float)TextureUtils.addHalfLinear(8, a, b), (float)TextureUtils.addHalfLinear(16, a, b), (int)(a >>> 24));
        }
        int A2 = a >>> 24;
        int B2 = a >>> 24;
        float mul = 1.0f / (float)(A2 + B2);
        float wA = (float)A2 * mul;
        float wB = (float)B2 * mul;
        return ColorSRGB.linearToSrgb((float)TextureUtils.addMulLinear(0, a, b, wA, wB), (float)TextureUtils.addMulLinear(8, a, b, wA, wB), (float)TextureUtils.addMulLinear(16, a, b, wA, wB), (int)((A2 + B2) / 2));
    }

    private static float addHalfLinear(int shift, int a, int b) {
        return TextureUtils.addMulLinear(shift, a, b, 0.5f, 0.5f);
    }

    private static float addMulLinear(int shift, int a, int b, float mulA, float mulB) {
        return Math.fma(ColorSRGB.srgbToLinear((int)(a >> shift & 0xFF)), mulA, ColorSRGB.srgbToLinear((int)(b >> shift & 0xFF)) * mulB);
    }
}

