/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.model.bakery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.cortex.voxy.client.core.model.bakery.BudgetBufferRenderer;
import me.cortex.voxy.client.core.model.bakery.ReuseVertexConsumer;
import me.cortex.voxy.common.Logger;
import net.minecraft.class_10868;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_827;
import org.joml.Matrix4f;

public class BakedBlockEntityModel {
    private final List<LayerConsumer> layers;

    private BakedBlockEntityModel(List<LayerConsumer> layers) {
        this.layers = layers;
    }

    public void render(Matrix4f matrix, int texId) {
        for (LayerConsumer layer : this.layers) {
            if (layer.consumer.isEmpty()) continue;
            class_1921 class_19212 = layer.layer;
            if (class_19212 instanceof class_1921.class_4687) {
                class_1921.class_4687 mp = (class_1921.class_4687)class_19212;
                class_2960 textureId = mp.field_21403.field_21406.method_23564().orElse(null);
                if (textureId == null) {
                    Logger.error("ERROR: Empty texture id for layer: " + String.valueOf(layer));
                } else {
                    texId = ((class_10868)class_310.method_1551().method_1531().method_4619(textureId).method_68004()).method_68427();
                }
            }
            if (texId == 0) continue;
            BudgetBufferRenderer.setup(layer.consumer.getAddress(), layer.consumer.quadCount(), texId);
            BudgetBufferRenderer.render(matrix);
        }
    }

    public void release() {
        this.layers.forEach(layer -> layer.consumer.free());
    }

    private static int getMetaFromLayer(class_1921 layer) {
        boolean hasDiscard = layer == class_1921.method_23581() || layer == class_1921.method_23579() || layer == class_1921.method_29997();
        boolean isMipped = layer == class_1921.method_23579() || layer == class_1921.method_23577() || layer.method_60894() || layer == class_1921.method_29997();
        int meta = hasDiscard ? 1 : 0;
        return meta |= isMipped ? 2 : 0;
    }

    public static BakedBlockEntityModel bake(class_2680 state) {
        HashMap map = new HashMap();
        class_2586 entity = ((class_2343)state.method_26204()).method_10123(class_2338.field_10980, state);
        if (entity == null) {
            return null;
        }
        class_827 renderer = class_310.method_1551().method_31975().method_3550(entity);
        entity.method_31662((class_1937)class_310.method_1551().field_1687);
        if (renderer != null) {
            // empty if block
        }
        entity.method_11012();
        if (map.isEmpty()) {
            return null;
        }
        for (LayerConsumer i : new ArrayList(map.values())) {
            if (!i.consumer.isEmpty()) continue;
            map.remove(i.layer);
            i.consumer.free();
        }
        if (map.isEmpty()) {
            return null;
        }
        return new BakedBlockEntityModel(new ArrayList<LayerConsumer>(map.values()));
    }

    private record LayerConsumer(class_1921 layer, ReuseVertexConsumer consumer) {
    }
}

