/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.model.bakery;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.GlVertexArray;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import net.minecraft.class_10859;
import net.minecraft.class_10868;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL45;
import org.lwjgl.system.MemoryUtil;

public class BudgetBufferRenderer {
    public static final int VERTEX_FORMAT_SIZE = 24;
    private static final Shader bakeryShader = Shader.make(new IShaderProcessor[0]).add(ShaderType.VERTEX, "voxy:bakery/position_tex.vsh").add(ShaderType.FRAGMENT, "voxy:bakery/position_tex.fsh").compile();
    private static final GlBuffer indexBuffer;
    private static final int STRIDE = 24;
    private static final GlVertexArray VA;
    private static GlBuffer immediateBuffer;
    private static int quadCount;

    public static void init() {
    }

    public static void drawFast(class_9801 buffer, GpuTexture tex, Matrix4f matrix) {
        if (buffer.method_60822().comp_752() != VertexFormat.class_5596.field_27382) {
            throw new IllegalStateException("Fast only supports quads");
        }
        ByteBuffer buff = buffer.method_60818();
        int size = buff.remaining();
        if (size % 24 != 0) {
            throw new IllegalStateException();
        }
        if ((size /= 24) % 4 != 0) {
            throw new IllegalStateException();
        }
        BudgetBufferRenderer.setup(MemoryUtil.memAddress((ByteBuffer)buff), size /= 4, ((class_10868)tex).method_68427());
        buffer.close();
        BudgetBufferRenderer.render(matrix);
    }

    public static void setup(long dataPtr, int quads, int texId) {
        if (quads == 0) {
            throw new IllegalStateException();
        }
        quadCount = quads;
        long size = (long)quads * 4L * 24L;
        if (immediateBuffer == null || immediateBuffer.size() < size) {
            if (immediateBuffer != null) {
                immediateBuffer.free();
            }
            immediateBuffer = new GlBuffer(size * 2L);
            VA.bindBuffer(BudgetBufferRenderer.immediateBuffer.id);
        }
        long ptr = UploadStream.INSTANCE.upload(immediateBuffer, 0L, size);
        MemoryUtil.memCopy((long)dataPtr, (long)ptr, (long)size);
        UploadStream.INSTANCE.commit();
        bakeryShader.bind();
        VA.bind();
        GL45.glMemoryBarrier((int)1);
        GL33.glBindSampler((int)0, (int)0);
        GL45.glBindTextureUnit((int)0, (int)texId);
    }

    public static void render(Matrix4f matrix) {
        GL20.glUniformMatrix4fv((int)1, (boolean)false, (float[])matrix.get(new float[16]));
        GL45.glDrawElements((int)4, (int)(quadCount * 2 * 3), (int)5123, (long)0L);
    }

    static {
        RenderSystem.class_5590 i = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        int id = ((class_10859)i.method_68274((int)24576)).field_57842;
        if (i.method_31924() != VertexFormat.class_5595.field_27372) {
            throw new IllegalStateException();
        }
        indexBuffer = new GlBuffer(49152L);
        GL45.glCopyNamedBufferSubData((int)id, (int)BudgetBufferRenderer.indexBuffer.id, (long)0L, (long)0L, (long)49152L);
        VA = new GlVertexArray().setStride(24).setF(0, 5126, 4, 0).setF(1, 5126, 2, 16).bindElementBuffer(BudgetBufferRenderer.indexBuffer.id);
    }
}

