/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.model.bakery;

import me.cortex.voxy.common.util.MemoryBuffer;
import net.minecraft.class_4588;
import net.minecraft.class_777;
import org.lwjgl.system.MemoryUtil;

public final class ReuseVertexConsumer
implements class_4588 {
    private MemoryBuffer buffer = new MemoryBuffer(8192L);
    private long ptr;
    private int count;
    private int defaultMeta;

    public ReuseVertexConsumer() {
        this.reset();
    }

    public ReuseVertexConsumer setDefaultMeta(int meta) {
        this.defaultMeta = meta;
        return this;
    }

    public ReuseVertexConsumer addVertex(float x, float y, float z) {
        this.ensureCanPut();
        this.ptr += 24L;
        ++this.count;
        this.meta(this.defaultMeta);
        MemoryUtil.memPutFloat((long)this.ptr, (float)x);
        MemoryUtil.memPutFloat((long)(this.ptr + 4L), (float)y);
        MemoryUtil.memPutFloat((long)(this.ptr + 8L), (float)z);
        return this;
    }

    public ReuseVertexConsumer meta(int metadata) {
        MemoryUtil.memPutInt((long)(this.ptr + 12L), (int)metadata);
        return this;
    }

    public ReuseVertexConsumer setColor(int red, int green, int blue, int alpha) {
        return this;
    }

    public ReuseVertexConsumer setUv(float u, float v) {
        MemoryUtil.memPutFloat((long)(this.ptr + 16L), (float)u);
        MemoryUtil.memPutFloat((long)(this.ptr + 20L), (float)v);
        return this;
    }

    public ReuseVertexConsumer setUv1(int u, int v) {
        return this;
    }

    public ReuseVertexConsumer setUv2(int u, int v) {
        return this;
    }

    public ReuseVertexConsumer setNormal(float x, float y, float z) {
        return this;
    }

    public ReuseVertexConsumer quad(class_777 quad, int metadata) {
        this.ensureCanPut();
        int[] data = quad.comp_3721();
        for (int i = 0; i < 4; ++i) {
            float x = Float.intBitsToFloat(data[i * 8]);
            float y = Float.intBitsToFloat(data[i * 8 + 1]);
            float z = Float.intBitsToFloat(data[i * 8 + 2]);
            this.addVertex(x, y, z);
            float u = Float.intBitsToFloat(data[i * 8 + 4]);
            float v = Float.intBitsToFloat(data[i * 8 + 5]);
            this.setUv(u, v);
            this.meta(metadata);
        }
        return this;
    }

    private void ensureCanPut() {
        if ((long)(this.count + 5) * 24L < this.buffer.size) {
            return;
        }
        long offset = this.ptr - this.buffer.address;
        MemoryBuffer newBuffer = new MemoryBuffer(((int)(this.buffer.size * 2L) + 24 - 1) / 24 * 24);
        this.buffer.cpyTo(newBuffer.address);
        this.buffer.free();
        this.buffer = newBuffer;
        this.ptr = offset + newBuffer.address;
    }

    public ReuseVertexConsumer reset() {
        this.defaultMeta = 0;
        this.count = 0;
        this.ptr = this.buffer.address - 24L;
        return this;
    }

    public void free() {
        this.ptr = 0L;
        this.count = 0;
        this.buffer.free();
        this.buffer = null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int quadCount() {
        if (this.count % 4 != 0) {
            throw new IllegalStateException();
        }
        return this.count / 4;
    }

    public long getAddress() {
        return this.buffer.address;
    }
}

