/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.cortex.voxy.client.core.rendering.Viewport;
import me.cortex.voxy.client.core.util.IrisUtil;
import net.fabricmc.loader.api.FabricLoader;
import org.vivecraft.api.client.VRRenderingAPI;
import org.vivecraft.api.client.data.RenderPass;

public class ViewportSelector<T extends Viewport<?>> {
    public static final boolean VIVECRAFT_INSTALLED = FabricLoader.getInstance().isModLoaded("vivecraft");
    private final Supplier<T> creator;
    private final T defaultViewport;
    private final Map<Object, T> extraViewports = new HashMap<Object, T>();
    private static final Object IRIS_SHADOW_OBJECT = new Object();

    public ViewportSelector(Supplier<T> viewportCreator) {
        this.creator = viewportCreator;
        this.defaultViewport = (Viewport)viewportCreator.get();
    }

    private T getOrCreate(Object holder) {
        return (T)this.extraViewports.computeIfAbsent(holder, a -> (Viewport)this.creator.get());
    }

    private T getVivecraftViewport() {
        RenderPass pass = VRRenderingAPI.instance().getCurrentRenderPass();
        if (pass == null || pass == RenderPass.VANILLA) {
            return null;
        }
        return this.getOrCreate(pass);
    }

    public T getViewport() {
        T viewport = null;
        if (viewport == null && VIVECRAFT_INSTALLED) {
            viewport = this.getVivecraftViewport();
        }
        if (viewport == null && IrisUtil.irisShadowActive()) {
            viewport = this.getOrCreate(IRIS_SHADOW_OBJECT);
        }
        if (viewport == null) {
            viewport = this.defaultViewport;
        }
        return viewport;
    }

    public void free() {
        ((Viewport)this.defaultViewport).delete();
        this.extraViewports.values().forEach(Viewport::delete);
        this.extraViewports.clear();
    }
}

