/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.hierachical;

import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.GlVertexArray;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import me.cortex.voxy.client.core.rendering.Viewport;
import me.cortex.voxy.client.core.rendering.util.SharedIndexBuffer;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import net.minecraft.class_3532;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL43;
import org.lwjgl.system.MemoryUtil;

public class DebugRenderer {
    private final Shader debugShader = Shader.make(new IShaderProcessor[0]).add(ShaderType.VERTEX, "voxy:lod/hierarchical/debug/node_outline.vert").add(ShaderType.FRAGMENT, "voxy:lod/hierarchical/debug/frag.frag").compile();
    private final Shader setupShader = Shader.make(new IShaderProcessor[0]).add(ShaderType.COMPUTE, "voxy:lod/hierarchical/debug/setup.comp").compile();
    private final GlBuffer uniformBuffer = new GlBuffer(1024L).zero();
    private final GlBuffer drawBuffer = new GlBuffer(1024L).zero();

    private void uploadUniform(Viewport<?> viewport) {
        long ptr = UploadStream.INSTANCE.upload(this.uniformBuffer, 0L, 1024L);
        int sx = class_3532.method_15357((double)viewport.cameraX) >> 5;
        int sy = class_3532.method_15357((double)viewport.cameraY) >> 5;
        int sz = class_3532.method_15357((double)viewport.cameraZ) >> 5;
        new Matrix4f((Matrix4fc)viewport.projection).mul((Matrix4fc)viewport.modelView).getToAddress(ptr);
        MemoryUtil.memPutInt((long)(ptr += 64L), (int)sx);
        MemoryUtil.memPutInt((long)(ptr += 4L), (int)sy);
        MemoryUtil.memPutInt((long)(ptr += 4L), (int)sz);
        MemoryUtil.memPutInt((long)(ptr += 4L), (int)viewport.width);
        Vector3f innerTranslation = new Vector3f((float)(viewport.cameraX - (double)(sx << 5)), (float)(viewport.cameraY - (double)(sy << 5)), (float)(viewport.cameraZ - (double)(sz << 5)));
        innerTranslation.getToAddress(ptr += 4L);
        MemoryUtil.memPutInt((long)(ptr += 12L), (int)viewport.height);
        ptr += 4L;
    }

    public void render(Viewport<?> viewport, GlBuffer nodeData, GlBuffer nodeList) {
        this.uploadUniform(viewport);
        UploadStream.INSTANCE.commit();
        this.setupShader.bind();
        GL43.glBindBufferBase((int)37074, (int)0, (int)this.drawBuffer.id);
        GL43.glBindBufferBase((int)37074, (int)1, (int)nodeList.id);
        GL43.glDispatchCompute((int)1, (int)1, (int)1);
        GL42.glMemoryBarrier((int)8256);
        GL43.glEnable((int)2929);
        this.debugShader.bind();
        GL43.glBindVertexArray((int)GlVertexArray.STATIC_VAO);
        GL15C.glBindBuffer((int)36671, (int)this.drawBuffer.id);
        GL15.glBindBuffer((int)34963, (int)SharedIndexBuffer.INSTANCE_BYTE.id());
        GL43.glBindBufferBase((int)35345, (int)0, (int)this.uniformBuffer.id);
        GL43.glBindBufferBase((int)37074, (int)1, (int)nodeData.id);
        GL43.glBindBufferBase((int)37074, (int)2, (int)nodeList.id);
        GL40.glDrawElementsIndirect((int)4, (int)5121, (long)0L);
    }

    public void free() {
        this.drawBuffer.free();
        this.uniformBuffer.free();
        this.debugShader.free();
        this.setupShader.free();
    }
}

