/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.hierachical;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import me.cortex.voxy.client.RenderStatistics;
import me.cortex.voxy.client.config.VoxyConfig;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.shader.AutoBindingShader;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import me.cortex.voxy.client.core.rendering.Viewport;
import me.cortex.voxy.client.core.rendering.building.RenderGenerationService;
import me.cortex.voxy.client.core.rendering.hierachical.AsyncNodeManager;
import me.cortex.voxy.client.core.rendering.hierachical.NodeCleaner;
import me.cortex.voxy.client.core.rendering.util.DownloadStream;
import me.cortex.voxy.client.core.rendering.util.PrintfDebugUtil;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.MemoryBuffer;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL45;
import org.lwjgl.system.MemoryUtil;

public class HierarchicalOcclusionTraverser {
    public static final boolean HIERARCHICAL_SHADER_DEBUG = System.getProperty("voxy.hierarchicalShaderDebug", "false").equals("true");
    public static final int MAX_REQUEST_QUEUE_SIZE = 50;
    public static final int MAX_QUEUE_SIZE = 200000;
    private static final int MAX_ITERATIONS = 5;
    private static final int LOCAL_WORK_SIZE_BITS = 5;
    private final AsyncNodeManager nodeManager;
    private final NodeCleaner nodeCleaner;
    private final RenderGenerationService meshGen;
    private final GlBuffer requestBuffer;
    private final GlBuffer nodeBuffer;
    private final GlBuffer uniformBuffer = new GlBuffer(1024L).zero();
    private final GlBuffer statisticsBuffer = new GlBuffer(1024L).zero();
    private int topNodeCount;
    private final Int2IntOpenHashMap topNode2idxMapping = new Int2IntOpenHashMap();
    private final int[] idx2topNodeMapping = new int[200000];
    private final GlBuffer topNodeIds = new GlBuffer(800000L).zero();
    private final GlBuffer queueMetaBuffer = new GlBuffer(80L).zero();
    private final GlBuffer scratchQueueA = new GlBuffer(800000L).zero();
    private final GlBuffer scratchQueueB = new GlBuffer(800000L).zero();
    private static int BINDING_COUNTER = 1;
    private static final int SCENE_UNIFORM_BINDING = BINDING_COUNTER++;
    private static final int REQUEST_QUEUE_BINDING = BINDING_COUNTER++;
    private static final int RENDER_QUEUE_BINDING = BINDING_COUNTER++;
    private static final int NODE_DATA_BINDING = BINDING_COUNTER++;
    private static final int NODE_QUEUE_INDEX_BINDING = BINDING_COUNTER++;
    private static final int NODE_QUEUE_META_BINDING = BINDING_COUNTER++;
    private static final int NODE_QUEUE_SOURCE_BINDING = BINDING_COUNTER++;
    private static final int NODE_QUEUE_SINK_BINDING = BINDING_COUNTER++;
    private static final int RENDER_TRACKER_BINDING = BINDING_COUNTER++;
    private static final int STATISTICS_BUFFER_BINDING = BINDING_COUNTER++;
    private final int hizSampler = GL45.glGenSamplers();
    private final AutoBindingShader traversal = Shader.makeAuto(PrintfDebugUtil.PRINTF_processor).defineIf("DEBUG", HIERARCHICAL_SHADER_DEBUG).define("MAX_ITERATIONS", 5).define("LOCAL_SIZE_BITS", 5).define("MAX_REQUEST_QUEUE_SIZE", 50).define("HIZ_BINDING", 0).define("SCENE_UNIFORM_BINDING", SCENE_UNIFORM_BINDING).define("REQUEST_QUEUE_BINDING", REQUEST_QUEUE_BINDING).define("RENDER_QUEUE_BINDING", RENDER_QUEUE_BINDING).define("NODE_DATA_BINDING", NODE_DATA_BINDING).define("NODE_QUEUE_INDEX_BINDING", NODE_QUEUE_INDEX_BINDING).define("NODE_QUEUE_META_BINDING", NODE_QUEUE_META_BINDING).define("NODE_QUEUE_SOURCE_BINDING", NODE_QUEUE_SOURCE_BINDING).define("NODE_QUEUE_SINK_BINDING", NODE_QUEUE_SINK_BINDING).define("RENDER_TRACKER_BINDING", RENDER_TRACKER_BINDING).defineIf("HAS_STATISTICS", RenderStatistics.enabled).defineIf("STATISTICS_BUFFER_BINDING", RenderStatistics.enabled, STATISTICS_BUFFER_BINDING).add(ShaderType.COMPUTE, "voxy:lod/hierarchical/traversal_dev.comp").compile();
    private static final long SCRATCH = MemoryUtil.nmemAlloc((long)32L);

    public HierarchicalOcclusionTraverser(AsyncNodeManager nodeManager, NodeCleaner nodeCleaner, RenderGenerationService meshGen) {
        this.nodeCleaner = nodeCleaner;
        this.nodeManager = nodeManager;
        this.meshGen = meshGen;
        this.requestBuffer = new GlBuffer(408L).zero();
        this.nodeBuffer = new GlBuffer((long)nodeManager.maxNodeCount * 16L).fill(-1);
        GL45.glSamplerParameteri((int)this.hizSampler, (int)10241, (int)9984);
        GL45.glSamplerParameteri((int)this.hizSampler, (int)10240, (int)9728);
        GL45.glSamplerParameteri((int)this.hizSampler, (int)10243, (int)33071);
        GL45.glSamplerParameteri((int)this.hizSampler, (int)10242, (int)33071);
        this.traversal.ubo("SCENE_UNIFORM_BINDING", this.uniformBuffer).ssbo("REQUEST_QUEUE_BINDING", this.requestBuffer).ssbo("NODE_DATA_BINDING", this.nodeBuffer).ssbo("NODE_QUEUE_META_BINDING", this.queueMetaBuffer).ssbo("RENDER_TRACKER_BINDING", this.nodeCleaner.visibilityBuffer).ssboIf("STATISTICS_BUFFER_BINDING", this.statisticsBuffer);
        this.topNode2idxMapping.defaultReturnValue(-1);
        this.nodeManager.setTLNAddRemoveCallbacks(this::addTLN, this::remTLN);
    }

    private void addTLN(int id) {
        int aid = this.topNodeCount++;
        if ((long)this.topNodeCount > this.topNodeIds.size() / 4L) {
            throw new IllegalStateException("Top level node count greater than capacity");
        }
        MemoryUtil.memPutInt((long)SCRATCH, (int)id);
        GL45.nglClearNamedBufferSubData((int)this.topNodeIds.id, (int)33334, (long)((long)aid * 4L), (long)4L, (int)36244, (int)5125, (long)SCRATCH);
        if (this.topNode2idxMapping.put(id, aid) != -1) {
            throw new IllegalStateException();
        }
        this.idx2topNodeMapping[aid] = id;
    }

    private void remTLN(int id) {
        int endTLNId;
        int idx = this.topNode2idxMapping.remove(id);
        --this.topNodeCount;
        if (idx == -1) {
            throw new IllegalStateException();
        }
        if (idx == this.topNodeCount) {
            return;
        }
        this.idx2topNodeMapping[idx] = endTLNId = this.idx2topNodeMapping[this.topNodeCount];
        if (this.topNode2idxMapping.put(endTLNId, idx) == -1) {
            throw new IllegalStateException();
        }
        MemoryUtil.memPutInt((long)SCRATCH, (int)endTLNId);
        GL45.nglClearNamedBufferSubData((int)this.topNodeIds.id, (int)33334, (long)((long)idx * 4L), (long)4L, (int)36244, (int)5125, (long)SCRATCH);
    }

    private static void setFrustum(Viewport<?> viewport, long ptr) {
        for (int i = 0; i < 6; ++i) {
            Vector4f plane = viewport.frustumPlanes[i];
            plane.getToAddress(ptr);
            ptr += 16L;
        }
    }

    private void uploadUniform(Viewport<?> viewport) {
        long ptr = UploadStream.INSTANCE.upload(this.uniformBuffer, 0L, 1024L);
        viewport.MVP.getToAddress(ptr);
        viewport.section.getToAddress(ptr += 64L);
        MemoryUtil.memPutInt((long)(ptr += 12L), (int)viewport.hiZBuffer.getPackedLevels());
        viewport.innerTranslation.getToAddress(ptr += 4L);
        float screenspaceAreaDecreasingSize = VoxyConfig.CONFIG.subDivisionSize * VoxyConfig.CONFIG.subDivisionSize;
        MemoryUtil.memPutFloat((long)(ptr += 12L), (float)(screenspaceAreaDecreasingSize / (float)(viewport.width * viewport.height)));
        HierarchicalOcclusionTraverser.setFrustum(viewport, ptr += 4L);
        MemoryUtil.memPutInt((long)(ptr += 96L), (int)((int)(viewport.getRenderList().size() / 4L - 1L)));
        MemoryUtil.memPutInt((long)(ptr += 4L), (int)this.nodeCleaner.visibilityId);
        double TARGET_COUNT = 4000.0;
        double iFillness = Math.max(0.0, (4000.0 - (double)this.meshGen.getTaskCount()) / 4000.0);
        iFillness = Math.pow(iFillness, 2.0);
        int requestSize = (int)Math.ceil(iFillness * 50.0);
        MemoryUtil.memPutInt((long)(ptr += 4L), (int)Math.max(0, Math.min(50, requestSize)));
        ptr += 4L;
    }

    private void bindings(Viewport<?> viewport) {
        GL45.glBindBuffer((int)37102, (int)this.queueMetaBuffer.id);
        GL45.glBindTextureUnit((int)0, (int)viewport.hiZBuffer.getHizTextureId());
        GL45.glBindSampler((int)0, (int)this.hizSampler);
        GL45.glBindBufferBase((int)37074, (int)RENDER_QUEUE_BINDING, (int)viewport.getRenderList().id);
    }

    public void doTraversal(Viewport<?> viewport) {
        this.uploadUniform(viewport);
        this.traversal.bind();
        this.bindings(viewport);
        PrintfDebugUtil.bind();
        if (RenderStatistics.enabled) {
            this.statisticsBuffer.zero();
        }
        GL45.nglClearNamedBufferSubData((int)viewport.getRenderList().id, (int)33334, (long)0L, (long)4L, (int)36244, (int)5125, (long)0L);
        this.traverseInternal();
        this.downloadResetRequestQueue();
        if (RenderStatistics.enabled) {
            DownloadStream.INSTANCE.download(this.statisticsBuffer, down -> {
                int i;
                for (i = 0; i < 5; ++i) {
                    RenderStatistics.hierarchicalTraversalCounts[i] = MemoryUtil.memGetInt((long)(down.address + (long)i * 4L));
                }
                for (i = 0; i < 5; ++i) {
                    RenderStatistics.hierarchicalRenderSections[i] = MemoryUtil.memGetInt((long)(down.address + 20L + (long)i * 4L));
                }
            });
        }
        GL45.glBindSampler((int)0, (int)0);
        GL45.glBindTextureUnit((int)0, (int)0);
    }

    private void traverseInternal() {
        GL45.glPixelStorei((int)3314, (int)0);
        GL45.glPixelStorei((int)32878, (int)0);
        GL45.glPixelStorei((int)3316, (int)0);
        GL45.glPixelStorei((int)3315, (int)0);
        GL45.glPixelStorei((int)32877, (int)0);
        int firstDispatchSize = this.topNodeCount + 32 - 1 >> 5;
        long ptr = UploadStream.INSTANCE.upload(this.queueMetaBuffer, 0L, 80L);
        MemoryUtil.memPutInt((long)(ptr + 0L), (int)firstDispatchSize);
        MemoryUtil.memPutInt((long)(ptr + 4L), (int)1);
        MemoryUtil.memPutInt((long)(ptr + 8L), (int)1);
        MemoryUtil.memPutInt((long)(ptr + 12L), (int)this.topNodeCount);
        for (int i = 1; i < 5; ++i) {
            MemoryUtil.memPutInt((long)(ptr + (long)(i * 16) + 0L), (int)0);
            MemoryUtil.memPutInt((long)(ptr + (long)(i * 16) + 4L), (int)1);
            MemoryUtil.memPutInt((long)(ptr + (long)(i * 16) + 8L), (int)1);
            MemoryUtil.memPutInt((long)(ptr + (long)(i * 16) + 12L), (int)0);
        }
        UploadStream.INSTANCE.commit();
        GL45.glUniform1ui((int)NODE_QUEUE_INDEX_BINDING, (int)0);
        GL45.glBindBufferBase((int)37074, (int)NODE_QUEUE_SOURCE_BINDING, (int)this.topNodeIds.id);
        GL45.glBindBufferBase((int)37074, (int)NODE_QUEUE_SINK_BINDING, (int)this.scratchQueueB.id);
        GL42.glMemoryBarrier((int)8768);
        GL45.glDispatchCompute((int)firstDispatchSize, (int)1, (int)1);
        GL42.glMemoryBarrier((int)8256);
        for (int iter = 1; iter < 5; ++iter) {
            GL45.glUniform1ui((int)NODE_QUEUE_INDEX_BINDING, (int)iter);
            GL45.glBindBufferBase((int)37074, (int)NODE_QUEUE_SOURCE_BINDING, (int)((iter & 1) == 0 ? this.scratchQueueA : this.scratchQueueB).id);
            GL45.glBindBufferBase((int)37074, (int)NODE_QUEUE_SINK_BINDING, (int)((iter & 1) == 0 ? this.scratchQueueB : this.scratchQueueA).id);
            GL42.glMemoryBarrier((int)8256);
            GL45.glDispatchComputeIndirect((long)(iter * 4 * 4));
        }
        GL42.glMemoryBarrier((int)8256);
    }

    private void downloadResetRequestQueue() {
        GL42.glMemoryBarrier((int)8192);
        DownloadStream.INSTANCE.download(this.requestBuffer, this::forwardDownloadResult);
        GL45.nglClearNamedBufferSubData((int)this.requestBuffer.id, (int)33334, (long)0L, (long)4L, (int)36244, (int)5125, (long)0L);
    }

    private void forwardDownloadResult(long ptr, long size) {
        int count = MemoryUtil.memGetInt((long)ptr);
        ptr += 8L;
        if (count < 0 || count > 50000) {
            Logger.error(new IllegalStateException("Count unexpected extreme value: " + count + " things may get weird"));
            return;
        }
        if ((long)count > (this.requestBuffer.size() >> 3) - 1L) {
            count = (int)((this.requestBuffer.size() >> 3) - 1L);
            MemoryUtil.memPutInt((long)(ptr - 8L), (int)count);
        }
        if (count != 0) {
            this.nodeManager.submitRequestBatch(new MemoryBuffer((long)count * 8L + 8L).cpyFrom(ptr - 8L));
        }
    }

    public GlBuffer getNodeBuffer() {
        return this.nodeBuffer;
    }

    public void free() {
        this.traversal.free();
        this.requestBuffer.free();
        this.nodeBuffer.free();
        this.uniformBuffer.free();
        this.statisticsBuffer.free();
        this.queueMetaBuffer.free();
        this.topNodeIds.free();
        this.scratchQueueA.free();
        this.scratchQueueB.free();
        GL45.glDeleteSamplers((int)this.hizSampler);
    }
}

