/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.hierachical;

import me.cortex.voxy.common.util.HierarchicalBitSet;
import org.lwjgl.system.MemoryUtil;

public final class NodeStore {
    public static final int EMPTY_GEOMETRY_ID = -1;
    public static final int NODE_ID_MSK = 0xFFFFFF;
    public static final int REQUEST_ID_MSK = 65535;
    public static final int GEOMETRY_ID_MSK = 0xFFFFFF;
    public static final int MAX_GEOMETRY_ID = 0xFFFFFD;
    private static final int SENTINEL_NULL_GEOMETRY_ID = 0xFFFFFF;
    private static final int SENTINEL_EMPTY_GEOMETRY_ID = 0xFFFFFE;
    private static final int SENTINEL_NULL_NODE_ID = 0xFFFFFF;
    private static final int LONGS_PER_NODE = 4;
    private static final int INCREMENT_SIZE = 65536;
    private final HierarchicalBitSet allocationSet;
    private long[] localNodeData;

    public NodeStore(int maxNodeCount) {
        if (maxNodeCount >= 0xFFFFFF) {
            throw new IllegalArgumentException("Max count too large");
        }
        this.localNodeData = new long[262144];
        this.allocationSet = new HierarchicalBitSet(maxNodeCount);
    }

    private static int id2idx(int idx) {
        return idx * 4;
    }

    public int allocate() {
        int id = this.allocationSet.allocateNext();
        if (id < 0) {
            throw new IllegalStateException("Failed to allocate node slot!");
        }
        this.ensureSized(id);
        this.clear(id);
        return id;
    }

    public int allocate(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Count cannot be <= 0 was " + count);
        }
        int id = this.allocationSet.allocateNextConsecutiveCounted(count);
        if (id < 0) {
            throw new IllegalStateException("Failed to allocate " + count + " consecutive nodes!!");
        }
        this.ensureSized(id + count);
        for (int i = 0; i < count; ++i) {
            this.clear(id + i);
        }
        return id;
    }

    private void ensureSized(int index) {
        if (index * 4 >= this.localNodeData.length) {
            int newSize = Math.min(index + 65536, this.allocationSet.getLimit());
            long[] newStore = new long[newSize * 4];
            System.arraycopy(this.localNodeData, 0, newStore, 0, this.localNodeData.length);
            this.localNodeData = newStore;
        }
    }

    public void free(int nodeId) {
        this.free(nodeId, 1);
    }

    public void free(int baseNodeId, int count) {
        for (int i = 0; i < count; ++i) {
            int nodeId = baseNodeId + i;
            if (!this.allocationSet.free(nodeId)) {
                throw new IllegalStateException("Node " + nodeId + " was not allocated!");
            }
            this.clear(nodeId);
        }
    }

    private void clear(int nodeId) {
        int idx = NodeStore.id2idx(nodeId);
        this.localNodeData[idx] = -1L;
        this.localNodeData[idx + 1] = 0xFFFFFFFFFFFFL;
        this.localNodeData[idx + 2] = 65535L;
        this.localNodeData[idx + 3] = 0L;
    }

    public void copyNode(int fromId, int toId) {
        if (!this.allocationSet.isSet(fromId) || !this.allocationSet.isSet(toId)) {
            throw new IllegalArgumentException();
        }
        int f = NodeStore.id2idx(fromId);
        int t = NodeStore.id2idx(toId);
        this.localNodeData[t] = this.localNodeData[f];
        this.localNodeData[t + 1] = this.localNodeData[f + 1];
        this.localNodeData[t + 2] = this.localNodeData[f + 2];
        this.localNodeData[t + 3] = this.localNodeData[f + 3];
    }

    public void setNodePosition(int node, long position) {
        this.localNodeData[NodeStore.id2idx((int)node)] = position;
    }

    public long nodePosition(int nodeId) {
        return this.localNodeData[NodeStore.id2idx(nodeId)];
    }

    public boolean nodeExists(int nodeId) {
        return this.allocationSet.isSet(nodeId);
    }

    public int getNodeGeometry(int node) {
        long data = this.localNodeData[NodeStore.id2idx(node) + 1];
        int geometryPtr = (int)(data & 0xFFFFFFL);
        if (geometryPtr == 0xFFFFFF) {
            return -1;
        }
        if (geometryPtr == 0xFFFFFE) {
            return -2;
        }
        return geometryPtr;
    }

    public void setNodeGeometry(int node, int geometryId) {
        if (geometryId > 0xFFFFFD) {
            throw new IllegalArgumentException("Geometry ptr greater than MAX_GEOMETRY_ID: " + geometryId);
        }
        if (geometryId == -1) {
            geometryId = 0xFFFFFF;
        }
        if (geometryId == -2) {
            geometryId = 0xFFFFFE;
        }
        if (geometryId < 0) {
            throw new IllegalArgumentException("Geometry ptr less than -1 : " + geometryId);
        }
        int idx = NodeStore.id2idx(node) + 1;
        long data = this.localNodeData[idx];
        data &= 0xFFFFFFFFFF000000L;
        this.localNodeData[idx] = data |= (long)geometryId;
    }

    public int getChildPtr(int nodeId) {
        long data = this.localNodeData[NodeStore.id2idx(nodeId) + 1];
        int nodePtr = (int)(data >> 24 & 0xFFFFFFL);
        if (nodePtr == 0xFFFFFF) {
            return -1;
        }
        return nodePtr;
    }

    public void setChildPtr(int nodeId, int ptr) {
        if (ptr >= 0xFFFFFF || ptr < -1) {
            throw new IllegalArgumentException("Node child ptr greater GEQ NODE_ID_MSK or less than -1 : " + ptr);
        }
        if (ptr == -1) {
            ptr = 0xFFFFFF;
        }
        int idx = NodeStore.id2idx(nodeId) + 1;
        long data = this.localNodeData[idx];
        data &= 0xFFFF000000FFFFFFL;
        this.localNodeData[idx] = data |= (long)ptr << 24;
    }

    public void setNodeRequest(int node, int requestId) {
        int id = NodeStore.id2idx(node) + 2;
        long data = this.localNodeData[id];
        data &= 0xFFFFFFFFFFFF0000L;
        this.localNodeData[id] = data |= (long)requestId;
    }

    public int getNodeRequest(int node) {
        return (int)(this.localNodeData[NodeStore.id2idx(node) + 2] & 0xFFFFL);
    }

    public void markRequestInFlight(int nodeId) {
        int n = NodeStore.id2idx(nodeId) + 1;
        this.localNodeData[n] = this.localNodeData[n] | Long.MIN_VALUE;
    }

    public void unmarkRequestInFlight(int nodeId) {
        int n = NodeStore.id2idx(nodeId) + 1;
        this.localNodeData[n] = this.localNodeData[n] & Long.MAX_VALUE;
    }

    public boolean isNodeRequestInFlight(int nodeId) {
        return (this.localNodeData[NodeStore.id2idx(nodeId) + 1] >> 63 & 1L) != 0L;
    }

    public void setAllChildrenAreLeaf(int nodeId, boolean state) {
        int n = NodeStore.id2idx(nodeId) + 2;
        this.localNodeData[n] = this.localNodeData[n] & 0xFFFFFFFFFFFEFFFFL;
        int n2 = NodeStore.id2idx(nodeId) + 2;
        this.localNodeData[n2] = this.localNodeData[n2] | (state ? 65536L : 0L);
    }

    public boolean getAllChildrenAreLeaf(int nodeId) {
        return (this.localNodeData[NodeStore.id2idx(nodeId) + 2] >> 16 & 1L) != 0L;
    }

    public void markNodeGeometryInFlight(int nodeId) {
        int n = NodeStore.id2idx(nodeId) + 1;
        this.localNodeData[n] = this.localNodeData[n] | 0x800000000000000L;
    }

    public void unmarkNodeGeometryInFlight(int nodeId) {
        int n = NodeStore.id2idx(nodeId) + 1;
        this.localNodeData[n] = this.localNodeData[n] & 0xF7FFFFFFFFFFFFFFL;
    }

    public boolean isNodeGeometryInFlight(int nodeId) {
        return (this.localNodeData[NodeStore.id2idx(nodeId) + 1] & 0x800000000000000L) != 0L;
    }

    public int getNodeType(int nodeId) {
        return (int)(this.localNodeData[NodeStore.id2idx(nodeId) + 1] >> 61 & 3L) << 30;
    }

    public void setNodeType(int nodeId, int type) {
        int idx = NodeStore.id2idx(nodeId) + 1;
        long data = this.localNodeData[idx];
        data &= 0x9FFFFFFFFFFFFFFFL;
        this.localNodeData[idx] = data |= (long)(type >>>= 30) << 61;
    }

    public byte getNodeChildExistence(int nodeId) {
        long data = this.localNodeData[NodeStore.id2idx(nodeId) + 1];
        return (byte)(data >> 48 & 0xFFL);
    }

    public void setNodeChildExistence(int nodeId, byte existence) {
        int idx = NodeStore.id2idx(nodeId) + 1;
        long data = this.localNodeData[idx];
        data &= 0xFF00FFFFFFFFFFFFL;
        this.localNodeData[idx] = data |= Byte.toUnsignedLong(existence) << 48;
    }

    public int getChildPtrCount(int nodeId) {
        long data = this.localNodeData[NodeStore.id2idx(nodeId) + 1];
        return (int)(data >> 56 & 7L) + 1;
    }

    public void setChildPtrCount(int nodeId, int count) {
        if (count <= 0 || count > 8) {
            throw new IllegalArgumentException("Count: " + count);
        }
        int idx = NodeStore.id2idx(nodeId) + 1;
        long data = this.localNodeData[idx];
        data &= 0xF8FFFFFFFFFFFFFFL;
        this.localNodeData[idx] = data |= (long)(count - 1) << 56;
    }

    public void writeNode(long ptr, int nodeId) {
        if (!this.nodeExists(nodeId)) {
            MemoryUtil.memPutLong((long)ptr, (long)-1L);
            MemoryUtil.memPutLong((long)(ptr + 8L), (long)-1L);
            return;
        }
        long pos = this.nodePosition(nodeId);
        MemoryUtil.memPutInt((long)ptr, (int)((int)(pos >> 32)));
        MemoryUtil.memPutInt((long)(ptr += 4L), (int)((int)pos));
        ptr += 4L;
        int z = 0;
        int w = 0;
        short flags = 0;
        flags = (short)(flags | (short)(this.isNodeRequestInFlight(nodeId) ? 1 : 0));
        flags = (short)(flags | (short)(this.getChildPtrCount(nodeId) - 1 << 2));
        boolean isEligibleForCleaning = false;
        flags = (short)(flags | (short)((isEligibleForCleaning |= this.getAllChildrenAreLeaf(nodeId)) ? 32 : 0));
        int geometry = this.getNodeGeometry(nodeId);
        z = geometry == -2 ? (z |= 0xFFFFFE) : (geometry == -1 ? (z |= 0xFFFFFF) : (z |= geometry & 0xFFFFFF));
        int childPtr = this.getChildPtr(nodeId);
        w |= childPtr & 0xFFFFFF;
        MemoryUtil.memPutInt((long)ptr, (int)(z |= (flags & 0xFF) << 24));
        MemoryUtil.memPutInt((long)(ptr += 4L), (int)(w |= (flags >> 8 & 0xFF) << 24));
        ptr += 4L;
    }

    public int getEndNodeId() {
        return this.allocationSet.getMaxIndex();
    }

    public int getNodeCount() {
        return this.allocationSet.getCount();
    }
}

