/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.section;

import java.util.List;
import me.cortex.voxy.client.RenderStatistics;
import me.cortex.voxy.client.core.AbstractRenderPipeline;
import me.cortex.voxy.client.core.gl.Capabilities;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.GlVertexArray;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderLoader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import me.cortex.voxy.client.core.model.ModelStore;
import me.cortex.voxy.client.core.rendering.section.AbstractSectionRenderer;
import me.cortex.voxy.client.core.rendering.section.MDICViewport;
import me.cortex.voxy.client.core.rendering.section.geometry.BasicSectionGeometryData;
import me.cortex.voxy.client.core.rendering.util.DownloadStream;
import me.cortex.voxy.client.core.rendering.util.LightMapHelper;
import me.cortex.voxy.client.core.rendering.util.SharedIndexBuffer;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import me.cortex.voxy.common.Logger;
import net.minecraft.class_310;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.ARBIndirectParameters;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GL45;
import org.lwjgl.system.MemoryUtil;

public class MDICSectionRenderer
extends AbstractSectionRenderer<MDICViewport, BasicSectionGeometryData> {
    private static final int TRANSLUCENT_OFFSET = 400000;
    private static final int TEMPORAL_OFFSET = 500000;
    private static final int STATISTICS_BUFFER_BINDING = 8;
    private final Shader terrainShader;
    private final Shader translucentTerrainShader;
    private final Shader commandGenShader = Shader.make(new IShaderProcessor[0]).define("TRANSLUCENT_WRITE_BASE", 1024).define("TEMPORAL_OFFSET", 500000).define("TRANSLUCENT_DISTANCE_BUFFER_BINDING", 7).defineIf("HAS_STATISTICS", RenderStatistics.enabled).defineIf("STATISTICS_BUFFER_BINDING", RenderStatistics.enabled, 8).add(ShaderType.COMPUTE, "voxy:lod/gl46/cmdgen.comp").compile();
    private final Shader prepShader = Shader.make(new IShaderProcessor[0]).add(ShaderType.COMPUTE, "voxy:lod/gl46/prep.comp").compile();
    private final Shader cullShader = Shader.make(new IShaderProcessor[0]).add(ShaderType.VERTEX, "voxy:lod/gl46/cull/raster.vert").add(ShaderType.FRAGMENT, "voxy:lod/gl46/cull/raster.frag").compile();
    private final Shader prefixSumShader;
    private final Shader translucentGenShader;
    private final GlBuffer uniform;
    private final GlBuffer distanceCountBuffer;
    private final GlBuffer statisticsBuffer;
    private final AbstractRenderPipeline pipeline;

    public MDICSectionRenderer(AbstractRenderPipeline pipeline, ModelStore modelStore, BasicSectionGeometryData geometryData) {
        super(modelStore, geometryData);
        this.prefixSumShader = Shader.make(new IShaderProcessor[0]).add(ShaderType.COMPUTE, Capabilities.INSTANCE.subgroup ? "voxy:util/prefixsum/inital3.comp" : "voxy:util/prefixsum/simple.comp").define("IO_BUFFER", 0).compile();
        this.translucentGenShader = Shader.make(new IShaderProcessor[0]).add(ShaderType.COMPUTE, "voxy:lod/gl46/buildtranslucents.comp").define("TRANSLUCENT_WRITE_BASE", 1024).define("TRANSLUCENT_DISTANCE_BUFFER_BINDING", 5).define("TRANSLUCENT_OFFSET", 400000).compile();
        this.uniform = new GlBuffer(1024L).zero();
        this.distanceCountBuffer = new GlBuffer(404096L).zero();
        this.statisticsBuffer = new GlBuffer(1024L).zero();
        this.pipeline = pipeline;
        Object vertex = ShaderLoader.parse("voxy:lod/gl46/quads3.vert");
        String taa = pipeline.taaFunction("taaShift");
        if (taa != null) {
            vertex = (String)vertex + "\n" + taa;
        }
        Shader.Builder<Shader> builder = Shader.make(new IShaderProcessor[0]).defineIf("TAA_PATCH", taa != null).defineIf("DEBUG_RENDER", false).defineIf("DARKENED_TINTING", class_310.method_1551().field_1687.method_28103().method_29993()).addSource(ShaderType.VERTEX, (String)vertex);
        String frag = ShaderLoader.parse("voxy:lod/gl46/quads.frag");
        String opaqueFrag = pipeline.patchOpaqueShader(this, frag);
        opaqueFrag = opaqueFrag == null ? frag : opaqueFrag;
        this.terrainShader = MDICSectionRenderer.tryCompilePatchedOrNormal(builder, opaqueFrag, frag);
        String translucentFrag = pipeline.patchTranslucentShader(this, frag);
        this.translucentTerrainShader = translucentFrag != null ? MDICSectionRenderer.tryCompilePatchedOrNormal(builder, translucentFrag, frag) : this.terrainShader;
    }

    private static Shader tryCompilePatchedOrNormal(Shader.Builder<?> builder, String shader, String original) {
        boolean patched = shader != original;
        try {
            return ((Shader.Builder)builder.clone()).defineIf("PATCHED_SHADER", patched).addSource(ShaderType.FRAGMENT, shader).compile();
        }
        catch (RuntimeException e) {
            if (patched) {
                Logger.error("Failed to compile shader patch, using normal pipeline to prevent errors", e);
                return MDICSectionRenderer.tryCompilePatchedOrNormal(builder, original, original);
            }
            throw e;
        }
    }

    private void uploadUniformBuffer(MDICViewport viewport) {
        long ptr = UploadStream.INSTANCE.upload(this.uniform, 0L, 1024L);
        Matrix4f mat = new Matrix4f((Matrix4fc)viewport.MVP);
        mat.translate(-viewport.innerTranslation.x, -viewport.innerTranslation.y, -viewport.innerTranslation.z);
        mat.getToAddress(ptr);
        viewport.section.getToAddress(ptr += 64L);
        ptr += 12L;
        if (viewport.frameId < 0) {
            Logger.error("Frame ID negative, this will cause things to break, wrapping around");
            viewport.frameId &= Integer.MAX_VALUE;
        }
        MemoryUtil.memPutInt((long)ptr, (int)(viewport.frameId & Integer.MAX_VALUE));
        viewport.innerTranslation.getToAddress(ptr += 4L);
        ptr += 12L;
        UploadStream.INSTANCE.commit();
    }

    private void bindRenderingBuffers(MDICViewport viewport) {
        GL30.glBindBufferBase((int)35345, (int)0, (int)this.uniform.id);
        GL30.glBindBufferBase((int)37074, (int)1, (int)((BasicSectionGeometryData)this.geometryManager).getGeometryBuffer().id);
        GL30.glBindBufferBase((int)37074, (int)2, (int)((BasicSectionGeometryData)this.geometryManager).getMetadataBuffer().id);
        this.modelStore.bind(3, 4, 0);
        GL30.glBindBufferBase((int)37074, (int)5, (int)viewport.positionScratchBuffer.id);
        LightMapHelper.bind(1);
        GL45.glBindTextureUnit((int)2, (int)viewport.depthBoundingBuffer.getDepthTex().id);
        GL15.glBindBuffer((int)34963, (int)SharedIndexBuffer.INSTANCE.id());
        GL15.glBindBuffer((int)36671, (int)viewport.drawCallBuffer.id);
        GL15.glBindBuffer((int)33006, (int)viewport.drawCountCallBuffer.id);
    }

    private void renderTerrain(MDICViewport viewport, long indirectOffset, long drawCountOffset, int maxDrawCount) {
        GL43.glDisable((int)2884);
        GL43.glEnable((int)2929);
        this.terrainShader.bind();
        GL30.glBindVertexArray((int)GlVertexArray.STATIC_VAO);
        this.pipeline.setupAndBindOpaque(viewport);
        this.bindRenderingBuffers(viewport);
        GL42.glMemoryBarrier((int)8256);
        GL43.glProvokingVertex((int)36429);
        ARBIndirectParameters.glMultiDrawElementsIndirectCountARB((int)4, (int)5123, (long)indirectOffset, (long)drawCountOffset, (int)maxDrawCount, (int)0);
        GL43.glEnable((int)2884);
        GL30.glBindVertexArray((int)0);
        GL33.glBindSampler((int)0, (int)0);
        GL45.glBindTextureUnit((int)0, (int)0);
        GL33.glBindSampler((int)1, (int)0);
        GL45.glBindTextureUnit((int)1, (int)0);
    }

    @Override
    public void renderOpaque(MDICViewport viewport) {
        if (((BasicSectionGeometryData)this.geometryManager).getSectionCount() == 0) {
            return;
        }
        this.uploadUniformBuffer(viewport);
        this.renderTerrain(viewport, 0L, 12L, Math.min((int)((double)((BasicSectionGeometryData)this.geometryManager).getSectionCount() * 4.4 + 128.0), 400000));
    }

    @Override
    public void renderTranslucent(MDICViewport viewport) {
        if (((BasicSectionGeometryData)this.geometryManager).getSectionCount() == 0) {
            return;
        }
        GL43.glEnable((int)3042);
        GL43.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GL43.glDisable((int)2884);
        GL43.glEnable((int)2929);
        this.translucentTerrainShader.bind();
        GL30.glBindVertexArray((int)GlVertexArray.STATIC_VAO);
        this.pipeline.setupAndBindTranslucent(viewport);
        this.bindRenderingBuffers(viewport);
        GL42.glMemoryBarrier((int)8256);
        GL43.glProvokingVertex((int)36429);
        ARBIndirectParameters.glMultiDrawElementsIndirectCountARB((int)4, (int)5123, (long)8000000L, (long)16L, (int)Math.min(((BasicSectionGeometryData)this.geometryManager).getSectionCount(), 100000), (int)0);
        GL43.glEnable((int)2884);
        GL30.glBindVertexArray((int)0);
        GL33.glBindSampler((int)0, (int)0);
        GL45.glBindTextureUnit((int)0, (int)0);
        GL33.glBindSampler((int)1, (int)0);
        GL45.glBindTextureUnit((int)1, (int)0);
        GL43.glDisable((int)3042);
    }

    @Override
    public void buildDrawCalls(MDICViewport viewport) {
        if (((BasicSectionGeometryData)this.geometryManager).getSectionCount() == 0) {
            return;
        }
        this.uploadUniformBuffer(viewport);
        this.prepShader.bind();
        GL30.glBindBufferBase((int)35345, (int)0, (int)this.uniform.id);
        GL30.glBindBufferBase((int)37074, (int)1, (int)viewport.drawCountCallBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)2, (int)viewport.getRenderList().id);
        GL42.glMemoryBarrier((int)8192);
        GL43.glDispatchCompute((int)1, (int)1, (int)1);
        GL42.glMemoryBarrier((int)8192);
        this.cullShader.bind();
        if (Capabilities.INSTANCE.repFragTest) {
            GL43.glEnable((int)37759);
        }
        GL30.glBindVertexArray((int)GlVertexArray.STATIC_VAO);
        GL30.glBindBufferBase((int)35345, (int)0, (int)this.uniform.id);
        GL30.glBindBufferBase((int)37074, (int)1, (int)((BasicSectionGeometryData)this.geometryManager).getMetadataBuffer().id);
        GL30.glBindBufferBase((int)37074, (int)2, (int)viewport.visibilityBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)3, (int)viewport.indirectLookupBuffer.id);
        GL15.glBindBuffer((int)36671, (int)viewport.drawCountCallBuffer.id);
        GL15.glBindBuffer((int)34963, (int)SharedIndexBuffer.INSTANCE.id());
        GL43.glEnable((int)2929);
        GL43.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL43.glDepthMask((boolean)false);
        GL42.glMemoryBarrier((int)8256);
        GL43.glDrawElementsIndirect((int)4, (int)5121, (long)24L);
        GL43.glDepthMask((boolean)true);
        GL43.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL43.glDisable((int)2929);
        if (Capabilities.INSTANCE.repFragTest) {
            GL43.glDisable((int)37759);
        }
        this.distanceCountBuffer.zeroRange(0L, 4096L);
        this.commandGenShader.bind();
        GL30.glBindBufferBase((int)35345, (int)0, (int)this.uniform.id);
        GL30.glBindBufferBase((int)37074, (int)1, (int)viewport.drawCallBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)2, (int)viewport.drawCountCallBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)3, (int)((BasicSectionGeometryData)this.geometryManager).getMetadataBuffer().id);
        GL30.glBindBufferBase((int)37074, (int)4, (int)viewport.visibilityBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)5, (int)viewport.indirectLookupBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)6, (int)viewport.positionScratchBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)7, (int)this.distanceCountBuffer.id);
        if (RenderStatistics.enabled) {
            this.statisticsBuffer.zero();
            GL30.glBindBufferBase((int)37074, (int)8, (int)this.statisticsBuffer.id);
        }
        GL15.glBindBuffer((int)37102, (int)viewport.drawCountCallBuffer.id);
        GL42.glMemoryBarrier((int)8192);
        GL43.glDispatchComputeIndirect((long)0L);
        GL42.glMemoryBarrier((int)8256);
        if (RenderStatistics.enabled) {
            DownloadStream.INSTANCE.download(this.statisticsBuffer, down -> {
                int i;
                int LAYERS = 5;
                for (i = 0; i < 5; ++i) {
                    RenderStatistics.visibleSections[i] = MemoryUtil.memGetInt((long)(down.address + (long)i * 4L));
                }
                for (i = 0; i < 5; ++i) {
                    RenderStatistics.quadCount[i] = MemoryUtil.memGetInt((long)(down.address + 20L + (long)i * 4L));
                }
            });
        }
        this.prefixSumShader.bind();
        GL30.glBindBufferBase((int)37074, (int)0, (int)this.distanceCountBuffer.id);
        GL42.glMemoryBarrier((int)8192);
        GL43.glDispatchCompute((int)1, (int)1, (int)1);
        GL42.glMemoryBarrier((int)8192);
        this.translucentGenShader.bind();
        GL30.glBindBufferBase((int)35345, (int)0, (int)this.uniform.id);
        GL30.glBindBufferBase((int)37074, (int)1, (int)viewport.drawCallBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)2, (int)viewport.drawCountCallBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)3, (int)((BasicSectionGeometryData)this.geometryManager).getMetadataBuffer().id);
        GL30.glBindBufferBase((int)37074, (int)4, (int)viewport.indirectLookupBuffer.id);
        GL30.glBindBufferBase((int)37074, (int)5, (int)this.distanceCountBuffer.id);
        GL15.glBindBuffer((int)37102, (int)viewport.drawCountCallBuffer.id);
        GL42.glMemoryBarrier((int)8260);
        GL43.glDispatchComputeIndirect((long)0L);
        GL42.glMemoryBarrier((int)8256);
    }

    @Override
    public void renderTemporal(MDICViewport viewport) {
        if (((BasicSectionGeometryData)this.geometryManager).getSectionCount() == 0) {
            return;
        }
        this.renderTerrain(viewport, 10000000L, 20L, Math.min(((BasicSectionGeometryData)this.geometryManager).getSectionCount(), 100000));
    }

    @Override
    public void addDebug(List<String> lines) {
        super.addDebug(lines);
    }

    @Override
    public MDICViewport createViewport() {
        return new MDICViewport(((BasicSectionGeometryData)this.geometryManager).getMaxSectionCount());
    }

    @Override
    public void free() {
        if (this.terrainShader != this.translucentTerrainShader) {
            this.translucentTerrainShader.free();
        }
        this.uniform.free();
        this.distanceCountBuffer.free();
        this.terrainShader.free();
        this.commandGenShader.free();
        this.cullShader.free();
        this.prepShader.free();
        this.translucentGenShader.free();
        this.prefixSumShader.free();
        this.statisticsBuffer.free();
    }
}

