/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.util;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.function.Consumer;
import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.gl.GlFence;
import me.cortex.voxy.client.core.gl.GlPersistentMappedBuffer;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.AllocationArena;
import me.cortex.voxy.common.util.MemoryBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GL45;

public class DownloadStream {
    private final AllocationArena allocationArena = new AllocationArena();
    private final GlPersistentMappedBuffer downloadBuffer;
    private final Deque<DownloadFrame> frames = new ArrayDeque<DownloadFrame>();
    private final LongArrayList thisFrameAllocations = new LongArrayList();
    private final Deque<DownloadData> downloadList = new ArrayDeque<DownloadData>();
    private final ArrayList<DownloadData> thisFrameDownloadList = new ArrayList();
    private long caddr = -1L;
    private long offset = 0L;
    public static final DownloadStream INSTANCE = new DownloadStream(0x2000000L);

    public DownloadStream(long size) {
        this.downloadBuffer = new GlPersistentMappedBuffer(size, 1);
        this.allocationArena.setLimit(size);
    }

    public void download(GlBuffer buffer, DownloadResultConsumer resultConsumer) {
        this.download(buffer, 0L, buffer.size(), resultConsumer);
    }

    public void download(GlBuffer buffer, Consumer<MemoryBuffer> resultConsumer) {
        this.download(buffer, 0L, buffer.size(), resultConsumer);
    }

    public void download(GlBuffer buffer, long downloadOffset, long size, Consumer<MemoryBuffer> consumer) {
        this.download(buffer, downloadOffset, size, (long ptr, long size2) -> consumer.accept(MemoryBuffer.createUntrackedUnfreeableRawFrom(ptr, size)));
    }

    public void download(GlBuffer buffer, long downloadOffset, long size, DownloadResultConsumer resultConsumer) {
        long addr;
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (size <= 0L) {
            throw new IllegalArgumentException();
        }
        if (downloadOffset + size > buffer.size()) {
            throw new IllegalArgumentException();
        }
        if (this.caddr == -1L || !this.allocationArena.expand(this.caddr, (int)size)) {
            this.caddr = this.allocationArena.alloc((int)size);
            if (this.caddr == -1L) {
                Logger.warn("Download stream full, preemptively committing, this could cause bad things to happen");
                this.commit();
                int attempts = 10;
                while (--attempts != 0 && this.caddr == -1L) {
                    GL11.glFinish();
                    this.tick();
                    this.caddr = this.allocationArena.alloc((int)size);
                }
                if (this.caddr == -1L) {
                    throw new IllegalStateException("Could not allocate memory segment big enough for upload even after force flush");
                }
            }
            this.thisFrameAllocations.add(this.caddr);
            this.offset = size;
            addr = this.caddr;
        } else {
            addr = this.caddr + this.offset;
            this.offset += size;
        }
        if (this.caddr + size > this.downloadBuffer.size()) {
            throw new IllegalStateException();
        }
        this.downloadList.add(new DownloadData(buffer, addr, downloadOffset, size, resultConsumer));
        this.commit();
    }

    public void commit() {
        if (this.downloadList.isEmpty()) {
            return;
        }
        GL42.glMemoryBarrier((int)512);
        for (DownloadData entry : this.downloadList) {
            GL45.glCopyNamedBufferSubData((int)entry.target.id, (int)this.downloadBuffer.id, (long)entry.targetOffset, (long)entry.downloadStreamOffset, (long)entry.size);
        }
        GL42.glMemoryBarrier((int)16896);
        this.thisFrameDownloadList.addAll(this.downloadList);
        this.downloadList.clear();
        this.caddr = -1L;
        this.offset = 0L;
    }

    public void tick() {
        this.commit();
        if (!this.thisFrameAllocations.isEmpty()) {
            this.frames.add(new DownloadFrame(new GlFence(), new LongArrayList((LongList)this.thisFrameAllocations), new ArrayList<DownloadData>(this.thisFrameDownloadList)));
            this.thisFrameAllocations.clear();
            this.thisFrameDownloadList.clear();
        }
        while (!this.frames.isEmpty() && this.frames.peek().fence.signaled()) {
            DownloadFrame frame = this.frames.pop();
            for (DownloadData data : frame.data) {
                data.resultConsumer.consume(this.downloadBuffer.addr() + data.downloadStreamOffset, data.size);
            }
            frame.allocations.forEach(this.allocationArena::free);
            frame.fence.free();
        }
    }

    public void waitDiscard() {
        GL11.glFinish();
        GlFence fence = new GlFence();
        GL11.glFinish();
        while (!fence.signaled()) {
            Thread.onSpinWait();
        }
        fence.free();
        while (!this.frames.isEmpty()) {
            DownloadFrame frame = this.frames.pop();
            while (!frame.fence.signaled()) {
                Thread.onSpinWait();
            }
            frame.allocations.forEach(this.allocationArena::free);
            frame.fence.free();
        }
    }

    public void flushWaitClear() {
        GL11.glFinish();
        this.tick();
        GlFence fence = new GlFence();
        GL11.glFinish();
        while (!fence.signaled()) {
            Thread.onSpinWait();
        }
        fence.free();
        this.tick();
        if (!this.frames.isEmpty()) {
            throw new IllegalStateException();
        }
    }

    public static interface DownloadResultConsumer {
        public void consume(long var1, long var3);
    }

    private record DownloadData(GlBuffer target, long downloadStreamOffset, long targetOffset, long size, DownloadResultConsumer resultConsumer) {
    }

    private record DownloadFrame(GlFence fence, LongArrayList allocations, ArrayList<DownloadData> data) {
    }
}

