/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.util;

import me.cortex.voxy.client.core.gl.GlFramebuffer;
import me.cortex.voxy.client.core.gl.GlTexture;
import me.cortex.voxy.client.core.gl.GlVertexArray;
import me.cortex.voxy.client.core.gl.shader.IShaderProcessor;
import me.cortex.voxy.client.core.gl.shader.Shader;
import me.cortex.voxy.client.core.gl.shader.ShaderType;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GL42C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GL45C;

public class HiZBuffer2 {
    private final Shader hizMip = Shader.make(new IShaderProcessor[0]).add(ShaderType.COMPUTE, "voxy:hiz/hiz.comp").compile();
    private final Shader hizInitial = Shader.make(new IShaderProcessor[0]).add(ShaderType.VERTEX, "voxy:hiz/blit.vsh").add(ShaderType.FRAGMENT, "voxy:hiz/blit.fsh").define("OUTPUT_COLOUR").compile();
    private final GlFramebuffer fb = new GlFramebuffer().name("HiZ");
    private final int sampler = GL33.glGenSamplers();
    private final int type;
    private GlTexture texture;
    private int levels;
    private int width;
    private int height;

    public HiZBuffer2() {
        this(33326);
    }

    public HiZBuffer2(int type) {
        ARBDirectStateAccess.glNamedFramebufferDrawBuffer((int)this.fb.id, (int)36064);
        this.type = type;
    }

    private void alloc(int width, int height) {
        this.levels = Math.min(7, (int)Math.ceil(Math.log(Math.max(width, height)) / Math.log(2.0)));
        this.texture = new GlTexture().store(this.type, this.levels, width, height).name("HiZ");
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)10241, (int)9984);
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)10240, (int)9728);
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)34892, (int)0);
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)10242, (int)33071);
        ARBDirectStateAccess.glTextureParameteri((int)this.texture.id, (int)10243, (int)33071);
        GL33C.glSamplerParameteri((int)this.sampler, (int)10241, (int)9984);
        GL33C.glSamplerParameteri((int)this.sampler, (int)10240, (int)9728);
        GL33C.glSamplerParameteri((int)this.sampler, (int)34892, (int)0);
        GL33C.glSamplerParameteri((int)this.sampler, (int)10242, (int)33071);
        GL33C.glSamplerParameteri((int)this.sampler, (int)10243, (int)33071);
        this.width = width;
        this.height = height;
        this.fb.bind(36064, this.texture, 0).verify();
    }

    public void buildMipChain(int srcDepthTex, int width, int height) {
        int i;
        if (this.width != Integer.highestOneBit(width) || this.height != Integer.highestOneBit(height)) {
            if (this.texture != null) {
                this.texture.free();
                this.texture = null;
            }
            this.alloc(Integer.highestOneBit(width), Integer.highestOneBit(height));
        }
        int boundFB = GL11.glGetInteger((int)36006);
        GL42C.glBindVertexArray((int)GlVertexArray.STATIC_VAO);
        this.hizInitial.bind();
        GL42C.glBindFramebuffer((int)36160, (int)this.fb.id);
        GL42C.glDisable((int)2929);
        ARBDirectStateAccess.glBindTextureUnit((int)0, (int)srcDepthTex);
        GL33.glBindSampler((int)0, (int)this.sampler);
        GL42C.glUniform1i((int)0, (int)0);
        GL42C.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        GL42C.glDrawArrays((int)6, (int)0, (int)4);
        GL45C.glTextureBarrier();
        GL42C.glMemoryBarrier((int)1032);
        GL42C.glBindFramebuffer((int)36160, (int)boundFB);
        GL42C.glViewport((int)0, (int)0, (int)width, (int)height);
        GL42C.glBindVertexArray((int)0);
        this.hizMip.bind();
        GL42C.glUniform2f((int)0, (float)(1.0f / (float)this.width), (float)(1.0f / (float)this.height));
        ARBDirectStateAccess.glBindTextureUnit((int)0, (int)this.texture.id);
        GL33.glBindSampler((int)0, (int)this.sampler);
        for (i = 1; i < 7; ++i) {
            GL42C.glBindImageTexture((int)i, (int)this.texture.id, (int)i, (boolean)false, (int)0, (int)35001, (int)33326);
        }
        GL43C.glDispatchCompute((int)(this.width / 64), (int)(this.height / 64), (int)1);
        GL33.glBindSampler((int)0, (int)0);
        for (i = 0; i < 7; ++i) {
            ARBDirectStateAccess.glBindTextureUnit((int)i, (int)0);
        }
    }

    public void free() {
        this.fb.free();
        if (this.texture != null) {
            this.texture.free();
            this.texture = null;
        }
        GL33C.glDeleteSamplers((int)this.sampler);
        this.hizInitial.free();
        this.hizMip.free();
    }

    public int getHizTextureId() {
        return this.texture.id;
    }

    public int getPackedLevels() {
        return Integer.numberOfTrailingZeros(this.width) << 16 | Integer.numberOfTrailingZeros(this.height);
    }
}

