/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.rendering.util;

import me.cortex.voxy.client.core.gl.GlBuffer;
import me.cortex.voxy.client.core.rendering.util.UploadStream;
import me.cortex.voxy.common.util.MemoryBuffer;
import org.lwjgl.system.MemoryUtil;

public class SharedIndexBuffer {
    public static final int CUBE_INDEX_OFFSET = 786432;
    public static final SharedIndexBuffer INSTANCE = new SharedIndexBuffer();
    public static final SharedIndexBuffer INSTANCE_BYTE = new SharedIndexBuffer(true);
    public static final SharedIndexBuffer INSTANCE_BB_BYTE = new SharedIndexBuffer(true, true);
    private final GlBuffer indexBuffer;

    public SharedIndexBuffer() {
        this.indexBuffer = new GlBuffer(786468L);
        MemoryBuffer quadIndexBuff = SharedIndexBuffer.generateQuadIndicesShort(16380);
        MemoryBuffer cubeBuff = SharedIndexBuffer.generateCubeIndexBuffer();
        long ptr = UploadStream.INSTANCE.upload(this.indexBuffer, 0L, this.indexBuffer.size());
        quadIndexBuff.cpyTo(ptr);
        cubeBuff.cpyTo(786432L + ptr);
        quadIndexBuff.free();
        cubeBuff.free();
        UploadStream.INSTANCE.commit();
    }

    private SharedIndexBuffer(boolean type2) {
        this.indexBuffer = new GlBuffer(1572L);
        MemoryBuffer quadIndexBuff = SharedIndexBuffer.generateQuadIndicesByte(63);
        MemoryBuffer cubeBuff = SharedIndexBuffer.generateCubeIndexBuffer();
        long ptr = UploadStream.INSTANCE.upload(this.indexBuffer, 0L, this.indexBuffer.size());
        quadIndexBuff.cpyTo(ptr);
        cubeBuff.cpyTo(1536L + ptr);
        quadIndexBuff.free();
        cubeBuff.free();
    }

    private SharedIndexBuffer(boolean type2, boolean type3) {
        this.indexBuffer = new GlBuffer(1152L);
        MemoryBuffer cubeBuff = SharedIndexBuffer.generateByteCubesIndexBuffer(32);
        cubeBuff.cpyTo(UploadStream.INSTANCE.upload(this.indexBuffer, 0L, this.indexBuffer.size()));
        UploadStream.INSTANCE.commit();
        cubeBuff.free();
    }

    private static MemoryBuffer generateCubeIndexBuffer() {
        MemoryBuffer buffer = new MemoryBuffer(36L);
        long ptr = buffer.address;
        MemoryUtil.memSet((long)ptr, (int)0, (long)36L);
        MemoryUtil.memPutByte((long)ptr++, (byte)0);
        MemoryUtil.memPutByte((long)ptr++, (byte)1);
        MemoryUtil.memPutByte((long)ptr++, (byte)2);
        MemoryUtil.memPutByte((long)ptr++, (byte)3);
        MemoryUtil.memPutByte((long)ptr++, (byte)2);
        MemoryUtil.memPutByte((long)ptr++, (byte)1);
        MemoryUtil.memPutByte((long)ptr++, (byte)6);
        MemoryUtil.memPutByte((long)ptr++, (byte)5);
        MemoryUtil.memPutByte((long)ptr++, (byte)4);
        MemoryUtil.memPutByte((long)ptr++, (byte)5);
        MemoryUtil.memPutByte((long)ptr++, (byte)6);
        MemoryUtil.memPutByte((long)ptr++, (byte)7);
        MemoryUtil.memPutByte((long)ptr++, (byte)0);
        MemoryUtil.memPutByte((long)ptr++, (byte)4);
        MemoryUtil.memPutByte((long)ptr++, (byte)1);
        MemoryUtil.memPutByte((long)ptr++, (byte)5);
        MemoryUtil.memPutByte((long)ptr++, (byte)1);
        MemoryUtil.memPutByte((long)ptr++, (byte)4);
        MemoryUtil.memPutByte((long)ptr++, (byte)3);
        MemoryUtil.memPutByte((long)ptr++, (byte)6);
        MemoryUtil.memPutByte((long)ptr++, (byte)2);
        MemoryUtil.memPutByte((long)ptr++, (byte)6);
        MemoryUtil.memPutByte((long)ptr++, (byte)3);
        MemoryUtil.memPutByte((long)ptr++, (byte)7);
        MemoryUtil.memPutByte((long)ptr++, (byte)2);
        MemoryUtil.memPutByte((long)ptr++, (byte)4);
        MemoryUtil.memPutByte((long)ptr++, (byte)0);
        MemoryUtil.memPutByte((long)ptr++, (byte)4);
        MemoryUtil.memPutByte((long)ptr++, (byte)2);
        MemoryUtil.memPutByte((long)ptr++, (byte)6);
        MemoryUtil.memPutByte((long)ptr++, (byte)1);
        MemoryUtil.memPutByte((long)ptr++, (byte)5);
        MemoryUtil.memPutByte((long)ptr++, (byte)3);
        MemoryUtil.memPutByte((long)ptr++, (byte)7);
        MemoryUtil.memPutByte((long)ptr++, (byte)3);
        MemoryUtil.memPutByte((long)ptr++, (byte)5);
        return buffer;
    }

    private static MemoryBuffer generateByteCubesIndexBuffer(int cnt) {
        MemoryBuffer buffer = new MemoryBuffer((long)cnt * 6L * 2L * 3L);
        long ptr = buffer.address;
        MemoryUtil.memSet((long)ptr, (int)0, (long)buffer.size);
        for (int i = 0; i < cnt; ++i) {
            int j = i * 8;
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(0 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(1 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(2 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(3 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(2 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(1 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(6 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(5 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(4 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(5 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(6 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(7 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(0 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(4 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(1 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(5 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(1 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(4 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(3 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(6 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(2 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(6 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(3 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(7 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(2 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(4 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(0 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(4 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(2 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(6 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(1 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(5 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(3 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(7 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(3 + j)));
            MemoryUtil.memPutByte((long)ptr++, (byte)((byte)(5 + j)));
        }
        return buffer;
    }

    public static MemoryBuffer generateQuadIndicesByte(int quadCount) {
        if (quadCount * 4 >= 256) {
            throw new IllegalArgumentException("Quad count to large");
        }
        MemoryBuffer buffer = new MemoryBuffer((long)quadCount * 6L);
        long ptr = buffer.address;
        for (int i = 0; i < quadCount * 4; i += 4) {
            MemoryUtil.memPutByte((long)(ptr + 0L), (byte)((byte)(i + 1)));
            MemoryUtil.memPutByte((long)(ptr + 1L), (byte)((byte)(i + 2)));
            MemoryUtil.memPutByte((long)(ptr + 2L), (byte)((byte)(i + 0)));
            MemoryUtil.memPutByte((long)(ptr + 3L), (byte)((byte)(i + 1)));
            MemoryUtil.memPutByte((long)(ptr + 4L), (byte)((byte)(i + 3)));
            MemoryUtil.memPutByte((long)(ptr + 5L), (byte)((byte)(i + 2)));
            ptr += 6L;
        }
        return buffer;
    }

    public static MemoryBuffer generateQuadIndicesShort(int quadCount) {
        if (quadCount * 4 >= 65536) {
            throw new IllegalArgumentException("Quad count to large");
        }
        MemoryBuffer buffer = new MemoryBuffer((long)quadCount * 6L * 2L);
        long ptr = buffer.address;
        for (int i = 0; i < quadCount * 4; i += 4) {
            MemoryUtil.memPutShort((long)(ptr + 0L), (short)((short)(i + 1)));
            MemoryUtil.memPutShort((long)(ptr + 2L), (short)((short)(i + 2)));
            MemoryUtil.memPutShort((long)(ptr + 4L), (short)((short)(i + 0)));
            MemoryUtil.memPutShort((long)(ptr + 6L), (short)((short)(i + 1)));
            MemoryUtil.memPutShort((long)(ptr + 8L), (short)((short)(i + 3)));
            MemoryUtil.memPutShort((long)(ptr + 10L), (short)((short)(i + 2)));
            ptr += 12L;
        }
        return buffer;
    }

    public static MemoryBuffer generateQuadIndicesInt(int quadCount) {
        MemoryBuffer buffer = new MemoryBuffer((long)quadCount * 6L * 2L);
        long ptr = buffer.address;
        for (int i = 0; i < quadCount * 4; i += 4) {
            MemoryUtil.memPutInt((long)(ptr + 0L), (int)i);
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)(i + 1));
            MemoryUtil.memPutInt((long)(ptr + 8L), (int)(i + 2));
            MemoryUtil.memPutInt((long)(ptr + 12L), (int)(i + 1));
            MemoryUtil.memPutInt((long)(ptr + 16L), (int)(i + 3));
            MemoryUtil.memPutInt((long)(ptr + 20L), (int)(i + 2));
            ptr += 24L;
        }
        return buffer;
    }

    public int id() {
        return this.indexBuffer.id;
    }
}

