/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import me.cortex.voxy.common.util.HierarchicalBitSet;

public class ExpandingObjectAllocationList<T> {
    private static final float GROWTH_FACTOR = 0.75f;
    private final Int2ObjectFunction<T[]> arrayGenerator;
    private final HierarchicalBitSet bitSet = new HierarchicalBitSet();
    private T[] objects;

    public ExpandingObjectAllocationList(Int2ObjectFunction<T[]> arrayGenerator) {
        this.arrayGenerator = arrayGenerator;
        this.objects = (Object[])this.arrayGenerator.apply(16);
    }

    public int put(T obj) {
        int id = this.bitSet.allocateNext();
        if (this.objects.length <= id) {
            int newLen = this.objects.length + (int)Math.ceil((float)this.objects.length * 0.75f);
            Object[] newArr = (Object[])this.arrayGenerator.apply(newLen);
            System.arraycopy(this.objects, 0, newArr, 0, this.objects.length);
            this.objects = newArr;
        }
        this.objects[id] = obj;
        return id;
    }

    public void release(int id) {
        if (!this.bitSet.free(id)) {
            throw new IllegalArgumentException("Index " + id + " was already released");
        }
        this.objects[id] = null;
    }

    public T get(int index) {
        if (!this.bitSet.isSet(index)) {
            throw new IllegalArgumentException("Index " + index + " is not allocated");
        }
        return this.objects[index];
    }

    public int count() {
        return this.bitSet.getCount();
    }
}

