/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.util;

import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.util.Arrays;
import me.cortex.voxy.common.util.TrackedObject;
import org.lwjgl.opengl.ARBTimerQuery;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL33;

public class GPUTiming {
    public static GPUTiming INSTANCE = new GPUTiming();
    private final GlTimestampQuerySet timingSet = new GlTimestampQuerySet();

    public void marker() {
        this.timingSet.capture(0);
    }

    public void tick() {
        this.timingSet.download((meta, data) -> {
            long current = data[0];
            for (int i = 1; i < meta.length; ++i) {
                long next = data[i];
                long delta = next - current;
                current = next;
            }
        });
        this.timingSet.tick();
    }

    public void free() {
        this.timingSet.free();
    }

    private static final class GlTimestampQuerySet
    extends TrackedObject {
        private final IntArrayFIFOQueue POOL = new IntArrayFIFOQueue();
        private final ObjectArrayFIFOQueue<InflightRequest> INFLIGHT = new ObjectArrayFIFOQueue();
        private final int[] queries = new int[64];
        private final int[] metadata = new int[64];
        private int index;

        private GlTimestampQuerySet() {
        }

        public void capture(int metadata) {
            if (this.index > this.metadata.length) {
                throw new IllegalStateException();
            }
            int slot = this.index++;
            this.metadata[slot] = metadata;
            int query = this.getQuery();
            ARBTimerQuery.glQueryCounter((int)query, (int)36392);
            this.queries[slot] = query;
        }

        public void download(TimingDataConsumer consumer) {
            int[] queries = Arrays.copyOf(this.queries, this.index);
            int[] metadata = Arrays.copyOf(this.metadata, this.index);
            this.index = 0;
            this.INFLIGHT.enqueue((Object)new InflightRequest(queries, metadata, consumer));
        }

        public void tick() {
            while (!this.INFLIGHT.isEmpty() && ((InflightRequest)this.INFLIGHT.first()).callbackIfReady(this.POOL)) {
                this.INFLIGHT.dequeue();
            }
        }

        private int getQuery() {
            if (this.POOL.isEmpty()) {
                return GL15.glGenQueries();
            }
            return this.POOL.dequeueInt();
        }

        @Override
        public void free() {
            super.free0();
            while (!this.POOL.isEmpty()) {
                GL15.glDeleteQueries((int)this.POOL.dequeueInt());
            }
            while (!this.INFLIGHT.isEmpty()) {
                GL15.glDeleteQueries((int[])((InflightRequest)this.INFLIGHT.dequeue()).queries);
            }
        }

        private record InflightRequest(int[] queries, int[] meta, TimingDataConsumer callback) {
            private boolean callbackIfReady(IntArrayFIFOQueue queryPool) {
                boolean ready;
                boolean bl = ready = GL15C.glGetQueryObjecti((int)this.queries[this.queries.length - 1], (int)34919) == 1;
                if (!ready) {
                    return false;
                }
                long[] results = new long[this.queries.length];
                for (int i = 0; i < this.queries.length; ++i) {
                    results[i] = GL33.glGetQueryObjecti64((int)this.queries[i], (int)34918);
                    queryPool.enqueue(this.queries[i]);
                }
                this.callback.accept(this.meta, results);
                return true;
            }
        }
    }

    public static interface TimingDataConsumer {
        public void accept(int[] var1, long[] var2);
    }
}

