/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.util;

import me.cortex.voxy.client.core.VoxyRenderSystem;
import me.cortex.voxy.client.core.rendering.Viewport;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.shadows.ShadowRenderer;

public class IrisUtil {
    public static CapturedViewportParameters CAPTURED_VIEWPORT_PARAMETERS;
    public static final boolean IRIS_INSTALLED;
    public static final boolean SHADER_SUPPORT = true;

    private static boolean irisShadowActive0() {
        return ShadowRenderer.ACTIVE;
    }

    public static boolean irisShadowActive() {
        return IRIS_INSTALLED && IrisUtil.irisShadowActive0();
    }

    public static void clearIrisSamplers() {
        if (IRIS_INSTALLED) {
            IrisUtil.clearIrisSamplers0();
        }
    }

    private static void clearIrisSamplers0() {
        for (int i = 0; i < 16; ++i) {
            IrisRenderSystem.bindSamplerToUnit((int)i, (int)0);
        }
    }

    private static boolean irisShaderPackEnabled0() {
        return Iris.isPackInUseQuick();
    }

    public static boolean irisShaderPackEnabled() {
        return IRIS_INSTALLED && IrisUtil.irisShaderPackEnabled0();
    }

    public static void disableIrisShaders() {
        if (IRIS_INSTALLED) {
            IrisUtil.disableIrisShaders0();
        }
    }

    private static void disableIrisShaders0() {
        IrisApi.getInstance().getConfig().setShadersEnabledAndApply(false);
    }

    static {
        IRIS_INSTALLED = FabricLoader.getInstance().isModLoaded("iris");
    }

    public record CapturedViewportParameters(ChunkRenderMatrices matrices, FogParameters parameters, double x, double y, double z) {
        public Viewport<?> apply(VoxyRenderSystem vrs) {
            return vrs.setupViewport(this.matrices, this.parameters, this.x, this.y, this.z);
        }
    }
}

