/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.core.util;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;
import java.util.Random;
import me.cortex.voxy.common.Logger;

public class RingTracker {
    private final Long2ByteOpenHashMap operations = new Long2ByteOpenHashMap(8192);
    private final int[] boundDist;
    private final int radius;
    private int centerX;
    private int centerZ;

    public RingTracker(int radius, int centerX, int centerZ, boolean fill) {
        this(null, radius, centerX, centerZ, fill);
    }

    public RingTracker(RingTracker stealFrom, int radius, int centerX, int centerZ, boolean fill) {
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.radius = radius;
        this.boundDist = this.generateBoundingHalfCircleDistance(radius);
        if (stealFrom != null) {
            this.operations.putAll((Map)stealFrom.operations);
            stealFrom.operations.clear();
        }
        if (fill) {
            this.fillRing(true);
        }
    }

    private static long pack(int x, int z) {
        return Integer.toUnsignedLong(x) | Integer.toUnsignedLong(z) << 32;
    }

    private void fillRing(boolean load) {
        for (int i = 0; i <= this.radius * 2; ++i) {
            int x = this.centerX + i - this.radius;
            int d = this.boundDist[i];
            for (int z = this.centerZ - d; z <= this.centerZ + d; ++z) {
                byte res = this.operations.addTo(RingTracker.pack(x, z), (byte)(load ? 1 : -1));
                if ((!load || 0 >= res) && (load || res >= 0)) continue;
                throw new IllegalStateException();
            }
        }
    }

    public void unload() {
        this.fillRing(false);
    }

    public void moveCenter(int x, int z) {
        if (this.radius + 1 < Math.abs(x - this.centerX) || this.radius + 1 < Math.abs(z - this.centerZ)) {
            this.fillRing(false);
            this.centerX = x;
            this.centerZ = z;
            this.fillRing(true);
        } else {
            if (x != this.centerX) {
                this.moveX(x - this.centerX);
            }
            if (z != this.centerZ) {
                this.moveZ(z - this.centerZ);
            }
        }
    }

    private void moveZ(int delta) {
        if (delta == 0) {
            return;
        }
        if (delta == -1 || delta == 1) {
            for (int i = 0; i <= this.radius * 2; ++i) {
                int x = this.centerX + i - this.radius;
                int d = this.boundDist[i] * delta;
                int pz = this.centerZ + d + delta;
                int nz = this.centerZ - d;
                if (0 < this.operations.addTo(RingTracker.pack(x, pz), (byte)1)) {
                    throw new IllegalStateException("x: " + x + ", z: " + pz + " state: " + this.operations.get(RingTracker.pack(x, pz)));
                }
                if (this.operations.addTo(RingTracker.pack(x, nz), (byte)-1) >= 0) continue;
                throw new IllegalStateException("x: " + x + ", z: " + nz + " state: " + this.operations.get(RingTracker.pack(x, nz)));
            }
            this.centerZ += delta;
        } else {
            int sDelta = Integer.signum(delta);
            for (int i = 0; i <= this.radius * 2; ++i) {
                int x = this.centerX + i - this.radius;
                int d = this.boundDist[i] * sDelta;
                int pz = this.centerZ + d;
                for (int z = pz + (sDelta < 0 ? delta : 1); z <= pz + (sDelta < 0 ? -1 : delta); ++z) {
                    if (0 >= this.operations.addTo(RingTracker.pack(x, z), (byte)1)) continue;
                    throw new IllegalStateException();
                }
                int nz = this.centerZ - d;
                for (int z = nz + (sDelta < 0 ? delta + 1 : 0); z < nz + (sDelta < 0 ? 1 : delta); ++z) {
                    if (this.operations.addTo(RingTracker.pack(x, z), (byte)-1) >= 0) continue;
                    throw new IllegalStateException();
                }
            }
            this.centerZ += delta;
        }
    }

    private void moveX(int delta) {
        if (delta == 0) {
            return;
        }
        if (delta == -1 || delta == 1) {
            for (int i = 0; i <= this.radius * 2; ++i) {
                int z = this.centerZ + i - this.radius;
                int d = this.boundDist[i] * delta;
                int px = this.centerX + d + delta;
                int nx = this.centerX - d;
                if (0 < this.operations.addTo(RingTracker.pack(px, z), (byte)1)) {
                    throw new IllegalStateException();
                }
                if (this.operations.addTo(RingTracker.pack(nx, z), (byte)-1) >= 0) continue;
                throw new IllegalStateException();
            }
            this.centerX += delta;
        } else {
            int sDelta = Integer.signum(delta);
            for (int i = 0; i <= this.radius * 2; ++i) {
                int z = this.centerZ + i - this.radius;
                int d = this.boundDist[i] * sDelta;
                int px = this.centerX + d;
                for (int x = px + (sDelta < 0 ? delta : 1); x <= px + (sDelta < 0 ? -1 : delta); ++x) {
                    if (0 >= this.operations.addTo(RingTracker.pack(x, z), (byte)1)) continue;
                    throw new IllegalStateException();
                }
                int nx = this.centerX - d;
                for (int x = nx + (sDelta < 0 ? delta + 1 : 0); x < nx + (sDelta < 0 ? 1 : delta); ++x) {
                    if (this.operations.addTo(RingTracker.pack(x, z), (byte)-1) >= 0) continue;
                    throw new IllegalStateException();
                }
            }
            this.centerX += delta;
        }
    }

    public int process(int N, IUpdateConsumer onAdd, IUpdateConsumer onRemove) {
        if (this.operations.isEmpty()) {
            return 0;
        }
        ObjectIterator iter = this.operations.long2ByteEntrySet().fastIterator();
        int i = 0;
        while (iter.hasNext() && N-- != 0) {
            Long2ByteMap.Entry entry = (Long2ByteMap.Entry)iter.next();
            if (entry.getByteValue() == 0) {
                iter.remove();
                ++N;
                continue;
            }
            ++i;
            byte op = entry.getByteValue();
            if (op != 1 && op != -1) {
                throw new IllegalStateException();
            }
            boolean isAdd = op == 1;
            long pos = entry.getLongKey();
            int x = (int)(pos & 0xFFFFFFFFL);
            int z = (int)(pos >>> 32 & 0xFFFFFFFFL);
            if (isAdd) {
                onAdd.accept(x, z);
            } else {
                onRemove.accept(x, z);
            }
            iter.remove();
        }
        return i;
    }

    private int[] generateBoundingHalfCircleDistance(int radius) {
        int[] ret = new int[radius * 2 + 1];
        for (int i = -radius; i <= radius; ++i) {
            ret[i + radius] = (int)Math.sqrt(radius * radius - i * i);
        }
        return ret;
    }

    public static void main(String[] args) {
        for (int j = 0; j < 50; ++j) {
            Random r = new Random((j + 18723) * 1234);
            RingTracker tracker = new RingTracker(r.nextInt(100) + 1, 0, 0, true);
            int R = r.nextInt(500);
            for (int i = 0; i < 50000; ++i) {
                int x2 = r.nextInt(R * 2 + 1) - R;
                int z2 = r.nextInt(R * 2 + 1) - R;
                tracker.moveCenter(x2, z2);
            }
            tracker.fillRing(false);
            tracker.process(64, (x, z) -> Logger.info("Add:", x, ",", z), (x, z) -> Logger.info("Remove:", x, ",", z));
        }
    }

    public static interface IUpdateConsumer {
        public void accept(int var1, int var2);
    }
}

