/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.client.mixin.sodium;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import me.cortex.voxy.client.ICheekyClientChunkCache;
import me.cortex.voxy.client.config.VoxyConfig;
import me.cortex.voxy.client.core.IGetVoxyRenderSystem;
import me.cortex.voxy.client.core.VoxyRenderSystem;
import me.cortex.voxy.client.mixin.sodium.AccessorChunkTracker;
import me.cortex.voxy.common.world.service.VoxelIngestService;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.map.ChunkTrackerHolder;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_631;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderSectionManager.class}, remap=false)
public class MixinRenderSectionManager {
    @Unique
    private static final boolean BOBBY_INSTALLED = FabricLoader.getInstance().isModLoaded("bobby");
    @Shadow
    @Final
    private class_638 level;
    @Shadow
    @Final
    private ChunkBuilder builder;
    @Unique
    private long cachedChunkPos = -1L;
    @Unique
    private int cachedChunkStatus;
    @Unique
    private int bottomSectionY;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void voxy$resetChunkTracker(class_638 level, int renderDistance, SortBehavior sortBehavior, CommandList commandList, CallbackInfo ci) {
        VoxyRenderSystem system;
        if (level.field_17780 != null && (system = ((IGetVoxyRenderSystem)level.field_17780).getVoxyRenderSystem()) != null) {
            system.chunkBoundRenderer.reset();
        }
        this.bottomSectionY = this.level.method_31607() >> 4;
    }

    @Inject(method={"onChunkRemoved"}, at={@At(value="HEAD")})
    private void injectIngest(int x, int z, CallbackInfo ci) {
        class_2818 chunk;
        ICheekyClientChunkCache cccm;
        if (VoxyConfig.CONFIG.ingestEnabled && !BOBBY_INSTALLED && (cccm = (ICheekyClientChunkCache)this.level.method_2935()) != null && (chunk = cccm.voxy$cheekyGetChunk(x, z)) != null) {
            VoxelIngestService.tryAutoIngestChunk(chunk);
        }
    }

    @Inject(method={"onChunkAdded"}, at={@At(value="HEAD")})
    private void voxy$ingestOnAdd(int x, int z, CallbackInfo ci) {
        class_2818 chunk;
        class_631 cccm;
        if (this.level.field_17780 != null && VoxyConfig.CONFIG.ingestEnabled && (cccm = this.level.method_2935()) != null && (chunk = cccm.method_2857(x, z, class_2806.field_12803, false)) != null) {
            VoxelIngestService.tryAutoIngestChunk(chunk);
        }
    }

    @Redirect(method={"updateSectionInfo"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSection;setInfo(Lnet/caffeinemc/mods/sodium/client/render/chunk/data/BuiltSectionInfo;)Z"))
    private boolean voxy$updateOnUpload(RenderSection instance, BuiltSectionInfo info) {
        boolean wasBuilt = instance.getFlags() != 0;
        int flags = instance.getFlags();
        if (!instance.setInfo(info)) {
            return false;
        }
        if (wasBuilt == (instance.getFlags() != 0)) {
            return true;
        }
        if ((flags |= instance.getFlags()) == 0) {
            return true;
        }
        VoxyRenderSystem system = ((IGetVoxyRenderSystem)this.level.field_17780).getVoxyRenderSystem();
        if (system == null) {
            return true;
        }
        int x = instance.getChunkX();
        int y = instance.getChunkY();
        int z = instance.getChunkZ();
        if (wasBuilt) {
            Long2IntOpenHashMap tracker = ((AccessorChunkTracker)ChunkTrackerHolder.get((class_638)this.level)).getChunkStatus();
            long key = class_1923.method_8331((int)x, (int)z);
            if (key != this.cachedChunkPos) {
                this.cachedChunkPos = key;
                this.cachedChunkStatus = tracker.getOrDefault(key, 0);
            }
            if (this.cachedChunkStatus == 3) {
                class_2826 section = this.level.method_8497(x, z).method_38259(y - this.bottomSectionY);
                class_3568 lp = this.level.method_22336();
                class_4076 csp = class_4076.method_18676((int)x, (int)y, (int)z);
                class_2804 blp = lp.method_15562(class_1944.field_9282).method_15544(csp);
                class_2804 slp = lp.method_15562(class_1944.field_9284).method_15544(csp);
                VoxelIngestService.rawIngest(system.getEngine(), section, x, y, z, blp == null ? null : blp.method_12144(), slp == null ? null : slp.method_12144());
            }
        }
        long pos = class_4076.method_18685((int)x, (int)y, (int)z);
        if (wasBuilt) {
            system.chunkBoundRenderer.removeSection(pos);
        } else {
            system.chunkBoundRenderer.addSection(pos);
        }
        return true;
    }
}

