/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.config.compressors;

import me.cortex.voxy.common.config.ConfigBuildCtx;
import me.cortex.voxy.common.config.compressors.CompressorConfig;
import me.cortex.voxy.common.config.compressors.StorageCompressor;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.ThreadLocalMemoryBuffer;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.lwjgl.system.MemoryUtil;

public class LZ4Compressor
implements StorageCompressor {
    private static final ThreadLocalMemoryBuffer SCRATCH = new ThreadLocalMemoryBuffer(525320L);
    private final net.jpountz.lz4.LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor = LZ4Factory.nativeInstance().fastDecompressor();

    public LZ4Compressor() {
        this.compressor = LZ4Factory.nativeInstance().fastCompressor();
    }

    @Override
    public MemoryBuffer compress(MemoryBuffer saveData) {
        MemoryBuffer res = new MemoryBuffer(this.compressor.maxCompressedLength((int)saveData.size) + 4);
        MemoryUtil.memPutInt((long)res.address, (int)((int)saveData.size));
        int size = this.compressor.compress(saveData.asByteBuffer(), 0, (int)saveData.size, res.asByteBuffer(), 4, (int)res.size - 4);
        return res.subSize(size + 4);
    }

    @Override
    public MemoryBuffer decompress(MemoryBuffer saveData) {
        MemoryBuffer res = SCRATCH.get().createUntrackedUnfreeableReference();
        int size = this.decompressor.decompress(saveData.asByteBuffer(), 4, res.asByteBuffer(), 0, MemoryUtil.memGetInt((long)saveData.address));
        return res.subSize(size);
    }

    @Override
    public void close() {
    }

    public static class Config
    extends CompressorConfig {
        @Override
        public StorageCompressor build(ConfigBuildCtx ctx) {
            return new LZ4Compressor();
        }

        public static String getConfigTypeName() {
            return "LZ4";
        }
    }
}

