/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.config.storage.lmdb;

import java.nio.IntBuffer;
import me.cortex.voxy.common.config.storage.lmdb.TransactionCallback;
import me.cortex.voxy.common.config.storage.lmdb.TransactionWrappedCallback;
import me.cortex.voxy.common.config.storage.lmdb.TransactionWrapper;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBEnvInfo;

public class LMDBInterface {
    private final long env;

    private LMDBInterface(long env) {
        this.env = env;
    }

    public void close() {
        LMDB.mdb_env_close((long)this.env);
    }

    public static void E(int rc) {
        if (rc != 0) {
            throw new IllegalStateException("Code: " + rc + " msg: " + LMDB.mdb_strerror((int)rc));
        }
    }

    public void setMapSize(long size) {
        LMDBInterface.E(LMDB.mdb_env_set_mapsize((long)this.env, (long)size));
    }

    public <T> T transaction(TransactionCallback<T> transaction) {
        return this.transaction(0, transaction);
    }

    public <T> T transaction(int flags, TransactionCallback<T> transaction) {
        return this.transaction(0L, flags, transaction);
    }

    public <T> T transaction(long parent, int flags, TransactionCallback<T> transaction) {
        T ret;
        try (MemoryStack stack = MemoryStack.stackPush();){
            int err;
            PointerBuffer pp = stack.mallocPointer(1);
            LMDBInterface.E(LMDB.mdb_txn_begin((long)this.env, (long)parent, (int)flags, (PointerBuffer)pp));
            long txn = pp.get(0);
            try {
                ret = transaction.exec(stack, txn);
                err = LMDB.mdb_txn_commit((long)txn);
            }
            catch (Throwable t) {
                LMDB.mdb_txn_abort((long)txn);
                throw t;
            }
            LMDBInterface.E(err);
        }
        return ret;
    }

    public Database createDb(String name) {
        return this.createDb(name, 262152);
    }

    public Database createDb(String name, int flags) {
        return new Database(name, flags);
    }

    public LMDBInterface flush(boolean force) {
        LMDBInterface.E(LMDB.mdb_env_sync((long)this.env, (boolean)force));
        return this;
    }

    public long getMapSize() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            MDBEnvInfo info = MDBEnvInfo.calloc((MemoryStack)stack);
            LMDBInterface.E(LMDB.mdb_env_info((long)this.env, (MDBEnvInfo)info));
            long l = info.me_mapsize();
            return l;
        }
    }

    public class Database {
        private final int dbi;

        public Database(String name, int flags) {
            this.dbi = LMDBInterface.this.transaction((MemoryStack stack, long txn) -> {
                IntBuffer ip = stack.mallocInt(1);
                LMDBInterface.E(LMDB.mdb_dbi_open((long)txn, (CharSequence)name, (int)flags, (IntBuffer)ip));
                return ip.get(0);
            });
        }

        public void close() {
            LMDB.mdb_dbi_close((long)LMDBInterface.this.env, (int)this.dbi);
        }

        public <T> T transaction(TransactionWrappedCallback<T> callback) {
            return this.transaction(0, callback);
        }

        public <T> T transaction(int flags, TransactionWrappedCallback<T> callback) {
            return (T)LMDBInterface.this.transaction(flags, (MemoryStack stack, long transaction) -> callback.exec(new TransactionWrapper(transaction, stack).set(this)));
        }

        public int getDBI() {
            return this.dbi;
        }
    }

    public static class Builder {
        private final long env;

        public Builder() {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer pp = stack.mallocPointer(1);
                LMDBInterface.E(LMDB.mdb_env_create((PointerBuffer)pp));
                this.env = pp.get(0);
            }
        }

        public Builder setMaxDbs(int maxDbs) {
            LMDBInterface.E(LMDB.mdb_env_set_maxdbs((long)this.env, (int)maxDbs));
            return this;
        }

        public Builder open(String directory, int flags) {
            LMDBInterface.E(LMDB.mdb_env_open((long)this.env, (CharSequence)directory, (int)flags, (int)436));
            return this;
        }

        public LMDBInterface fetch() {
            return new LMDBInterface(this.env);
        }
    }
}

