/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.config.storage.lmdb;

import java.nio.ByteBuffer;
import me.cortex.voxy.common.config.storage.lmdb.Cursor;
import me.cortex.voxy.common.config.storage.lmdb.LMDBInterface;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;
import org.lwjgl.util.lmdb.MDBVal;

public class TransactionWrapper {
    public final MemoryStack stack;
    private final long transaction;
    private int dbi;

    public TransactionWrapper(long transaction, MemoryStack stack) {
        this.transaction = transaction;
        this.stack = stack;
    }

    public TransactionWrapper set(LMDBInterface.Database db) {
        this.dbi = db.getDBI();
        return this;
    }

    public TransactionWrapper put(ByteBuffer key, ByteBuffer val, int flags) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LMDBInterface.E(LMDB.mdb_put((long)this.transaction, (int)this.dbi, (MDBVal)MDBVal.malloc((MemoryStack)stack).mv_data(key), (MDBVal)MDBVal.malloc((MemoryStack)stack).mv_data(val), (int)flags));
            TransactionWrapper transactionWrapper = this;
            return transactionWrapper;
        }
    }

    public TransactionWrapper del(ByteBuffer key) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LMDBInterface.E(LMDB.mdb_del((long)this.transaction, (int)this.dbi, (MDBVal)MDBVal.malloc((MemoryStack)stack).mv_data(key), null));
            TransactionWrapper transactionWrapper = this;
            return transactionWrapper;
        }
    }

    public ByteBuffer get(ByteBuffer key) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            MDBVal ret = MDBVal.malloc((MemoryStack)stack);
            int retVal = LMDB.mdb_get((long)this.transaction, (int)this.dbi, (MDBVal)MDBVal.calloc((MemoryStack)stack).mv_data(key), (MDBVal)ret);
            if (retVal == -30798) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            LMDBInterface.E(retVal);
            ByteBuffer byteBuffer = ret.mv_data();
            return byteBuffer;
        }
    }

    public Cursor createCursor() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pb = stack.mallocPointer(1);
            LMDBInterface.E(LMDB.mdb_cursor_open((long)this.transaction, (int)this.dbi, (PointerBuffer)pb));
            Cursor cursor = new Cursor(pb.get(0));
            return cursor;
        }
    }
}

