/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.config.storage.other;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.LongConsumer;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.config.ConfigBuildCtx;
import me.cortex.voxy.common.config.storage.StorageBackend;
import me.cortex.voxy.common.config.storage.StorageConfig;
import me.cortex.voxy.common.util.MemoryBuffer;
import net.minecraft.class_6673;

public class FragmentedStorageBackendAdaptor
extends StorageBackend {
    private final StorageBackend[] backends;

    public FragmentedStorageBackendAdaptor(StorageBackend ... backends) {
        this.backends = backends;
        int len = backends.length;
        if ((len & len - 1) != 0) {
            throw new IllegalArgumentException("Backend count not a power of 2");
        }
    }

    private int getSegmentId(long key) {
        return (int)(class_6673.method_39002((long)(class_6673.method_39002((long)key) ^ key)) & (long)(this.backends.length - 1));
    }

    @Override
    public void iterateStoredSectionPositions(LongConsumer consumer) {
        for (StorageBackend backend : this.backends) {
            backend.iterateStoredSectionPositions(consumer);
        }
    }

    @Override
    public MemoryBuffer getSectionData(long key, MemoryBuffer scratch) {
        return this.backends[this.getSegmentId(key)].getSectionData(key, scratch);
    }

    @Override
    public void setSectionData(long key, MemoryBuffer data) {
        this.backends[this.getSegmentId(key)].setSectionData(key, data);
    }

    @Override
    public void deleteSectionData(long key) {
        this.backends[this.getSegmentId(key)].deleteSectionData(key);
    }

    @Override
    public void putIdMapping(int id, ByteBuffer data) {
        for (StorageBackend backend : this.backends) {
            backend.putIdMapping(id, data);
        }
    }

    @Override
    public Int2ObjectOpenHashMap<byte[]> getIdMappingsData() {
        Object2IntOpenHashMap verification = new Object2IntOpenHashMap();
        Int2ObjectOpenHashMap any = null;
        for (StorageBackend backend : this.backends) {
            Int2ObjectOpenHashMap<byte[]> mappings = backend.getIdMappingsData();
            if (mappings.isEmpty()) continue;
            Int2ObjectOpenHashMap repackaged = new Int2ObjectOpenHashMap(mappings.size());
            for (Int2ObjectMap.Entry entry : mappings.int2ObjectEntrySet()) {
                repackaged.put(entry.getIntKey(), (Object)new EqualingArray((byte[])entry.getValue()));
            }
            verification.addTo((Object)repackaged, 1);
            any = repackaged;
        }
        if (any == null) {
            return new Int2ObjectOpenHashMap();
        }
        if (verification.size() != 1) {
            Logger.error("Error id mapping not matching across all fragments, attempting to recover");
            Object2IntMap.Entry maxEntry = null;
            for (Object2IntMap.Entry entry : verification.object2IntEntrySet()) {
                if (maxEntry == null) {
                    maxEntry = entry;
                    continue;
                }
                if (maxEntry.getIntValue() >= entry.getIntValue()) continue;
                maxEntry = entry;
            }
            Int2ObjectOpenHashMap mapping = (Int2ObjectOpenHashMap)maxEntry.getKey();
            Int2ObjectOpenHashMap out = new Int2ObjectOpenHashMap(mapping.size());
            for (Int2ObjectMap.Entry entry : mapping.int2ObjectEntrySet()) {
                out.put(entry.getIntKey(), (Object)((EqualingArray)entry.getValue()).bytes);
            }
            return out;
        }
        Int2ObjectOpenHashMap out = new Int2ObjectOpenHashMap(any.size());
        for (Int2ObjectMap.Entry entry : any.int2ObjectEntrySet()) {
            out.put(entry.getIntKey(), (Object)((EqualingArray)entry.getValue()).bytes);
        }
        return out;
    }

    @Override
    public void flush() {
        for (StorageBackend db : this.backends) {
            db.flush();
        }
    }

    @Override
    public void close() {
        for (StorageBackend db : this.backends) {
            db.close();
        }
    }

    @Override
    public List<StorageBackend> getChildBackends() {
        return List.of(this.backends);
    }

    private record EqualingArray(byte[] bytes) {
        @Override
        public boolean equals(Object obj) {
            return Arrays.equals(this.bytes, ((EqualingArray)obj).bytes);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }

    public static class Config2
    extends StorageConfig {
        public StorageConfig delegate;
        public String basePath;
        public int count;

        @Override
        public List<StorageConfig> getChildStorageConfigs() {
            return new ArrayList<StorageConfig>(Collections.singleton(this.delegate));
        }

        @Override
        public StorageBackend build(ConfigBuildCtx ctx) {
            StorageBackend[] builtBackends = new StorageBackend[this.count];
            for (int i = 0; i < this.count; ++i) {
                ctx.pushPath(this.basePath + "_" + i);
                builtBackends[i] = this.delegate.build(ctx);
                ctx.popPath();
            }
            return new FragmentedStorageBackendAdaptor(builtBackends);
        }

        public static String getConfigTypeName() {
            return "AutoFragmentationAdaptor";
        }
    }

    public static class Config
    extends StorageConfig {
        public List<StorageConfig> backends = new ArrayList<StorageConfig>();

        @Override
        public List<StorageConfig> getChildStorageConfigs() {
            return new ArrayList<StorageConfig>(this.backends);
        }

        @Override
        public StorageBackend build(ConfigBuildCtx ctx) {
            StorageBackend[] builtBackends = new StorageBackend[this.backends.size()];
            for (int i = 0; i < this.backends.size(); ++i) {
                builtBackends[i] = this.backends.get(i).build(ctx);
            }
            return new FragmentedStorageBackendAdaptor(builtBackends);
        }

        public static String getConfigTypeName() {
            return "FragmentationAdaptor";
        }
    }
}

