/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.config.storage.redis;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.LongConsumer;
import me.cortex.voxy.common.config.ConfigBuildCtx;
import me.cortex.voxy.common.config.storage.StorageBackend;
import me.cortex.voxy.common.config.storage.StorageConfig;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.UnsafeUtil;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisStorageBackend
extends StorageBackend {
    private final JedisPool pool;
    private final String user;
    private final String password;
    private final byte[] WORLD;
    private final byte[] MAPPINGS;

    public RedisStorageBackend(String host, int port, String prefix) {
        this(host, port, prefix, null, null);
    }

    public RedisStorageBackend(String host, int port, String prefix, String user, String password) {
        this.pool = new JedisPool(host, port);
        this.user = user;
        this.password = password;
        this.WORLD = (prefix + "world_sections").getBytes(StandardCharsets.UTF_8);
        this.MAPPINGS = (prefix + "id_mappings").getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void iterateStoredSectionPositions(LongConsumer consumer) {
        throw new IllegalStateException("Not yet implemented");
    }

    @Override
    public MemoryBuffer getSectionData(long key, MemoryBuffer scratch) {
        try (Jedis jedis = this.pool.getResource();){
            byte[] result;
            if (this.user != null) {
                jedis.auth(this.user, this.password);
            }
            if ((result = jedis.hget(this.WORLD, RedisStorageBackend.longToBytes(key))) == null) {
                MemoryBuffer memoryBuffer = null;
                return memoryBuffer;
            }
            UnsafeUtil.memcpy(result, scratch.address);
            MemoryBuffer memoryBuffer = scratch.subSize(result.length);
            return memoryBuffer;
        }
    }

    @Override
    public void setSectionData(long key, MemoryBuffer data) {
        try (Jedis jedis = this.pool.getResource();){
            if (this.user != null) {
                jedis.auth(this.user, this.password);
            }
            byte[] buffer = new byte[(int)data.size];
            UnsafeUtil.memcpy(data.address, buffer);
            jedis.hset(this.WORLD, RedisStorageBackend.longToBytes(key), buffer);
        }
    }

    @Override
    public void deleteSectionData(long key) {
        try (Jedis jedis = this.pool.getResource();){
            if (this.user != null) {
                jedis.auth(this.user, this.password);
            }
            jedis.hdel(this.WORLD, (byte[][])new byte[][]{RedisStorageBackend.longToBytes(key)});
        }
    }

    @Override
    public void putIdMapping(int id, ByteBuffer data) {
        try (Jedis jedis = this.pool.getResource();){
            if (this.user != null) {
                jedis.auth(this.user, this.password);
            }
            byte[] buffer = new byte[data.remaining()];
            data.get(buffer);
            data.rewind();
            jedis.hset(this.MAPPINGS, RedisStorageBackend.intToBytes(id), buffer);
        }
    }

    @Override
    public Int2ObjectOpenHashMap<byte[]> getIdMappingsData() {
        try (Jedis jedis = this.pool.getResource();){
            if (this.user != null) {
                jedis.auth(this.user, this.password);
            }
            Map mappings = jedis.hgetAll(this.MAPPINGS);
            Int2ObjectOpenHashMap out = new Int2ObjectOpenHashMap();
            if (mappings == null) {
                Int2ObjectOpenHashMap int2ObjectOpenHashMap = out;
                return int2ObjectOpenHashMap;
            }
            for (Map.Entry entry : mappings.entrySet()) {
                out.put(RedisStorageBackend.bytesToInt((byte[])entry.getKey()), (Object)((byte[])entry.getValue()));
            }
            Int2ObjectOpenHashMap int2ObjectOpenHashMap = out;
            return int2ObjectOpenHashMap;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.pool.close();
    }

    private static byte[] intToBytes(int i) {
        return new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    private static int bytesToInt(byte[] i) {
        return Byte.toUnsignedInt(i[0]) << 24 | Byte.toUnsignedInt(i[1]) << 16 | Byte.toUnsignedInt(i[2]) << 8 | Byte.toUnsignedInt(i[3]);
    }

    private static byte[] longToBytes(long l) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }

    private static long bytesToLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    public static class Config
    extends StorageConfig {
        public String host;
        public int port;
        public String prefix;

        @Override
        public StorageBackend build(ConfigBuildCtx ctx) {
            return new RedisStorageBackend(this.host, this.port, ctx.substituteString(this.prefix));
        }

        public static String getConfigTypeName() {
            return "Redis";
        }
    }
}

