/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.thread;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.thread.Service;
import me.cortex.voxy.common.util.Pair;

public class ServiceManager {
    private final IntConsumer jobRelease;
    private final ThreadLocal<ThreadCtx> accelerationContext = ThreadLocal.withInitial(ThreadCtx::new);
    private final AtomicInteger totalJobs = new AtomicInteger();
    private volatile Service[] services = new Service[0];
    private volatile boolean isShutdown = false;

    public ServiceManager(IntConsumer jobRelease) {
        this.jobRelease = jobRelease;
    }

    public Service createServiceNoCleanup(Supplier<Runnable> ctxFactory, long weight) {
        return this.createService(() -> new Pair<Runnable, Runnable>((Runnable)ctxFactory.get(), () -> {}), weight, "");
    }

    public Service createServiceNoCleanup(Supplier<Runnable> ctxFactory, long weight, String name) {
        return this.createService(() -> new Pair<Runnable, Runnable>((Runnable)ctxFactory.get(), () -> {}), weight, name);
    }

    public Service createService(Supplier<Pair<Runnable, Runnable>> ctxFactory, long weight) {
        return this.createService(ctxFactory, weight, "");
    }

    public Service createService(Supplier<Pair<Runnable, Runnable>> ctxFactory, long weight, String name) {
        return this.createService(ctxFactory, weight, name, null);
    }

    public synchronized Service createService(Supplier<Pair<Runnable, Runnable>> ctxFactory, long weight, String name, BooleanSupplier limiter) {
        Service newService = new Service(ctxFactory, this, weight, name, limiter);
        Service[] newServices = Arrays.copyOf(this.services, this.services.length + 1);
        newServices[newServices.length - 1] = newService;
        this.services = newServices;
        return newService;
    }

    public int tryRunAJob() {
        if (this.services.length == 0 || this.totalJobs.get() == 0) {
            return 1;
        }
        return this.runAJob0();
    }

    private int runAJob0() {
        if (this.services.length == 0) {
            return 1;
        }
        ThreadCtx ctx = this.accelerationContext.get();
        block0: while (true) {
            int shiftFactor;
            long skipMsk = 0L;
            Service[] services = this.services;
            if (services.length == 0) {
                return 1;
            }
            if (this.totalJobs.get() == 0) {
                return 1;
            }
            long totalWeight = 0L;
            int c = shiftFactor = ctx.shiftFactor++ & Integer.MAX_VALUE;
            Service selectedService = null;
            for (int i = 0; i < services.length; ++i) {
                boolean sc;
                Service service = services[i];
                if (!service.isLive()) {
                    Thread.yield();
                    continue block0;
                }
                boolean bl = sc = c-- <= 0;
                if (service.limiter != null && !service.limiter.getAsBoolean()) {
                    skipMsk |= 1L << i;
                    continue;
                }
                long jc = service.numJobs();
                if (sc && jc != 0L && selectedService == null) {
                    selectedService = service;
                }
                totalWeight += jc * service.weight;
            }
            if (totalWeight == 0L) {
                return skipMsk != 0L ? 3 : 2;
            }
            long sample = ctx.rand(totalWeight);
            for (int i = 0; i < services.length; ++i) {
                Service service = services[(i + shiftFactor) % services.length];
                if (!(service.limiter == null || (skipMsk & 1L << i) == 0L && service.limiter.getAsBoolean())) {
                    skipMsk |= 1L << i;
                    continue;
                }
                if ((sample -= (long)service.numJobs() * service.weight) > 0L) continue;
                selectedService = service;
                break;
            }
            if (selectedService == null) {
                return skipMsk != 0L ? 3 : 2;
            }
            if (selectedService.isLive() && selectedService.runJob()) break;
        }
        if (this.totalJobs.decrementAndGet() < 0) {
            throw new IllegalStateException("Job count <0");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.isShutdown) {
            throw new IllegalStateException("Service manager already shutdown");
        }
        this.isShutdown = true;
        while (this.services.length != 0) {
            Thread.yield();
            ServiceManager serviceManager = this;
            synchronized (serviceManager) {
                for (Service s : this.services) {
                    if (!s.isLive()) continue;
                    throw new IllegalStateException("Service '" + s.name + "' was not in shutdown when manager shutdown");
                }
            }
        }
        while (this.totalJobs.get() != 0) {
            Thread.yield();
        }
    }

    synchronized void removeService(Service service) {
        Service[] services = this.services;
        Service[] newServices = new Service[services.length - 1];
        int j = 0;
        for (int i = 0; i < services.length; ++i) {
            if (services[i] == service) continue;
            newServices[j++] = services[i];
        }
        if (j != newServices.length) {
            throw new IllegalStateException("Could not find the service in the services array");
        }
        this.services = newServices;
    }

    void execute(Service service) {
        this.totalJobs.incrementAndGet();
        this.jobRelease.accept(1);
    }

    void remJobs(int remaining) {
        if (this.totalJobs.addAndGet(-remaining) < 0) {
            throw new IllegalStateException("total jobs <0");
        }
    }

    void handleException(Service service, Exception exception) {
        Logger.error("Service '" + service.name + "' on thread '" + Thread.currentThread().getName() + "' had an exception", exception);
    }

    private static final class ThreadCtx {
        int shiftFactor = 0;
        long seed = HashCommon.murmurHash3((long)(System.nanoTime() ^ (long)System.identityHashCode(this)));

        ThreadCtx() {
        }

        long rand(long size) {
            this.seed = HashCommon.mix((long)this.seed);
            return this.seed % size;
        }
    }
}

