/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.util;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Random;

public class HierarchicalBitSet {
    public static final int SET_FULL = -1;
    private final int limit;
    private int cnt;
    private long A = 0L;
    private final long[] B = new long[64];
    private final long[] C = new long[4096];
    private final long[] D = new long[262144];
    private int endId = -1;

    public HierarchicalBitSet(int limit) {
        this.limit = limit;
        if (limit > 0x1000000) {
            throw new IllegalArgumentException("Limit greater than capacity");
        }
    }

    public HierarchicalBitSet() {
        this(0x1000000);
    }

    public int allocateNext() {
        if (this.A == -1L) {
            return -1;
        }
        if (this.cnt + 1 > this.limit) {
            return -1;
        }
        int idx = Long.numberOfTrailingZeros(this.A ^ 0xFFFFFFFFFFFFFFFFL);
        long bp = this.B[idx];
        idx = Long.numberOfTrailingZeros(bp ^ 0xFFFFFFFFFFFFFFFFL) + 64 * idx;
        long cp = this.C[idx];
        idx = Long.numberOfTrailingZeros(cp ^ 0xFFFFFFFFFFFFFFFFL) + 64 * idx;
        long dp = this.D[idx];
        int ret = idx = Long.numberOfTrailingZeros(dp ^ 0xFFFFFFFFFFFFFFFFL) + 64 * idx;
        this.D[idx >> 6] = dp |= 1L << (idx & 0x3F);
        if (dp == -1L) {
            this.C[idx >> 6] = cp |= 1L << ((idx >>= 6) & 0x3F);
            if (cp == -1L) {
                this.B[idx >> 6] = bp |= 1L << ((idx >>= 6) & 0x3F);
                if (bp == -1L) {
                    this.A |= 1L << ((idx >>= 6) & 0x3F);
                }
            }
        }
        ++this.cnt;
        this.endId += ret == this.endId + 1 ? 1 : 0;
        return ret;
    }

    private void set(int idx) {
        this.endId += idx == this.endId + 1 ? 1 : 0;
        int n = idx >> 6;
        this.D[n] = this.D[n] | 1L << (idx & 0x3F);
        long dp = this.D[n];
        if (dp == -1L) {
            int n2 = (idx >>= 6) >> 6;
            this.C[n2] = this.C[n2] | 1L << (idx & 0x3F);
            long cp = this.C[n2];
            if (cp == -1L) {
                int n3 = (idx >>= 6) >> 6;
                this.B[n3] = this.B[n3] | 1L << (idx & 0x3F);
                long bp = this.B[n3];
                if (bp == -1L) {
                    this.A |= 1L << ((idx >>= 6) & 0x3F);
                }
            }
        }
        ++this.cnt;
    }

    private int findNextFree(int idx) {
        int pos;
        do {
            pos = Long.numberOfTrailingZeros((this.A ^ 0xFFFFFFFFFFFFFFFFL) & -(1L << (idx >> 18)));
            idx = Math.max(pos << 18, idx);
            pos = Long.numberOfTrailingZeros((this.B[idx >> 18] ^ 0xFFFFFFFFFFFFFFFFL) & -(1L << (idx >> 12 & 0x3F)));
            idx = Math.max(pos + (idx >> 18 << 6) << 12, idx);
            if (pos == 64) continue;
            pos = Long.numberOfTrailingZeros((this.C[idx >> 12] ^ 0xFFFFFFFFFFFFFFFFL) & -(1L << (idx >> 6 & 0x3F)));
            idx = Math.max(pos + (idx >> 12 << 6) << 6, idx);
            if (pos == 64) continue;
            pos = Long.numberOfTrailingZeros((this.D[idx >> 6] ^ 0xFFFFFFFFFFFFFFFFL) & -(1L << (idx & 0x3F)));
            idx = Math.max(pos + (idx >> 6 << 6), idx);
        } while (pos == 64);
        return idx;
    }

    public int allocateNextConsecutiveCounted(int count) {
        if (count > 64) {
            throw new IllegalStateException("Count to large for current implementation which has fastpath");
        }
        if (this.A == -1L) {
            return -1;
        }
        if (this.cnt + count >= this.limit) {
            return -2;
        }
        long chkMsk = (1L << count) - 1L;
        int i = this.findNextFree(0);
        while (true) {
            long fusedValue = this.D[i >> 6] >>> (i & 0x3F);
            if (64 - (i & 0x3F) < count) {
                fusedValue |= this.D[(i >> 6) + 1] << 64 - (i & 0x3F);
            }
            if ((fusedValue & chkMsk) == 0L) break;
            i += Long.numberOfTrailingZeros(fusedValue);
            i = this.findNextFree(i);
        }
        for (int j = 0; j < count; ++j) {
            this.set(j + i);
        }
        return i;
    }

    public boolean free(int idx) {
        long v = this.D[idx >> 6];
        boolean wasSet = (v & 1L << (idx & 0x3F)) != 0L;
        this.cnt -= wasSet ? 1 : 0;
        if (wasSet && idx == this.endId) {
            --this.endId;
            while (this.endId >= 0 && !this.isSet(this.endId)) {
                --this.endId;
            }
        }
        this.D[idx >> 6] = v & (1L << (idx & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        int n = (idx >>= 6) >> 6;
        this.C[n] = this.C[n] & (1L << (idx & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        int n2 = (idx >>= 6) >> 6;
        this.B[n2] = this.B[n2] & (1L << (idx & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        this.A &= 1L << ((idx >>= 6) & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
        return wasSet;
    }

    public int getCount() {
        return this.cnt;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isSet(int idx) {
        return (this.D[idx >> 6] & 1L << (idx & 0x3F)) != 0L;
    }

    public int getMaxIndex() {
        return this.endId;
    }

    public static void main3(String[] args) {
        int i;
        HierarchicalBitSet h = new HierarchicalBitSet(524288);
        for (i = 0; i < 524288; ++i) {
            if (h.allocateNext() != i) {
                throw new IllegalStateException("At:" + i);
            }
            if (h.endId == i) continue;
            throw new IllegalStateException();
        }
        for (i = 0; i < 262144; ++i) {
            if (h.free(i)) continue;
            throw new IllegalStateException();
        }
        for (i = 524287; i != 262143; --i) {
            if (h.endId != i) {
                throw new IllegalStateException();
            }
            if (h.free(i)) continue;
            throw new IllegalStateException();
        }
        if (h.endId != -1) {
            throw new IllegalStateException();
        }
    }

    public static void main2(String[] args) {
        int i;
        HierarchicalBitSet h = new HierarchicalBitSet();
        for (i = 0; i < 2048; ++i) {
            h.set(i);
        }
        h.set(0);
        i = 0;
        while (i < 2048) {
            int j = h.findNextFree(i);
            if (h.isSet(j)) {
                throw new IllegalStateException();
            }
            for (int k = i; k < j; ++k) {
                if (h.isSet(k)) continue;
                throw new IllegalStateException();
            }
            i = j + 1;
        }
        Random r = new Random(0L);
        for (int i2 = 0; i2 < 500; ++i2) {
            h.free(r.nextInt(2048));
        }
        h.allocateNextConsecutiveCounted(10);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; ++i) {
            int j;
            Random r = new Random((long)i * 12345L);
            HierarchicalBitSet h = new HierarchicalBitSet();
            IntOpenHashSet set = new IntOpenHashSet(10000);
            for (j = 0; j < 100000; ++j) {
                int q = h.allocateNext();
                if (q == j && set.add(q)) continue;
                throw new IllegalStateException();
            }
            for (j = 0; j < 100000; ++j) {
                int op = r.nextInt(5);
                int extra = r.nextInt(8) + 1;
                if (op == 0) {
                    int v = h.allocateNext();
                    if (v < 0) {
                        throw new IllegalStateException();
                    }
                    if (set.add(v)) continue;
                    throw new IllegalStateException();
                }
                if (op == 1) {
                    int base = h.allocateNextConsecutiveCounted(extra);
                    if (base < 0) {
                        throw new IllegalStateException();
                    }
                    for (int q = 0; q < extra; ++q) {
                        if (set.add(q + base)) continue;
                        throw new IllegalStateException();
                    }
                    continue;
                }
                if (op >= 5 || set.isEmpty()) continue;
                int rr = r.nextInt(set.size());
                IntIterator s = set.iterator();
                if (rr != 0) {
                    s.skip(rr);
                }
                int q = s.nextInt();
                s.remove();
                if (h.free(q)) continue;
                throw new IllegalStateException();
            }
        }
    }
}

