/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.util;

import java.lang.invoke.VarHandle;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class MessageQueue<T> {
    private final Consumer<T> consumer;
    private final ConcurrentLinkedDeque<T> queue = new ConcurrentLinkedDeque();
    private final AtomicInteger count = new AtomicInteger(0);

    public MessageQueue(Consumer<T> consumer) {
        this.consumer = consumer;
    }

    public void push(T obj) {
        this.queue.add(obj);
        this.count.addAndGet(1);
    }

    public int consume() {
        return this.consume(Integer.MAX_VALUE);
    }

    public int consume(int max) {
        T entry;
        int i;
        if (this.count.get() == 0) {
            return 0;
        }
        for (i = 0; i < max && (entry = this.queue.poll()) != null; ++i) {
            this.consumer.accept(entry);
        }
        if (i != 0) {
            this.count.addAndGet(-i);
        }
        return i;
    }

    public int consumeNano(long budget) {
        T entry;
        if (this.count.get() == 0) {
            return 0;
        }
        int i = 0;
        long nano = System.nanoTime();
        VarHandle.fullFence();
        while ((entry = this.queue.poll()) != null) {
            ++i;
            this.consumer.accept(entry);
            if (System.nanoTime() - nano < budget) continue;
        }
        if (i != 0) {
            this.count.addAndGet(-i);
        }
        return i;
    }

    public final void clear(Consumer<T> cleaner) {
        T v;
        while ((v = this.queue.poll()) != null) {
            cleaner.accept(v);
        }
    }

    public int count() {
        return this.count.get();
    }
}

