/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class MultiGson {
    private final List<Class<?>> classes;
    private final Gson gson;

    private MultiGson(Gson gson, List<Class<?>> classes) {
        this.gson = gson;
        this.classes = classes;
    }

    public String toJson(Object ... objects) {
        Object[] map = new Object[this.classes.size()];
        if (map.length != objects.length) {
            throw new IllegalArgumentException("Incorrect number of input args");
        }
        for (Object obj : objects) {
            if (obj == null) {
                throw new IllegalArgumentException();
            }
            int i2 = this.classes.indexOf(obj.getClass());
            if (i2 == -1) {
                throw new IllegalArgumentException("Unknown object class: " + String.valueOf(obj.getClass()));
            }
            if (map[i2] != null) {
                throw new IllegalArgumentException("Duplicate entry classes");
            }
            map[i2] = obj;
        }
        JsonObject json = new JsonObject();
        for (Object entry : map) {
            this.gson.toJsonTree(entry).getAsJsonObject().asMap().forEach((i, j) -> {
                if (json.has(i)) {
                    throw new IllegalArgumentException("Duplicate name inside unified json: " + i);
                }
                json.add(i, j);
            });
        }
        return this.gson.toJson((JsonElement)json);
    }

    public Map<Class<?>, Object> fromJson(String json) {
        JsonObject obj = (JsonObject)this.gson.fromJson(json, JsonObject.class);
        LinkedHashMap objects = new LinkedHashMap();
        for (Class<?> cls : this.classes) {
            objects.put(cls, this.gson.fromJson((JsonElement)obj, cls));
        }
        return objects;
    }

    public static void main(String[] args) {
        MultiGson gson = new Builder().add(A.class).add(B.class).build();
        A a = new A();
        a.c = 11;
        B b = new B();
        System.out.println(gson.fromJson(gson.toJson(a, b)));
    }

    public static class Builder {
        private final LinkedHashSet<Class<?>> classes = new LinkedHashSet();
        private final GsonBuilder gsonBuilder;

        public Builder(GsonBuilder gsonBuilder) {
            this.gsonBuilder = gsonBuilder;
        }

        public Builder() {
            this(new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}));
        }

        public Builder add(Class<?> clz) {
            if (!this.classes.add(clz)) {
                throw new IllegalArgumentException("Class has already been added");
            }
            return this;
        }

        public MultiGson build() {
            return new MultiGson(this.gsonBuilder.create(), new ArrayList(this.classes));
        }
    }

    private static final class A {
        public int a;
        public int b;
        public int c;
        public int d;

        private A() {
        }
    }

    private static final class B {
        public int q;
        public int e;
        public int g;
        public int l;

        private B() {
        }
    }
}

