/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.common.world.WorldSection;
import org.jetbrains.annotations.Nullable;

public class ActiveSectionTracker {
    private final AtomicInteger loadedSections = new AtomicInteger();
    private final Long2ObjectOpenHashMap<VolatileHolder<WorldSection>>[] loadedSectionCache;
    private final StampedLock[] locks;
    private final SectionLoader loader;
    private final int lruSize;
    private final StampedLock lruLock = new StampedLock();
    private final Long2ObjectLinkedOpenHashMap<WorldSection> lruSecondaryCache;
    @Nullable
    public final WorldEngine engine;

    public ActiveSectionTracker(int numSlicesBits, SectionLoader loader, int cacheSize) {
        this(numSlicesBits, loader, cacheSize, null);
    }

    public ActiveSectionTracker(int numSlicesBits, SectionLoader loader, int cacheSize, WorldEngine engine) {
        this.engine = engine;
        this.loader = loader;
        this.loadedSectionCache = new Long2ObjectOpenHashMap[1 << numSlicesBits];
        this.lruSecondaryCache = new Long2ObjectLinkedOpenHashMap(cacheSize);
        this.locks = new StampedLock[1 << numSlicesBits];
        this.lruSize = cacheSize;
        for (int i = 0; i < this.loadedSectionCache.length; ++i) {
            this.loadedSectionCache[i] = new Long2ObjectOpenHashMap(1024);
            this.locks[i] = new StampedLock();
        }
    }

    public WorldSection acquire(int lvl, int x, int y, int z, boolean nullOnEmpty) {
        return this.acquire(WorldEngine.getWorldSectionId(lvl, x, y, z), nullOnEmpty);
    }

    public WorldSection acquire(long key, boolean nullOnEmpty) {
        if (this.engine != null) {
            this.engine.lastActiveTime = System.currentTimeMillis();
        }
        int index = this.getCacheArrayIndex(key);
        Long2ObjectOpenHashMap<VolatileHolder<WorldSection>> cache = this.loadedSectionCache[index];
        StampedLock lock = this.locks[index];
        VolatileHolder holder = null;
        boolean isLoader = false;
        WorldSection section = null;
        long stamp = lock.readLock();
        holder = (VolatileHolder)cache.get(key);
        if (holder != null) {
            section = (WorldSection)holder.obj;
            if (section != null) {
                section.acquire();
                lock.unlockRead(stamp);
                return section;
            }
            lock.unlockRead(stamp);
        } else {
            holder = new VolatileHolder();
            long ws = lock.tryConvertToWriteLock(stamp);
            if (ws == 0L) {
                lock.unlockRead(stamp);
                stamp = lock.writeLock();
            } else {
                stamp = ws;
            }
            VolatileHolder eHolder = (VolatileHolder)cache.putIfAbsent(key, holder);
            lock.unlockWrite(stamp);
            if (eHolder == null) {
                isLoader = true;
            } else {
                holder = eHolder;
            }
        }
        if (isLoader) {
            this.loadedSections.incrementAndGet();
            long stamp2 = lock.readLock();
            long stamp3 = this.lruLock.writeLock();
            section = (WorldSection)this.lruSecondaryCache.remove(key);
            WorldSection removal = null;
            if (section == null && !this.lruSecondaryCache.isEmpty() && this.lruSize + 100 < this.lruSecondaryCache.size() + this.getLoadedCacheCount()) {
                removal = (WorldSection)this.lruSecondaryCache.removeFirst();
            }
            this.lruLock.unlockWrite(stamp3);
            if (section != null) {
                section.primeForReuse();
                section.acquire(1);
            }
            lock.unlockRead(stamp2);
            if (removal != null) {
                removal._releaseArray();
            }
        } else {
            VolatileHolder.PRE_ACQUIRE_COUNT.getAndAdd(holder, 1);
        }
        if (isLoader) {
            int status = 0;
            if (section == null) {
                section = new WorldSection(WorldEngine.getLevel(key), WorldEngine.getX(key), WorldEngine.getY(key), WorldEngine.getZ(key), this);
                status = this.loader.load(section);
                if (status < 0) {
                    Logger.error("Unable to load section " + section.key + " setting to air");
                    status = 1;
                }
                if (status == 1) {
                    Arrays.fill(section.data, 0L);
                }
                section.acquire(1);
            }
            int preAcquireCount = VolatileHolder.PRE_ACQUIRE_COUNT.getAndSet(holder, 0);
            section.acquire(preAcquireCount);
            VolatileHolder.POST_ACQUIRE_COUNT.set(holder, preAcquireCount);
            VarHandle.storeStoreFence();
            holder.obj = section;
            VarHandle.releaseFence();
            if (nullOnEmpty && status == 1) {
                section.release();
                return null;
            }
            return section;
        }
        VarHandle.fullFence();
        while ((section = (WorldSection)holder.obj) == null) {
            VarHandle.fullFence();
            Thread.onSpinWait();
            Thread.yield();
        }
        if (0 < VolatileHolder.POST_ACQUIRE_COUNT.getAndAdd(holder, -1)) {
            return section;
        }
        if (section.tryAcquire()) {
            return section;
        }
        return this.acquire(key, nullOnEmpty);
    }

    void tryUnload(WorldSection section) {
        if (this.engine != null) {
            this.engine.lastActiveTime = System.currentTimeMillis();
        }
        if (section.isDirty && this.engine != null && section.tryAcquire()) {
            if (section.setNotDirty()) {
                this.engine.saveSection(section);
            }
            section.release(false);
        }
        if (section.getRefCount() != 0) {
            return;
        }
        int index = this.getCacheArrayIndex(section.key);
        Long2ObjectOpenHashMap<VolatileHolder<WorldSection>> cache = this.loadedSectionCache[index];
        WorldSection sec = null;
        StampedLock lock = this.locks[index];
        long stamp = lock.writeLock();
        VarHandle.loadLoadFence();
        if (section.isDirty) {
            if (section.tryAcquire()) {
                if (section.setNotDirty() && this.engine != null) {
                    this.engine.saveSection(section);
                }
                section.release(false);
            } else {
                throw new IllegalStateException("Section was dirty but is also unloaded, this is very bad");
            }
        }
        if (section.getRefCount() == 0 && section.trySetFreed()) {
            VolatileHolder cached = (VolatileHolder)cache.remove(section.key);
            WorldSection obj = (WorldSection)cached.obj;
            if (obj == null) {
                throw new IllegalStateException("This should be impossible: " + WorldEngine.pprintPos(section.key) + " secObj: " + System.identityHashCode(section));
            }
            if (obj != section) {
                throw new IllegalStateException("Removed section not the same as the referenced section in the cache: cached: " + String.valueOf(obj) + " got: " + String.valueOf(section) + " A: " + String.valueOf(WorldSection.ATOMIC_STATE_HANDLE.get(obj)) + " B: " + String.valueOf(WorldSection.ATOMIC_STATE_HANDLE.get(section)));
            }
            sec = section;
        }
        WorldSection aa = null;
        if (sec != null) {
            long stamp2 = this.lruLock.writeLock();
            lock.unlockWrite(stamp);
            WorldSection a = (WorldSection)this.lruSecondaryCache.put(section.key, (Object)section);
            if (a != null) {
                throw new IllegalStateException("duplicate sections in cache is impossible");
            }
            if (this.lruSize < this.lruSecondaryCache.size()) {
                aa = (WorldSection)this.lruSecondaryCache.removeFirst();
            }
            this.lruLock.unlockWrite(stamp2);
        } else {
            lock.unlockWrite(stamp);
        }
        if (aa != null) {
            aa._releaseArray();
        }
        if (sec != null) {
            this.loadedSections.decrementAndGet();
        }
    }

    private int getCacheArrayIndex(long pos) {
        return (int)(ActiveSectionTracker.mixStafford13(pos) & (long)(this.loadedSectionCache.length - 1));
    }

    public static long mixStafford13(long seed) {
        seed = (seed ^ seed >>> 30) * -4658895280553007687L;
        seed = (seed ^ seed >>> 27) * -7723592293110705685L;
        return seed ^ seed >>> 31;
    }

    public int getLoadedCacheCount() {
        return this.loadedSections.get();
    }

    public int getSecondaryCacheSize() {
        return this.lruSecondaryCache.size();
    }

    public static void main(String[] args) throws InterruptedException {
        ActiveSectionTracker tracker = new ActiveSectionTracker(6, a -> 0, 2048);
        WorldSection bean = tracker.acquire(0, 0, 0, 9, false);
        WorldSection bean2 = tracker.acquire(1, 0, 0, 0, false);
        System.out.println("Target obj:" + System.identityHashCode(bean2));
        bean2.release();
        Thread[] ts = new Thread[10];
        for (int i = 0; i < ts.length; ++i) {
            int tid = i;
            ts[i] = new Thread(() -> {
                try {
                    for (int j = 0; j < 5000; ++j) {
                        WorldSection section = tracker.acquire(0, 0, 0, 0, false);
                        section.acquire();
                        WorldSection section2 = tracker.acquire(1, 0, 0, 0, false);
                        section.release();
                        section.release();
                        section2.release();
                        section = tracker.acquire(0, 0, 0, 0, false);
                        section2 = tracker.acquire(1, 0, 0, 0, false);
                        section2.release();
                        section.release();
                        tracker.acquire(1, 0, 0, 0, false).release();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Thread " + tid, e);
                }
            });
            ts[i].start();
        }
        for (Thread t : ts) {
            t.join();
        }
    }

    public static interface SectionLoader {
        public int load(WorldSection var1);
    }

    private static final class VolatileHolder<T> {
        private static final VarHandle PRE_ACQUIRE_COUNT;
        private static final VarHandle POST_ACQUIRE_COUNT;
        public volatile int preAcquireCount;
        public volatile int postAcquireCount;
        public volatile T obj;

        private VolatileHolder() {
        }

        static {
            try {
                PRE_ACQUIRE_COUNT = MethodHandles.lookup().findVarHandle(VolatileHolder.class, "preAcquireCount", Integer.TYPE);
                POST_ACQUIRE_COUNT = MethodHandles.lookup().findVarHandle(VolatileHolder.class, "postAcquireCount", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

