/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.world;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Arrays;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.UnsafeUtil;
import me.cortex.voxy.common.world.WorldSection;
import me.cortex.voxy.common.world.other.Mapper;
import net.minecraft.class_3532;
import org.lwjgl.system.MemoryUtil;

public class SaveLoadSystem2 {
    private static final ThreadLocal<SerialCache> SERIALIZE_CACHE = ThreadLocal.withInitial(() -> new SerialCache());
    private static final ThreadLocal<DeserialCache> DESERIALIZE_CACHE = ThreadLocal.withInitial(() -> new DeserialCache());

    public static int lin2z(int i) {
        int x = i & 0x1F;
        int y = i >> 10 & 0x1F;
        int z = i >> 5 & 0x1F;
        return Integer.expand(x, 4681) | Integer.expand(y, 9362) | Integer.expand(z, 18724);
    }

    public static int z2lin(int i) {
        int x = Integer.compress(i, 4681);
        int y = Integer.compress(i, 9362);
        int z = Integer.compress(i, 18724);
        return x | y << 10 | z << 5;
    }

    public static MemoryBuffer serialize(WorldSection section) {
        int b;
        int i;
        SerialCache cache = SERIALIZE_CACHE.get();
        long[] data = new long[32768];
        section.copyDataTo(data);
        boolean allSameBlockLight = true;
        boolean allSameSkyLight = true;
        byte[] blockLight = new byte[16384];
        byte[] skyLight = new byte[16384];
        short[] blocks = new short[32768];
        short[] biome = new short[32768];
        Int2IntOpenHashMap blockMapping = new Int2IntOpenHashMap();
        blockMapping.defaultReturnValue(-1);
        Int2IntOpenHashMap biomeMapping = new Int2IntOpenHashMap();
        biomeMapping.defaultReturnValue(-1);
        int[] blockLutVals = new int[32768];
        int[] biomeLutVals = new int[32768];
        long hash = 12345L;
        for (int i2 = 0; i2 < 32768; ++i2) {
            int bid;
            long state = data[SaveLoadSystem2.lin2z(i2)];
            hash ^= state * 1892671L + 19827911L;
            hash *= 198729111L;
            hash ^= hash >>> 32;
            byte bl = (byte)(Mapper.getLightId(state) >> 4 & 0xF);
            int n = i2 >> 1;
            blockLight[n] = (byte)(blockLight[n] | (byte)(bl << (i2 & 1) * 4));
            byte sl = (byte)(Mapper.getLightId(state) & 0xF);
            int n2 = i2 >> 1;
            skyLight[n2] = (byte)(skyLight[n2] | (byte)(sl << (i2 & 1) * 4));
            if (i2 != 0) {
                allSameBlockLight &= (blockLight[0] & 0xF) == bl;
                allSameSkyLight &= (skyLight[0] & 0xF) == sl;
            }
            if ((bid = blockMapping.putIfAbsent(Mapper.getBlockId(state), blockMapping.size())) == -1) {
                bid = blockMapping.size() - 1;
                blockLutVals[bid] = Mapper.getBlockId(state);
            }
            blocks[i2] = (short)bid;
            bid = biomeMapping.putIfAbsent(Mapper.getBiomeId(state), biomeMapping.size());
            if (bid == -1) {
                bid = biomeMapping.size() - 1;
                biomeLutVals[bid] = Mapper.getBiomeId(state);
            }
            biome[i2] = (short)bid;
        }
        MemoryBuffer res = new MemoryBuffer(263168L);
        long ptr = res.address;
        MemoryUtil.memPutLong((long)ptr, (long)section.key);
        MemoryUtil.memPutLong((long)(ptr += 8L), (long)hash);
        ptr += 8L;
        int meta = 0;
        meta |= allSameBlockLight ? 1 : 0;
        meta |= allSameSkyLight ? 2 : 0;
        meta |= biomeMapping.size() - 1 << 2;
        meta |= blockMapping.size() - 1 << 11;
        MemoryUtil.memPutInt((long)ptr, (int)(meta |= Byte.toUnsignedInt(section.nonEmptyChildren) << 23));
        ptr += 4L;
        if (allSameBlockLight) {
            MemoryUtil.memPutByte((long)ptr, (byte)((byte)(blockLight[0] & 0xF)));
            ++ptr;
        } else {
            UnsafeUtil.memcpy(blockLight, ptr);
            ptr += (long)blockLight.length;
        }
        if (allSameSkyLight) {
            MemoryUtil.memPutByte((long)ptr, (byte)((byte)(skyLight[0] & 0xF)));
            ++ptr;
        } else {
            UnsafeUtil.memcpy(skyLight, ptr);
            ptr += (long)skyLight.length;
        }
        int rem = 32;
        int batch = 0;
        int SIZE = 20;
        for (i = 0; i < blockMapping.size(); ++i) {
            b = blockLutVals[i];
            if (rem != 0) {
                batch |= b << 32 - rem;
            }
            if (rem < SIZE) {
                MemoryUtil.memPutInt((long)ptr, (int)batch);
                ptr += 4L;
                batch = b >> rem;
                rem = 32 - (SIZE - rem);
                continue;
            }
            rem -= SIZE;
        }
        SIZE = 9;
        for (i = 0; i < biomeMapping.size(); ++i) {
            b = biomeLutVals[i];
            if (rem != 0) {
                batch |= b << 32 - rem;
            }
            if (rem < SIZE) {
                MemoryUtil.memPutInt((long)ptr, (int)batch);
                ptr += 4L;
                batch = b >> rem;
                rem = 32 - (SIZE - rem);
                continue;
            }
            rem -= SIZE;
        }
        if (rem != 32) {
            MemoryUtil.memPutInt((long)ptr, (int)batch);
            ptr += 4L;
        }
        int SIZE2 = class_3532.method_15339((int)class_3532.method_15351((int)class_3532.method_15339((int)blockMapping.size())));
        int rem2 = 32;
        int batch2 = 0;
        for (short b2 : blocks) {
            if (rem2 != 0) {
                batch2 |= b2 << 32 - rem2;
            }
            if (rem2 < SIZE2) {
                MemoryUtil.memPutInt((long)ptr, (int)batch2);
                ptr += 4L;
                batch2 = b2 >> rem2;
                rem2 = 32 - (SIZE2 - rem2);
                continue;
            }
            rem2 -= SIZE2;
        }
        if (rem2 != 32) {
            MemoryUtil.memPutInt((long)ptr, (int)batch2);
            ptr += 4L;
        }
        if (biomeMapping.size() != 1) {
            SIZE2 = class_3532.method_15339((int)class_3532.method_15351((int)class_3532.method_15339((int)biomeMapping.size())));
            rem2 = 32;
            batch2 = 0;
            for (short b2 : biome) {
                if (rem2 != 0) {
                    batch2 |= b2 << 32 - rem2;
                }
                if (rem2 < SIZE2) {
                    MemoryUtil.memPutInt((long)ptr, (int)batch2);
                    ptr += 4L;
                    batch2 = b2 >> rem2;
                    rem2 = 32 - (SIZE2 - rem2);
                    continue;
                }
                rem2 -= SIZE2;
            }
            if (rem2 != 32) {
                MemoryUtil.memPutInt((long)ptr, (int)batch2);
                ptr += 4L;
            }
        }
        return res.subSize(ptr - res.address);
    }

    public static boolean deserialize(WorldSection section, MemoryBuffer data) {
        int val;
        int i;
        int val2;
        int i2;
        long skyLight;
        long blockLight;
        DeserialCache cache = DESERIALIZE_CACHE.get();
        long ptr = data.address;
        long pos = MemoryUtil.memGetLong((long)ptr);
        ptr += 8L;
        if (section.key != pos) {
            Logger.error("Section pos not the same as requested, got " + pos + " expected " + section.key);
            return false;
        }
        long chash = MemoryUtil.memGetLong((long)ptr);
        int meta = MemoryUtil.memGetInt((long)(ptr += 8L));
        ptr += 4L;
        boolean allSameBlockLight = (meta & 1) != 0;
        boolean allSameSkyLight = (meta & 2) != 0;
        int biomeMapSize = (meta >> 2 & 0x1FF) + 1;
        int blockMapSize = (meta >> 11 & 0xFFF) + 1;
        section._unsafeSetNonEmptyChildren((byte)(meta >> 23 & 0xFF));
        if (allSameBlockLight) {
            blockLight = Byte.toUnsignedLong(MemoryUtil.memGetByte((long)ptr)) << 4;
            ++ptr;
        } else {
            blockLight = ptr;
            ptr += 16384L;
        }
        if (allSameSkyLight) {
            skyLight = MemoryUtil.memGetByte((long)ptr);
            ++ptr;
        } else {
            skyLight = ptr;
            ptr += 16384L;
        }
        int[] blockLut = new int[blockMapSize];
        int[] biomeLut = new int[biomeMapSize];
        int rem = 32;
        int batch = MemoryUtil.memGetInt((long)ptr);
        ptr += 4L;
        int SIZE = 20;
        int msk = (1 << SIZE) - 1;
        for (i2 = 0; i2 < blockMapSize; ++i2) {
            val2 = batch & msk;
            batch >>>= SIZE;
            if ((rem -= SIZE) < 0) {
                batch = MemoryUtil.memGetInt((long)ptr);
                ptr += 4L;
                val2 |= (batch & (1 << -rem) - 1) << SIZE + rem;
                batch >>>= -rem;
                rem = 32 + rem;
            }
            blockLut[i2] = val2;
        }
        SIZE = 9;
        msk = (1 << SIZE) - 1;
        for (i2 = 0; i2 < biomeMapSize; ++i2) {
            val2 = batch & msk;
            batch >>>= SIZE;
            if ((rem -= SIZE) < 0) {
                batch = MemoryUtil.memGetInt((long)ptr);
                ptr += 4L;
                val2 |= (batch & (1 << -rem) - 1) << SIZE + rem;
                batch >>>= -rem;
                rem = 32 + rem;
            }
            biomeLut[i2] = val2;
        }
        short[] blocks = new short[32768];
        short[] biomes = new short[32768];
        SIZE = class_3532.method_15339((int)class_3532.method_15351((int)class_3532.method_15339((int)blockMapSize)));
        int rem2 = 32;
        int batch2 = MemoryUtil.memGetInt((long)ptr);
        ptr += 4L;
        int msk2 = (1 << SIZE) - 1;
        for (i = 0; i < blocks.length; ++i) {
            val = batch2 & msk2;
            batch2 >>>= SIZE;
            if ((rem2 -= SIZE) < 0) {
                batch2 = MemoryUtil.memGetInt((long)ptr);
                ptr += 4L;
                val |= (batch2 & (1 << -rem2) - 1) << SIZE + rem2;
                batch2 >>>= -rem2;
                rem2 = 32 + rem2;
            }
            blocks[i] = (short)val;
        }
        if (biomeMapSize == 1) {
            Arrays.fill(biomes, (short)0);
        } else {
            SIZE = class_3532.method_15339((int)class_3532.method_15351((int)class_3532.method_15339((int)biomeMapSize)));
            rem2 = 32;
            batch2 = MemoryUtil.memGetInt((long)ptr);
            ptr += 4L;
            msk2 = (1 << SIZE) - 1;
            for (i = 0; i < biomes.length; ++i) {
                val = batch2 & msk2;
                batch2 >>>= SIZE;
                if ((rem2 -= SIZE) < 0) {
                    batch2 = MemoryUtil.memGetInt((long)ptr);
                    ptr += 4L;
                    val |= (batch2 & (1 << -rem2) - 1) << SIZE + rem2;
                    batch2 >>>= -rem2;
                    rem2 = 32 + rem2;
                }
                biomes[i] = (short)val;
            }
        }
        long hash = 12345L;
        for (i2 = 0; i2 < 32768; ++i2) {
            byte light = 0;
            light = allSameBlockLight ? (byte)(light | (byte)(blockLight & 0xF0L)) : (byte)(light | (byte)((Byte.toUnsignedInt(MemoryUtil.memGetByte((long)(blockLight + (long)(i2 >> 1)))) >> (i2 & 1) * 4 & 0xF) << 4));
            light = allSameSkyLight ? (byte)(light | (byte)(skyLight & 0xFL)) : (byte)(light | (byte)(Byte.toUnsignedInt(MemoryUtil.memGetByte((long)(skyLight + (long)(i2 >> 1)))) >> (i2 & 1) * 4 & 0xF));
            int block = blockLut[blocks[i2]];
            int biome = biomeLut[biomes[i2]];
            long state = Mapper.composeMappingId(light, block, biome);
            hash ^= state * 1892671L + 19827911L;
            hash *= 198729111L;
            hash ^= hash >>> 32;
            section.data[SaveLoadSystem2.lin2z((int)i2)] = state;
        }
        if (chash != hash) {
            Logger.error("Hash does not match what is expected, got: " + hash + " expected: " + chash);
            return false;
        }
        return true;
    }

    public static void main2(String[] args) {
        MemoryBuffer aa = new MemoryBuffer(502400L);
        int blockMapSize = 100000;
        long ptr = aa.address;
        int rem = 32;
        int batch = 0;
        int SIZE = 20;
        for (int i = 0; i < blockMapSize; ++i) {
            int b = i;
            if (rem != 0) {
                batch |= b << 32 - rem;
            }
            if (rem < SIZE) {
                MemoryUtil.memPutInt((long)ptr, (int)batch);
                ptr += 4L;
                batch = b >> rem;
                rem = 32 - (SIZE - rem);
                continue;
            }
            rem -= SIZE;
        }
        if (rem != 32) {
            MemoryUtil.memPutInt((long)ptr, (int)batch);
            ptr += 4L;
        }
        System.err.println(ptr - aa.address);
        ptr = aa.address;
        rem = 32;
        batch = MemoryUtil.memGetInt((long)ptr);
        ptr += 4L;
        SIZE = 20;
        int msk = (1 << SIZE) - 1;
        for (int i = 0; i < blockMapSize; ++i) {
            int val = batch & msk;
            batch >>>= SIZE;
            if ((rem -= SIZE) < 0) {
                batch = MemoryUtil.memGetInt((long)ptr);
                ptr += 4L;
                val |= (batch & (1 << -rem) - 1) << SIZE + rem;
                batch >>>= -rem;
                rem = 32 + rem;
            }
            if (val == i) continue;
            throw new IllegalStateException();
        }
        System.err.println(ptr - aa.address);
    }

    public static void main(String[] args) {
        WorldSection test = WorldSection._createRawUntrackedUnsafeSection(0, 1, 2, 3);
        test._unsafeSetNonEmptyChildren((byte)-77);
        for (int i = 0; i < 32768; ++i) {
            test.data[i] = Mapper.composeMappingId((byte)(i % 256), 12 + i % 1666, i % 300);
        }
        MemoryBuffer res = SaveLoadSystem2.serialize(test);
        WorldSection test2 = WorldSection._createRawUntrackedUnsafeSection(test.lvl, test.x, test.y, test.z);
        System.out.println(SaveLoadSystem2.deserialize(test2, res));
        boolean a = false;
        for (int i = 0; i < 32768; ++i) {
            if (test.data[i] == test2.data[i]) continue;
            throw new IllegalStateException();
        }
    }

    private record SerialCache() {
    }

    private record DeserialCache() {
    }
}

