/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.common.world;

import it.unimi.dsi.fastutil.longs.Long2ShortOpenHashMap;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.ThreadLocalMemoryBuffer;
import me.cortex.voxy.common.world.WorldSection;
import me.cortex.voxy.common.world.other.Mapper;
import org.lwjgl.system.MemoryUtil;

public class SaveLoadSystem3 {
    public static final int STORAGE_VERSION = 0;
    private static final ThreadLocal<SerializationCache> CACHE = ThreadLocal.withInitial(SerializationCache::new);

    public static int lin2z(int i) {
        int x = i & 0x1F;
        int y = i >> 10 & 0x1F;
        int z = i >> 5 & 0x1F;
        return Integer.expand(x, 4681) | Integer.expand(y, 9362) | Integer.expand(z, 18724);
    }

    public static int z2lin(int i) {
        int x = Integer.compress(i, 4681);
        int y = Integer.compress(i, 9362);
        int z = Integer.compress(i, 18724);
        return x | y << 10 | z << 5;
    }

    public static MemoryBuffer serialize(WorldSection section) {
        SerializationCache cache = CACHE.get();
        long[] data = section.data;
        Long2ShortOpenHashMap LUT = cache.lutMapCache;
        LUT.clear();
        MemoryBuffer buffer = cache.memoryBuffer().createUntrackedUnfreeableReference();
        long ptr = buffer.address;
        MemoryUtil.memPutLong((long)ptr, (long)section.key);
        long metadataPtr = ptr += 8L;
        long blockPtr = ptr += 8L;
        ptr += 65536L;
        for (long block : data) {
            short mapping = LUT.putIfAbsent(block, (short)LUT.size());
            if (mapping == -1) {
                mapping = (short)(LUT.size() - 1);
                MemoryUtil.memPutLong((long)ptr, (long)block);
                ptr += 8L;
            }
            MemoryUtil.memPutShort((long)blockPtr, (short)mapping);
            blockPtr += 2L;
        }
        if (LUT.size() >= 65536) {
            throw new IllegalStateException();
        }
        long metadata = 0L;
        metadata |= Integer.toUnsignedLong(LUT.size());
        MemoryUtil.memPutLong((long)metadataPtr, (long)(metadata |= Byte.toUnsignedLong(section.getNonEmptyChildren()) << 16));
        return buffer.subSize(ptr - buffer.address).copy();
    }

    public static boolean deserialize(WorldSection section, MemoryBuffer data) {
        long ptr = data.address;
        long key = MemoryUtil.memGetLong((long)ptr);
        ptr += 8L;
        if (section.key != key) {
            Logger.error("Decompressed section not the same as requested. got: " + key + " expected: " + section.key);
            return false;
        }
        long metadata = MemoryUtil.memGetLong((long)ptr);
        section.nonEmptyChildren = (byte)(metadata >>> 16 & 0xFFL);
        long lutBasePtr = (ptr += 8L) + 65536L;
        if (section.lvl == 0) {
            int nonEmptyBlockCount = 0;
            long[] blockData = section.data;
            for (int i = 0; i < 32768; ++i) {
                short lutId = MemoryUtil.memGetShort((long)ptr);
                ptr += 2L;
                long blockId = MemoryUtil.memGetLong((long)(lutBasePtr + Short.toUnsignedLong(lutId) * 8L));
                nonEmptyBlockCount += Mapper.isAir(blockId) ? 0 : 1;
                blockData[i] = blockId;
            }
            section.nonEmptyBlockCount = nonEmptyBlockCount;
        } else {
            long[] blockData = section.data;
            for (int i = 0; i < 32768; ++i) {
                blockData[i] = MemoryUtil.memGetLong((long)(lutBasePtr + Short.toUnsignedLong(MemoryUtil.memGetShort((long)ptr)) * 8L));
                ptr += 2L;
            }
        }
        ptr = lutBasePtr + (metadata & 0xFFFFL) * 8L;
        return true;
    }

    private record SerializationCache(Long2ShortOpenHashMap lutMapCache, MemoryBuffer memoryBuffer) {
        public SerializationCache() {
            this(new Long2ShortOpenHashMap(1024), ThreadLocalMemoryBuffer.create(328704L));
            this.lutMapCache.defaultReturnValue((short)-1);
        }
    }
}

