/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.commonImpl;

import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.config.Serialization;
import me.cortex.voxy.commonImpl.VoxyInstance;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class VoxyCommon
implements ModInitializer {
    public static final String MOD_VERSION;
    public static final boolean IS_DEDICATED_SERVER;
    public static final boolean IS_IN_MINECRAFT;
    private static VoxyInstance INSTANCE;
    private static IInstanceFactory FACTORY;
    public static final boolean IS_MINE_IN_ABYSS = false;

    public static boolean isVerificationFlagOn(String name) {
        return VoxyCommon.isVerificationFlagOn(name, false);
    }

    public static boolean isVerificationFlagOn(String name, boolean defaultOn) {
        return System.getProperty("voxy." + name, defaultOn ? "true" : "false").equals("true");
    }

    public static void breakpoint() {
        boolean breakpoint = false;
    }

    public void onInitialize() {
    }

    public static void setInstanceFactory(IInstanceFactory factory) {
        if (FACTORY != null) {
            throw new IllegalStateException("Cannot set instance factory more than once");
        }
        FACTORY = factory;
    }

    public static VoxyInstance getInstance() {
        return INSTANCE;
    }

    public static void shutdownInstance() {
        if (INSTANCE != null) {
            VoxyInstance instance = INSTANCE;
            INSTANCE = null;
            instance.shutdown();
        }
    }

    public static void createInstance() {
        if (FACTORY == null) {
            return;
        }
        if (INSTANCE != null) {
            throw new IllegalStateException("Cannot create multiple instances");
        }
        INSTANCE = FACTORY.create();
    }

    public static boolean isAvailable() {
        return FACTORY != null;
    }

    static {
        ModContainer mod = FabricLoader.getInstance().getModContainer("voxy").orElse(null);
        if (mod == null) {
            IS_IN_MINECRAFT = false;
            Logger.error("Running voxy without minecraft");
            MOD_VERSION = "<UNKNOWN>";
            IS_DEDICATED_SERVER = false;
        } else {
            IS_IN_MINECRAFT = true;
            String version = mod.getMetadata().getVersion().getFriendlyString();
            String commit = mod.getMetadata().getCustomValue("commit").getAsString();
            MOD_VERSION = version + "-" + commit;
            IS_DEDICATED_SERVER = FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
            Serialization.init();
        }
        FACTORY = null;
    }

    public static interface IInstanceFactory {
        public VoxyInstance create();
    }
}

