/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.commonImpl.configuration;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.util.MultiGson;
import net.fabricmc.loader.api.FabricLoader;

public class VoxyConfigStore {
    private final MultiGson gson;

    private VoxyConfigStore(Object ... defaultValues) {
        GsonBuilder gb = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2});
        final HashMap defaultValueMap = new HashMap();
        MultiGson.Builder mgb = new MultiGson.Builder(gb);
        for (Object i : defaultValues) {
            mgb.add(i.getClass());
            defaultValueMap.put(i.getClass(), i);
        }
        gb.registerTypeAdapterFactory(new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> typeToken) {
                if (defaultValueMap.containsKey(typeToken.getRawType())) {
                    final Object defVal = defaultValueMap.get(typeToken.getRawType());
                    final TypeAdapter adapter = gson.getDelegateAdapter((TypeAdapterFactory)this, typeToken);
                    return new TypeAdapter<T>(this){

                        public void write(JsonWriter writer, T obj) throws IOException {
                            JsonObject defJson = adapter.toJsonTree(defVal).getAsJsonObject();
                            JsonObject val = adapter.toJsonTree(obj).getAsJsonObject();
                            for (String key : defJson.keySet()) {
                                if (!val.has(key) || !defJson.get(key).equals(val.get(key))) continue;
                                val.addProperty(key, "DEFAULT_VALUE");
                            }
                            gson.toJson((JsonElement)val, writer);
                        }

                        public T read(JsonReader reader) throws IOException {
                            JsonObject defJson = adapter.toJsonTree(defVal).getAsJsonObject();
                            JsonObject val = ((JsonElement)gson.fromJson(reader, JsonElement.class)).getAsJsonObject();
                            for (String key : defJson.keySet()) {
                                if (!val.has(key) || !val.get(key).equals(new JsonPrimitive("DEFAULT_VALUE"))) continue;
                                val.add(key, defJson.get(key));
                            }
                            return adapter.fromJsonTree((JsonElement)val);
                        }
                    };
                }
                return null;
            }
        });
        this.gson = mgb.build();
    }

    public void save() {
        try {
            Files.writeString(VoxyConfigStore.getConfigPath(), (CharSequence)this.gson.toJson(this), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error("Failed to write config file", e);
        }
    }

    private static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("voxy-config.json");
    }
}

