/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.commonImpl.importers;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.thread.Service;
import me.cortex.voxy.common.thread.ServiceManager;
import me.cortex.voxy.common.util.Pair;
import me.cortex.voxy.common.voxelization.VoxelizedSection;
import me.cortex.voxy.common.voxelization.WorldConversionFactory;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.common.world.WorldUpdater;
import me.cortex.voxy.common.world.other.Mapper;
import me.cortex.voxy.commonImpl.importers.IDataImporter;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.apache.commons.io.IOUtils;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BasicArrayCache;
import org.tukaani.xz.ResettableArrayCache;
import org.tukaani.xz.XZInputStream;

public class DHImporter
implements IDataImporter {
    private final Connection db;
    private final WorldEngine engine;
    private final Service service;
    private final class_1937 world;
    private final int bottomOfWorld;
    private final int worldHeightSections;
    private final class_6880.class_6883<class_1959> defaultBiome;
    private final class_2378<class_1959> biomeRegistry;
    private final class_2378<class_2248> blockRegistry;
    private Thread runner;
    private volatile boolean isRunning = false;
    private final AtomicInteger processedChunks = new AtomicInteger();
    private int totalChunks;
    private IDataImporter.IUpdateCallback updateCallback;
    private final ConcurrentLinkedDeque<Task> tasks = new ConcurrentLinkedDeque();
    public static final boolean HasRequiredLibraries;
    private static final VarHandle LONG;

    public DHImporter(File file, WorldEngine worldEngine, class_1937 mcWorld, ServiceManager servicePool, BooleanSupplier rateLimiter) {
        this.engine = worldEngine;
        this.world = mcWorld;
        this.biomeRegistry = mcWorld.method_30349().method_30530(class_7924.field_41236);
        this.defaultBiome = this.biomeRegistry.method_46747(class_1972.field_9451);
        this.blockRegistry = mcWorld.method_30349().method_30530(class_7924.field_41254);
        this.bottomOfWorld = mcWorld.method_31607();
        int worldHeight = mcWorld.method_31605();
        this.worldHeightSections = (worldHeight + 15) / 16;
        String con = "jdbc:sqlite:" + file.getPath();
        try {
            this.db = DriverManager.getConnection(con);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.service = servicePool.createService(() -> {
            try {
                PreparedStatement dataFetchStmt = this.db.prepareStatement("SELECT Data,ColumnGenerationStep,Mapping FROM FullData WHERE DetailLevel = 0 AND PosX = ? AND PosZ = ?;");
                WorkCTX ctx = new WorkCTX(dataFetchStmt, this.worldHeightSections * 16);
                return new Pair<Runnable, Runnable>(() -> this.importSection(dataFetchStmt, ctx, this.tasks.poll()), () -> {
                    try {
                        dataFetchStmt.close();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }, 10L, "DH Importer", rateLimiter);
    }

    @Override
    public void runImport(IDataImporter.IUpdateCallback updateCallback, IDataImporter.ICompletionCallback completionCallback) {
        if (this.isRunning()) {
            throw new IllegalStateException();
        }
        this.engine.acquireRef();
        this.updateCallback = updateCallback;
        this.runner = new Thread(() -> {
            PriorityQueue<Task> taskQ = new PriorityQueue<Task>(Comparator.comparingLong(Task::distanceFromZero));
            try (Statement stmt = this.db.createStatement();){
                ResultSet resSet = stmt.executeQuery("SELECT PosX,PosZ,CompressionMode,DataFormatVersion FROM FullData WHERE DetailLevel = 0;");
                while (resSet.next()) {
                    int x = resSet.getInt(1);
                    int z = resSet.getInt(2);
                    int compression = resSet.getInt(3);
                    int format = resSet.getInt(4);
                    if (format != 1) {
                        Logger.warn("Unknown format mode: " + format);
                        continue;
                    }
                    if (compression != 3) {
                        Logger.warn("Unknown compression mode: " + compression);
                        continue;
                    }
                    taskQ.add(new Task(x, z, format, compression));
                }
                resSet.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            this.totalChunks = taskQ.size() * 16;
            while (this.isRunning && !taskQ.isEmpty()) {
                this.tasks.add((Task)taskQ.poll());
                this.service.execute();
                while (this.tasks.size() > 100 && this.isRunning) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            while (!this.tasks.isEmpty()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            completionCallback.onCompletion(this.processedChunks.get());
            this.shutdown();
        });
        this.isRunning = true;
        this.runner.setDaemon(true);
        this.runner.start();
    }

    private static void readStream(InputStream in, ResettableArrayCache cache, byte[] into) throws IOException {
        cache.reset();
        XZInputStream stream = new XZInputStream(IOUtils.toBufferedInputStream((InputStream)in), (ArrayCache)cache);
        stream.read(into);
        stream.close();
    }

    private static String getSerialBlockState(class_2680 state) {
        ArrayList props = new ArrayList(state.method_28501());
        props.sort((a, b) -> a.method_11899().compareTo(b.method_11899()));
        StringBuilder b2 = new StringBuilder();
        for (class_2769 prop : props) {
            String val = "NULL";
            if (state.method_28498(prop)) {
                val = state.method_11654(prop).toString();
            }
            b2.append("{").append(prop.method_11899()).append(":").append(val).append("}");
        }
        return b2.toString();
    }

    private long[] readMappings(InputStream in, WorkCTX ctx) throws IOException {
        String BLOCK_STATE_SEPARATOR_STRING = "_DH-BSW_";
        String STATE_STRING_SEPARATOR = "_STATE_";
        ctx.cache.reset();
        DataInputStream stream = new DataInputStream((InputStream)new XZInputStream(IOUtils.toBufferedInputStream((InputStream)in), (ArrayCache)ctx.cache));
        int entries = stream.readInt();
        if (entries < 0) {
            throw new IllegalStateException();
        }
        long[] out = new long[entries];
        for (int i = 0; i < entries; ++i) {
            int blockId;
            String encEntry = stream.readUTF();
            int idx = encEntry.indexOf("_DH-BSW_");
            if (idx == -1) {
                throw new IllegalStateException();
            }
            class_2960 biomeRes = class_2960.method_60654((String)encEntry.substring(0, idx));
            class_6880.class_6883<class_1959> biome = this.biomeRegistry.method_10223(biomeRes).orElse(this.defaultBiome);
            int biomeId = this.engine.getMapper().getIdForBiome((class_6880<class_1959>)biome);
            int b = idx + "_DH-BSW_".length();
            if (encEntry.substring(b).equals("AIR")) {
                blockId = 0;
            } else {
                int sIdx = encEntry.indexOf("_STATE_", b);
                String bStateStr = null;
                if (sIdx != -1) {
                    bStateStr = encEntry.substring(sIdx + "_STATE_".length());
                }
                class_2960 bId = class_2960.method_60654((String)encEntry.substring(b, sIdx != -1 ? sIdx : encEntry.length()));
                Optional maybeBlock = this.blockRegistry.method_10223(bId);
                class_2248 block = class_2246.field_10124;
                if (maybeBlock.isPresent()) {
                    block = (class_2248)((class_6880.class_6883)maybeBlock.get()).comp_349();
                }
                class_2680 state = block.method_9564();
                if (bStateStr != null && block != class_2246.field_10124) {
                    boolean found = false;
                    for (class_2680 bState : block.method_9595().method_11662()) {
                        if (!DHImporter.getSerialBlockState(bState).equals(bStateStr)) continue;
                        state = bState;
                        found = true;
                        break;
                    }
                    if (!found) {
                        Logger.warn("Could not find block state with data", encEntry.substring(b));
                    }
                }
                if (block == class_2246.field_10124) {
                    Logger.warn("Could not find block entry with id:", bId);
                }
                blockId = this.engine.getMapper().getIdForBlockState(state);
            }
            out[i] = Mapper.composeMappingId((byte)0, blockId, biomeId);
        }
        stream.close();
        return out;
    }

    private static int getId(long dp) {
        return (int)(dp & Integer.MAX_VALUE);
    }

    private static int getHeight(long dp) {
        return (int)(dp >>> 32 & 0xFFFL);
    }

    private static int getMinHeight(long dp) {
        return (int)(dp >>> 44 & 0xFFFL);
    }

    private static int getSkyLight(long dp) {
        return (int)(dp >>> 56 & 0xFL);
    }

    private static int getBlockLight(long dp) {
        return (int)(dp >>> 60 & 0xFL);
    }

    private void readColumnData(int X, int Z, InputStream in, WorkCTX ctx, long[] mapping) throws IOException {
        ctx.cache.reset();
        DataInputStream stream = new DataInputStream((InputStream)new XZInputStream(IOUtils.toBufferedInputStream((InputStream)in), -1, false, (ArrayCache)ctx.cache));
        long[] storage = ctx.storageCache;
        VoxelizedSection section = ctx.section;
        byte[] col = ctx.colScratch;
        for (int x = 0; x < 64; ++x) {
            for (int z = 0; z < 64; ++z) {
                int bPos = Integer.expand(x & 0xF, 15) | Integer.expand(z, 12528);
                int cl = stream.readShort();
                if (cl < 0) {
                    throw new IllegalStateException();
                }
                stream.read(col, 0, cl * 8);
                for (int j = 0; j < cl; ++j) {
                    long entry = LONG.get(col, j * 8);
                    long mEntry = Mapper.withLight(mapping[DHImporter.getId(entry)], DHImporter.getBlockLight(entry) << 4 | DHImporter.getSkyLight(entry));
                    int startY = DHImporter.getMinHeight(entry);
                    int tall = DHImporter.getHeight(entry);
                    int endY = Math.min(startY + tall, this.worldHeightSections * 16);
                    startY = Integer.expand(startY, 4181760);
                    endY = Integer.expand(endY, 4181760);
                    int Msk = 4181760;
                    int iMsk1 = -4181760;
                    int y = startY;
                    while (y != endY) {
                        storage[y + bPos] = mEntry;
                        y = y + -4181760 & 0x3FCF00;
                    }
                }
            }
            if ((x + 1) % 16 != 0) continue;
            for (int sz = 0; sz < 4; ++sz) {
                for (int sy = 0; sy < this.worldHeightSections; ++sy) {
                    int base = (sz | sy << 2) << 12;
                    int nonAirCount = 0;
                    long[] dat = section.section;
                    for (int i = 0; i < 4096; ++i) {
                        dat[i] = storage[i + base];
                        nonAirCount += Mapper.isAir(dat[i]) ? 0 : 1;
                    }
                    section.lvl0NonAirCount = nonAirCount;
                    WorldConversionFactory.mipSection(section, this.engine.getMapper());
                    section.setPosition(X * 4 + (x >> 4), sy + (this.bottomOfWorld >> 4), Z * 4 + sz);
                    WorldUpdater.insertUpdate(this.engine, section);
                }
                int count = this.processedChunks.incrementAndGet();
                this.updateCallback.onUpdate(count, this.totalChunks);
            }
            Arrays.fill(storage, 0L);
        }
        stream.close();
    }

    private void importSection(PreparedStatement dataFetchStmt, WorkCTX ctx, Task task) {
        if (!this.isRunning) {
            return;
        }
        try {
            dataFetchStmt.setInt(1, task.x);
            dataFetchStmt.setInt(2, task.z);
            try (ResultSet rs = dataFetchStmt.executeQuery();){
                long[] mapping = this.readMappings(rs.getBinaryStream(3), ctx);
                this.readColumnData(task.x, task.z, rs.getBinaryStream(1), ctx, mapping);
            }
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void shutdown() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        while (!this.tasks.isEmpty()) {
            this.tasks.poll();
        }
        try {
            if (this.runner != Thread.currentThread()) {
                this.runner.join();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.service.shutdown();
        this.engine.releaseRef();
        try {
            this.db.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.updateCallback = null;
        this.runner = null;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public WorldEngine getEngine() {
        return this.engine;
    }

    private static VarHandle create(Class<?> viewArrayClass) {
        return MethodHandles.byteArrayViewVarHandle(viewArrayClass, ByteOrder.BIG_ENDIAN);
    }

    static {
        LONG = DHImporter.create(long[].class);
        boolean hasJDBC = false;
        try {
            Class.forName("org.sqlite.JDBC");
            Class.forName("org.tukaani.xz.XZInputStream");
            hasJDBC = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            Logger.warn("Unable to load sqlite JDBC or lzma decompressor, DHImporting wont be available", e);
        }
        HasRequiredLibraries = hasJDBC;
    }

    private record WorkCTX(PreparedStatement stmt, ResettableArrayCache cache, long[] storageCache, byte[] colScratch, VoxelizedSection section) {
        public WorkCTX(PreparedStatement stmt, int worldHeight) {
            this(stmt, new ResettableArrayCache((ArrayCache)new BasicArrayCache()), new long[1024 * worldHeight], new byte[65536], VoxelizedSection.createEmpty());
        }
    }

    private record Task(int x, int z, int fmt, int compression) {
        public long distanceFromZero() {
            return (long)this.x * (long)this.x + (long)this.z * (long)this.z;
        }
    }
}

