/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.voxy.commonImpl.importers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import me.cortex.voxy.common.Logger;
import me.cortex.voxy.common.thread.Service;
import me.cortex.voxy.common.thread.ServiceManager;
import me.cortex.voxy.common.util.MemoryBuffer;
import me.cortex.voxy.common.util.Pair;
import me.cortex.voxy.common.util.UnsafeUtil;
import me.cortex.voxy.common.voxelization.VoxelizedSection;
import me.cortex.voxy.common.voxelization.WorldConversionFactory;
import me.cortex.voxy.common.world.WorldEngine;
import me.cortex.voxy.common.world.WorldUpdater;
import me.cortex.voxy.commonImpl.importers.IDataImporter;
import net.minecraft.class_11897;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2804;
import net.minecraft.class_2806;
import net.minecraft.class_2841;
import net.minecraft.class_4486;
import net.minecraft.class_5455;
import net.minecraft.class_6563;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7924;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.lwjgl.system.MemoryUtil;

public class WorldImporter
implements IDataImporter {
    private final WorldEngine world;
    private final class_7522<class_6880<class_1959>> defaultBiomeProvider;
    private final Codec<class_7522<class_6880<class_1959>>> biomeCodec;
    private final Codec<class_2841<class_2680>> blockStateCodec;
    private final AtomicInteger estimatedTotalChunks = new AtomicInteger();
    private final AtomicInteger totalChunks = new AtomicInteger();
    private final AtomicInteger chunksProcessed = new AtomicInteger();
    private final ConcurrentLinkedDeque<Runnable> jobQueue = new ConcurrentLinkedDeque();
    private final Service service;
    private volatile boolean isRunning;
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private volatile Thread worker;
    private IDataImporter.IUpdateCallback updateCallback;
    private IDataImporter.ICompletionCallback completionCallback;
    private static final byte[] EMPTY = new byte[0];
    private static final ThreadLocal<VoxelizedSection> SECTION_CACHE = ThreadLocal.withInitial(VoxelizedSection::createEmpty);

    public WorldImporter(WorldEngine worldEngine, class_1937 mcWorld, ServiceManager sm, BooleanSupplier runChecker) {
        this.world = worldEngine;
        this.service = sm.createService(() -> new Pair<Runnable, Runnable>(() -> this.jobQueue.poll().run(), () -> {}), 3L, "World importer", runChecker);
        class_2378 biomeRegistry = mcWorld.method_30349().method_30530(class_7924.field_41236);
        final class_6880.class_6883 defaultBiome = biomeRegistry.method_46747(class_1972.field_9451);
        this.defaultBiomeProvider = new class_7522<class_6880<class_1959>>(this){

            public class_6880<class_1959> get(int x, int y, int z) {
                return defaultBiome;
            }

            public void method_39793(Consumer<class_6880<class_1959>> action) {
            }

            public void method_12325(class_2540 buf) {
            }

            public int method_12327() {
                return 0;
            }

            public int method_74157() {
                return 0;
            }

            public boolean method_19526(Predicate<class_6880<class_1959>> predicate) {
                return false;
            }

            public void method_21732(class_2841.class_4464<class_6880<class_1959>> counter) {
            }

            public class_2841<class_6880<class_1959>> method_39957() {
                return null;
            }

            public class_2841<class_6880<class_1959>> method_44350() {
                return null;
            }

            public class_7522.class_6562<class_6880<class_1959>> method_44345(class_6563<class_6880<class_1959>> provider) {
                return null;
            }
        };
        class_11897 factory = class_11897.method_74159((class_5455)mcWorld.method_30349());
        this.biomeCodec = factory.comp_4790();
        this.blockStateCodec = factory.comp_4787();
    }

    @Override
    public void runImport(IDataImporter.IUpdateCallback updateCallback, IDataImporter.ICompletionCallback completionCallback) {
        if (this.isRunning) {
            throw new IllegalStateException();
        }
        if (this.worker == null) {
            completionCallback.onCompletion(0);
            return;
        }
        this.isRunning = true;
        this.world.acquireRef();
        this.updateCallback = updateCallback;
        this.completionCallback = completionCallback;
        this.worker.start();
    }

    @Override
    public WorldEngine getEngine() {
        return this.world;
    }

    @Override
    public void shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return;
        }
        this.isRunning = false;
        if (this.worker != null) {
            try {
                this.worker.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.service.isLive()) {
            this.world.releaseRef();
            this.service.shutdown();
        }
        while (!this.jobQueue.isEmpty()) {
            this.jobQueue.poll().run();
        }
    }

    public void importRegionDirectoryAsync(File directory) {
        File[] files = directory.listFiles((dir, name) -> {
            String[] sections = name.split("\\.");
            if (sections.length != 4 || !sections[0].equals("r") || !sections[3].equals("mca")) {
                Logger.error("Unknown file: " + name);
                return false;
            }
            return true;
        });
        if (files == null) {
            return;
        }
        Arrays.sort(files, File::compareTo);
        this.importRegionsAsync(files, this::importRegionFile);
    }

    public void importZippedRegionDirectoryAsync(File zip, String innerDirectory) {
        try {
            innerDirectory = innerDirectory.replace("\\\\", "\\").replace("\\", "/");
            ZipFile file = ((ZipFile.Builder)ZipFile.builder().setFile(zip)).get();
            ArrayList<ZipArchiveEntry> regions = new ArrayList<ZipArchiveEntry>();
            Enumeration e = file.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry entry2 = (ZipArchiveEntry)e.nextElement();
                if (entry2.isDirectory() || !entry2.getName().startsWith(innerDirectory)) continue;
                String[] parts = entry2.getName().split("/");
                String name = parts[parts.length - 1];
                String[] sections = name.split("\\.");
                if (sections.length != 4 || !sections[0].equals("r") || !sections[3].equals("mca")) {
                    Logger.error("Unknown file: " + name);
                    continue;
                }
                regions.add(entry2);
            }
            this.importRegionsAsync((ZipArchiveEntry[])regions.toArray(ZipArchiveEntry[]::new), entry -> {
                if (entry.getSize() == 0L) {
                    return;
                }
                MemoryBuffer buf = new MemoryBuffer(entry.getSize());
                try (ReadableByteChannel channel = Channels.newChannel(file.getInputStream(entry));){
                    if ((long)channel.read(buf.asByteBuffer()) != buf.size) {
                        buf.free();
                        throw new IllegalStateException("Could not read full zip entry");
                    }
                }
                String[] parts = entry.getName().split("/");
                String name = parts[parts.length - 1];
                String[] sections = name.split("\\.");
                try {
                    this.importRegion(buf, Integer.parseInt(sections[1]), Integer.parseInt(sections[2]));
                }
                catch (NumberFormatException e) {
                    Logger.error("Invalid format for region position, x: \"" + sections[1] + "\" z: \"" + sections[2] + "\" skipping region");
                }
                buf.free();
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void importRegionsAsync(T[] regionFiles, IImporterMethod<T> importer) {
        this.totalChunks.set(0);
        this.estimatedTotalChunks.set(0);
        this.chunksProcessed.set(0);
        this.worker = new Thread(() -> {
            this.estimatedTotalChunks.addAndGet(regionFiles.length * 1024);
            for (Object file : regionFiles) {
                this.estimatedTotalChunks.addAndGet(-1024);
                try {
                    importer.importRegion(file);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                while (this.totalChunks.get() - this.chunksProcessed.get() > 10000 && this.isRunning) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.isRunning) continue;
                this.service.blockTillEmpty();
                this.completionCallback.onCompletion(this.totalChunks.get());
                this.worker = null;
                return;
            }
            this.service.blockTillEmpty();
            while (this.chunksProcessed.get() != this.totalChunks.get() && this.isRunning) {
                Thread.yield();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.isShutdown.getAndSet(true)) {
                this.worker = null;
                this.service.shutdown();
                this.world.releaseRef();
            }
            this.completionCallback.onCompletion(this.totalChunks.get());
        });
        this.worker.setName("World importer");
    }

    public boolean isBusy() {
        return this.isRunning || this.worker != null;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning || this.worker != null && this.worker.isAlive();
    }

    private void importRegionFile(File file) throws IOException {
        String name = file.getName();
        String[] sections = name.split("\\.");
        if (sections.length != 4 || !sections[0].equals("r") || !sections[3].equals("mca")) {
            Logger.error("Unknown file: " + name);
            throw new IllegalStateException();
        }
        int rx = 0;
        int rz = 0;
        try {
            rx = Integer.parseInt(sections[1]);
            rz = Integer.parseInt(sections[2]);
        }
        catch (NumberFormatException e) {
            Logger.error("Invalid format for region position, x: \"" + sections[1] + "\" z: \"" + sections[2] + "\" skipping region");
            return;
        }
        try (FileChannel fileStream = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            if (fileStream.size() == 0L) {
                return;
            }
            MemoryBuffer fileData = new MemoryBuffer(fileStream.size());
            if (fileStream.read(fileData.asByteBuffer(), 0L) < 8192) {
                fileData.free();
                Logger.warn("Header of region file invalid");
                return;
            }
            this.importRegion(fileData, rx, rz);
            fileData.free();
        }
    }

    private void importRegion(MemoryBuffer regionFile, int x, int z) {
        if (regionFile.size < 8192L) {
            Logger.warn("Header of region file invalid");
            return;
        }
        for (int idx = 0; idx < 1024; ++idx) {
            int sectorMeta = Integer.reverseBytes(MemoryUtil.memGetInt((long)(regionFile.address + (long)(idx * 4))));
            if (sectorMeta == 0) continue;
            int sectorStart = sectorMeta >>> 8;
            int sectorCount = sectorMeta & 0xFF;
            if (sectorCount == 0) continue;
            if (regionFile.size < (long)(sectorCount - 1 + sectorStart) * 4096L) {
                Logger.warn("Cannot access chunk sector as it goes out of bounds. start bytes: " + sectorStart * 4096 + " sector count: " + sectorCount + " fileSize: " + regionFile.size);
                continue;
            }
            long base = regionFile.address + (long)sectorStart * 4096L;
            int chunkLen = sectorCount * 4096;
            int m = Integer.reverseBytes(MemoryUtil.memGetInt((long)base));
            byte b = MemoryUtil.memGetByte((long)(base + 4L));
            if (m == 0) {
                Logger.error("Chunk is allocated, but stream is missing");
                continue;
            }
            int n = m - 1;
            if (regionFile.size < (long)n + (long)sectorStart * 4096L) {
                Logger.warn("Chunk stream to small");
                continue;
            }
            if ((b & 0x80) != 0) {
                if (n != 0) {
                    Logger.error("Chunk has both internal and external streams");
                }
                Logger.error("Chunk has external stream which is not supported");
                continue;
            }
            if (n > chunkLen - 5) {
                Logger.error("Chunk stream is truncated: expected " + n + " but read " + (chunkLen - 5));
                continue;
            }
            if (n < 0) {
                Logger.error("Declared size of chunk is negative");
                continue;
            }
            MemoryBuffer data = new MemoryBuffer(n).cpyFrom(base + 5L);
            this.jobQueue.add(() -> {
                if (!this.isRunning) {
                    data.free();
                    return;
                }
                try (DataInputStream decompressedData = this.decompress(b, data);){
                    if (decompressedData == null) {
                        Logger.error("Error decompressing chunk data");
                    } else {
                        class_2487 nbt = class_2507.method_10627((DataInput)decompressedData);
                        this.importChunkNBT(nbt, x, z);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    data.free();
                }
            });
            this.totalChunks.incrementAndGet();
            this.estimatedTotalChunks.incrementAndGet();
            this.service.execute();
        }
    }

    private static InputStream createInputStream(final MemoryBuffer data) {
        return new InputStream(){
            private long offset = 0L;

            @Override
            public int read() {
                return MemoryUtil.memGetByte((long)(data.address + this.offset++)) & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                if ((len = Math.min(len, this.available())) == 0) {
                    return -1;
                }
                UnsafeUtil.memcpy(data.address + this.offset, len, b, off);
                this.offset += (long)len;
                return len;
            }

            @Override
            public int available() {
                return (int)(data.size - this.offset);
            }
        };
    }

    private DataInputStream decompress(byte flags, MemoryBuffer stream) throws IOException {
        class_4486 chunkStreamVersion = class_4486.method_21883((int)flags);
        if (chunkStreamVersion == null) {
            Logger.error("Chunk has invalid chunk stream version");
            return null;
        }
        return new DataInputStream(chunkStreamVersion.method_21885(WorldImporter.createInputStream(stream)));
    }

    private void importChunkNBT(class_2487 chunk, int regionX, int regionZ) {
        if (!chunk.method_10545("Status")) {
            this.totalChunks.decrementAndGet();
            return;
        }
        class_2806 status = class_2806.method_12168((String)chunk.method_68564("Status", null));
        if (status != class_2806.field_12803 && status != class_2806.field_12798) {
            this.totalChunks.decrementAndGet();
            return;
        }
        try {
            int x = chunk.method_68083("xPos", Integer.MIN_VALUE);
            int z = chunk.method_68083("zPos", Integer.MIN_VALUE);
            if (x >> 5 != regionX || z >> 5 != regionZ) {
                Logger.error("Chunk position is not located in correct region, expected: (" + regionX + ", " + regionZ + "), got: (" + (x >> 5) + ", " + (z >> 5) + "), importing anyway");
            }
            for (class_2520 sectionE : (class_2499)chunk.method_10554("sections").orElseThrow()) {
                class_2487 section = (class_2487)sectionE;
                int y = section.method_68083("Y", Integer.MIN_VALUE);
                this.importSectionNBT(x, y, z, section);
            }
        }
        catch (Exception e) {
            Logger.error("Exception importing world chunk:", e);
        }
        this.updateCallback.onUpdate(this.chunksProcessed.incrementAndGet(), this.estimatedTotalChunks.get());
    }

    private void importSectionNBT(int x, int y, int z, class_2487 section) {
        if (section.method_10562("block_states").isEmpty()) {
            return;
        }
        byte[] blockLightData = section.method_10547("BlockLight").orElse(EMPTY);
        byte[] skyLightData = section.method_10547("SkyLight").orElse(EMPTY);
        class_2804 blockLight = blockLightData.length != 0 ? new class_2804(blockLightData) : null;
        class_2804 skyLight = skyLightData.length != 0 ? new class_2804(skyLightData) : null;
        DataResult blockStatesRes = this.blockStateCodec.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)section.method_10562("block_states").get()));
        if (!blockStatesRes.hasResultOrPartial()) {
            return;
        }
        class_2841 blockStates = (class_2841)blockStatesRes.getPartialOrThrow();
        class_7522<class_6880<class_1959>> biomes = this.defaultBiomeProvider;
        Optional optBiomes = section.method_10562("biomes");
        if (optBiomes.isPresent()) {
            biomes = this.biomeCodec.parse((DynamicOps)class_2509.field_11560, (Object)((class_2520)optBiomes.get())).result().orElse(this.defaultBiomeProvider);
        }
        VoxelizedSection csec = WorldConversionFactory.convert(SECTION_CACHE.get().setPosition(x, y, z), this.world.getMapper(), (class_2841<class_2680>)blockStates, biomes, (bx, by, bz) -> {
            int block = 0;
            int sky = 0;
            if (blockLight != null) {
                block = blockLight.method_12139(bx, by, bz);
            }
            if (skyLight != null) {
                sky = skyLight.method_12139(bx, by, bz);
            }
            return (byte)(sky | block << 4);
        });
        WorldConversionFactory.mipSection(csec, this.world.getMapper());
        WorldUpdater.insertUpdate(this.world, csec);
    }

    private static interface IImporterMethod<T> {
        public void importRegion(T var1) throws Exception;
    }
}

