/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.event;

import io.github.sycamore0.myluckyblock.block.LuckyBlock;
import io.github.sycamore0.myluckyblock.utils.LuckyEventDataManager;
import io.github.sycamore0.myluckyblock.utils.LuckyEventExecutor;
import io.github.sycamore0.myluckyblock.utils.RandomEventReader;
import io.github.sycamore0.myluckyblock.utils.helper.EnchantmentsHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BreakLuckyBlock {
    public static LuckyEventDataManager manager = new LuckyEventDataManager();

    public static void breakLuckyBlock(Level level, @Nullable Player player, BlockPos pos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block block = state.getBlock();
            if (block instanceof LuckyBlock) {
                RandomEventReader event;
                boolean hasSilkTouch;
                LuckyBlock luckyBlock = (LuckyBlock)block;
                if (player != null && (hasSilkTouch = EnchantmentsHelper.checkSilkTouch(player))) {
                    BreakLuckyBlock.dropSelf(serverLevel, pos, luckyBlock);
                    return;
                }
                String eventPackId = luckyBlock.getEventPackId();
                boolean includeBuiltIn = luckyBlock.includeBuiltIn();
                if (!manager.isLoaded(eventPackId)) {
                    manager.loadEvents(eventPackId, includeBuiltIn);
                }
                if ((event = manager.getRandomEvent(eventPackId)) != null) {
                    LuckyEventExecutor.executeLuckyFunction(serverLevel, player, pos, event);
                }
            }
        }
    }

    private static void dropSelf(ServerLevel serverLevel, BlockPos pos, LuckyBlock luckyBlock) {
        serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, pos.getCenter().x, (double)pos.getY(), pos.getCenter().z, new ItemStack((ItemLike)luckyBlock)));
    }
}

