/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.event;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.sycamore0.myluckyblock.CommonClass;
import io.github.sycamore0.myluckyblock.Constants;
import io.github.sycamore0.myluckyblock.block.LuckyBlock;
import io.github.sycamore0.myluckyblock.event.BreakLuckyBlock;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

public class ModEventHandlers {
    @SubscribeEvent
    private static void onDestroyedByPlayer(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        BlockPos blockPos = event.getPos();
        BlockState blockState = event.getState();
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (blockState.getBlock() instanceof LuckyBlock) {
                serverLevel.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                BreakLuckyBlock.breakLuckyBlock((Level)serverLevel, player, blockPos, blockState);
                event.setCanceled(true);
                ItemStack tool = player.getMainHandItem();
                if (tool.isDamageableItem()) {
                    int damage = blockState.getDestroySpeed((BlockGetter)serverLevel, blockPos) > 0.0f ? 1 : 0;
                    tool.hurtAndBreak(damage, (LivingEntity)player, player.getEquipmentSlotForItem(tool));
                }
                player.awardStat(Stats.BLOCK_MINED.get((Object)blockState.getBlock()));
            }
        }
    }

    @SubscribeEvent
    private static void onAddReloadListeners(AddServerReloadListenersEvent event) {
        event.addListener(ResourceLocation.parse((String)"lucky_loader"), (PreparableReloadListener)new LuckyEventsReloadListener());
    }

    private static void loadEventsPack(ResourceManager manager, String eventPackId) {
        String jsonDir = "lucky/events/" + eventPackId;
        ArrayList events = new ArrayList();
        manager.listResources(jsonDir, path -> path.getPath().endsWith(".json")).forEach((id, resource) -> {
            try (InputStreamReader reader = new InputStreamReader(resource.open());){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                json.addProperty("fileName", id.getPath());
                events.add(json);
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to load {}", id, (Object)e);
            }
        });
        Constants.loadedEventPacks.put(eventPackId, events);
    }

    private static class LuckyEventsReloadListener
    implements ResourceManagerReloadListener {
        private LuckyEventsReloadListener() {
        }

        public void onResourceManagerReload(@NotNull ResourceManager manager) {
            Constants.loadedEventPacks.clear();
            for (String eventPackId : Constants.eventPackIdList) {
                ModEventHandlers.loadEventsPack(manager, eventPackId);
            }
            Constants.LOG.info("Loaded {} event files for mod {}", (Object)CommonClass.getLoadedEvents("myluckyblock").size(), (Object)"myluckyblock");
        }
    }
}

