/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.utils.helper;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class EnchantmentsHelper {
    public static int getEnchantmentLevel(ItemStack stack, ResourceKey<Enchantment> enchantment) {
        ItemEnchantments enchants = stack.getEnchantments();
        if (enchants.equals((Object)ItemEnchantments.EMPTY)) {
            return -1;
        }
        Set enchantList = enchants.keySet();
        for (Holder entry : enchantList) {
            if (!entry.is(enchantment)) continue;
            return enchants.getLevel(entry);
        }
        return -1;
    }

    public static boolean checkSilkTouch(Player player) {
        ItemStack mainHandStack = player.getMainHandItem();
        if (!mainHandStack.isEmpty() && mainHandStack.isEnchanted()) {
            return EnchantmentsHelper.getEnchantmentLevel(mainHandStack, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH) > 0;
        }
        return false;
    }
}

