/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.utils.helper;

import io.github.sycamore0.myluckyblock.Constants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.jetbrains.annotations.Nullable;

public class NbtHelper {
    public static CompoundTag generateNbt(@Nullable String nbtStr) {
        try {
            if (nbtStr != null) {
                CompoundTag nbt = TagParser.parseCompoundFully((String)nbtStr);
                if (nbt instanceof CompoundTag) {
                    return nbt;
                }
                throw new IllegalArgumentException("Parsed NBT data is not a compound tag");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse NBT data: " + e.getMessage(), e);
        }
        return null;
    }

    public static CompoundTag generateItemNbt(String itemId, int count, @Nullable String itemNbtStr) {
        if (itemNbtStr != null) {
            String nbtStr = "{Item:{id:\"" + itemId + "\",count:" + count + ",components:{" + itemNbtStr + "}}}";
            return NbtHelper.generateNbt(nbtStr);
        }
        return null;
    }

    public static ValueInput generateNewNbt(@Nullable String nbtStr, ServerLevel serverLevel) {
        try {
            CompoundTag oldNbt = NbtHelper.generateNbt(nbtStr);
            if (oldNbt != null) {
                return TagValueInput.create((ProblemReporter)Constants.problemreporter$scopedcollector, (HolderLookup.Provider)serverLevel.registryAccess(), (CompoundTag)oldNbt);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static ValueInput generateNewItemNbt(String itemId, int count, @Nullable String itemNbtStr, ServerLevel serverLevel) {
        try {
            CompoundTag oldNbt = NbtHelper.generateItemNbt(itemId, count, itemNbtStr);
            if (oldNbt != null) {
                return TagValueInput.create((ProblemReporter)Constants.problemreporter$scopedcollector, (HolderLookup.Provider)serverLevel.registryAccess(), (CompoundTag)oldNbt);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

