/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.utils.helper;

import io.github.sycamore0.myluckyblock.Constants;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionHelper {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:-([a-zA-Z0-9.-]+))?(?:\\+([a-zA-Z0-9.-]+))?$");
    private static final Pattern RANGE_PATTERN = Pattern.compile("^(\\[|\\()([^,]+),([^\\]\\)]+)(\\]|\\))$");

    public static boolean isVersionInRange(String versionStr, String rangeStr) {
        if ("*".equals(rangeStr)) {
            return true;
        }
        try {
            Version version = VersionHelper.parseVersion(versionStr);
            VersionRange range = VersionHelper.parseVersionRange(rangeStr);
            return range.contains(version);
        }
        catch (IllegalArgumentException e) {
            Constants.LOG.error("Failed to parse: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static Version parseVersion(String versionStr) {
        if (((String)versionStr).matches("^\\d+$")) {
            versionStr = (String)versionStr + ".0.0";
        } else if (((String)versionStr).matches("^\\d+\\.\\d+$")) {
            versionStr = (String)versionStr + ".0";
        }
        Matcher matcher = VERSION_PATTERN.matcher((CharSequence)versionStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Version String: " + (String)versionStr);
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        String preRelease = matcher.group(4);
        String build = matcher.group(5);
        return new Version(major, minor, patch, preRelease, build);
    }

    private static VersionRange parseVersionRange(String rangeStr) {
        Matcher matcher = RANGE_PATTERN.matcher(rangeStr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Version Range String: " + rangeStr);
        }
        String minInclusiveStr = matcher.group(1);
        String minVersionStr = matcher.group(2).trim();
        String maxVersionStr = matcher.group(3).trim();
        String maxInclusiveStr = matcher.group(4);
        boolean minInclusive = minInclusiveStr.equals("[");
        boolean maxInclusive = maxInclusiveStr.equals("]");
        Version minVersion = VersionHelper.parseVersion(minVersionStr);
        Version maxVersion = VersionHelper.parseVersion(maxVersionStr);
        return new VersionRange(minVersion, minInclusive, maxVersion, maxInclusive);
    }

    private static class Version
    implements Comparable<Version> {
        private final int major;
        private final int minor;
        private final int patch;
        private final String preRelease;
        private final String build;

        public Version(int major, int minor, int patch, String preRelease, String build) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.preRelease = preRelease;
            this.build = build;
        }

        @Override
        public int compareTo(Version other) {
            int buildCompare;
            int preReleaseCompare;
            if (this.major != other.major) {
                return Integer.compare(this.major, other.major);
            }
            if (this.minor != other.minor) {
                return Integer.compare(this.minor, other.minor);
            }
            if (this.patch != other.patch) {
                return Integer.compare(this.patch, other.patch);
            }
            if (this.preRelease == null && other.preRelease != null) {
                return 1;
            }
            if (this.preRelease != null && other.preRelease == null) {
                return -1;
            }
            if (this.preRelease != null && other.preRelease != null && (preReleaseCompare = this.comparePreRelease(this.preRelease, other.preRelease)) != 0) {
                return preReleaseCompare;
            }
            if (this.build == null && other.build != null) {
                return -1;
            }
            if (this.build != null && other.build == null) {
                return 1;
            }
            if (this.build != null && other.build != null && (buildCompare = this.build.compareTo(other.build)) != 0) {
                return buildCompare;
            }
            return 0;
        }

        private int comparePreRelease(String preRelease1, String preRelease2) {
            String[] parts1 = preRelease1.split("\\.");
            String[] parts2 = preRelease2.split("\\.");
            int minLength = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < minLength; ++i) {
                String part1 = parts1[i];
                String part2 = parts2[i];
                boolean isNumeric1 = part1.matches("\\d+");
                boolean isNumeric2 = part2.matches("\\d+");
                if (isNumeric1 && isNumeric2) {
                    int num2;
                    int num1 = Integer.parseInt(part1);
                    if (num1 == (num2 = Integer.parseInt(part2))) continue;
                    return Integer.compare(num1, num2);
                }
                if (isNumeric1) {
                    return -1;
                }
                if (isNumeric2) {
                    return 1;
                }
                int cmp = part1.compareTo(part2);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(parts1.length, parts2.length);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.major).append(".").append(this.minor).append(".").append(this.patch);
            if (this.preRelease != null) {
                sb.append("-").append(this.preRelease);
            }
            if (this.build != null) {
                sb.append("+").append(this.build);
            }
            return sb.toString();
        }
    }

    private static class VersionRange {
        private final Version minVersion;
        private final boolean minInclusive;
        private final Version maxVersion;
        private final boolean maxInclusive;

        public VersionRange(Version minVersion, boolean minInclusive, Version maxVersion, boolean maxInclusive) {
            this.minVersion = minVersion;
            this.minInclusive = minInclusive;
            this.maxVersion = maxVersion;
            this.maxInclusive = maxInclusive;
        }

        public boolean contains(Version version) {
            boolean minOk;
            int minCompare = version.compareTo(this.minVersion);
            int maxCompare = version.compareTo(this.maxVersion);
            boolean bl = this.minInclusive ? minCompare >= 0 : (minOk = minCompare > 0);
            boolean maxOk = this.maxInclusive ? maxCompare <= 0 : maxCompare < 0;
            return minOk && maxOk;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.minInclusive ? "[" : "(");
            sb.append(this.minVersion).append(",").append(this.maxVersion);
            sb.append(this.maxInclusive ? "]" : ")");
            return sb.toString();
        }
    }
}

