/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.utils;

import com.google.gson.JsonObject;
import io.github.sycamore0.myluckyblock.CommonClass;
import io.github.sycamore0.myluckyblock.Constants;
import io.github.sycamore0.myluckyblock.platform.Services;
import io.github.sycamore0.myluckyblock.utils.DependenciesDataReader;
import io.github.sycamore0.myluckyblock.utils.EventDataReader;
import io.github.sycamore0.myluckyblock.utils.ModJsonUtil;
import io.github.sycamore0.myluckyblock.utils.RandomEventReader;
import io.github.sycamore0.myluckyblock.utils.helper.VersionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class LuckyEventDataManager {
    private final Map<String, List<RandomEventReader>> eventsByMod = new HashMap<String, List<RandomEventReader>>();

    public void loadEvents(String eventPackId, boolean includeBuiltIn) {
        List<JsonObject> modEvents = CommonClass.getLoadedEvents(eventPackId);
        ArrayList<JsonObject> targetEvents = new ArrayList<JsonObject>(modEvents);
        if (includeBuiltIn && !eventPackId.equals("myluckyblock")) {
            List<JsonObject> mainEvents = CommonClass.getLoadedEvents("myluckyblock");
            targetEvents.addAll(mainEvents);
        }
        ArrayList<RandomEventReader> modEventList = new ArrayList<RandomEventReader>();
        int currentId = 1;
        for (JsonObject json : targetEvents) {
            try {
                EventDataReader data = ModJsonUtil.loadJsonData(json);
                if (data == null) {
                    Constants.LOG.error("Failed to parse JSON file: {}", (Object)json.get("fileName").getAsString());
                    continue;
                }
                Constants.LOG.info("Loading {} (v{})", (Object)data.getName(), (Object)data.getVersion());
                boolean allDependenciesLoaded = this.checkDependencies(data);
                if (allDependenciesLoaded) {
                    for (RandomEventReader event : data.getRandomEvents()) {
                        event.setId(currentId++);
                        modEventList.add(event);
                        if (event.getId() > 0) continue;
                        Constants.LOG.warn("Invalid event ID in {}: {}", (Object)json.get("fileName"), (Object)event.getId());
                    }
                    Constants.LOG.info("Loaded {} events from {}", (Object)data.getRandomEvents().size(), (Object)json.get("fileName").getAsString());
                    continue;
                }
                Constants.LOG.warn("Skipping {} because not all dependencies are loaded", (Object)json.get("fileName").getAsString());
            }
            catch (Exception e) {
                Constants.LOG.error("Critical error loading {}: {}", (Object)json.get("fileName").getAsString(), (Object)e.getMessage());
            }
        }
        this.eventsByMod.put(eventPackId, modEventList);
        Constants.LOG.info("Successfully loaded {} random events for mod {}", (Object)modEventList.size(), (Object)eventPackId);
    }

    public boolean isLoaded(String eventPackId) {
        return this.eventsByMod.containsKey(eventPackId);
    }

    public RandomEventReader getRandomEvent(String eventPackId) {
        List<RandomEventReader> events = this.eventsByMod.get(eventPackId);
        if (events == null || events.isEmpty()) {
            return null;
        }
        return events.get(new Random().nextInt(events.size()));
    }

    private boolean checkDependencies(EventDataReader data) {
        List<DependenciesDataReader> dependencies = data.getDependencies();
        if (dependencies == null) {
            return true;
        }
        for (DependenciesDataReader dependency : dependencies) {
            String currentDependencyVersion;
            if (dependency.getModId() == null) {
                return true;
            }
            if (!CommonClass.checkModLoaded(dependency.getModId())) {
                Constants.LOG.warn("Dependency {} is not loaded", (Object)dependency.getModId());
                return false;
            }
            String versionRange = dependency.getVersionRange();
            if (versionRange == null) {
                return true;
            }
            try {
                currentDependencyVersion = Services.PLATFORM.getModVersion(dependency.getModId());
            }
            catch (Exception e) {
                Constants.LOG.error("Failed to get version for dependency {}", (Object)dependency.getModId(), (Object)e);
                return false;
            }
            if (currentDependencyVersion == null) {
                return false;
            }
            if (VersionHelper.isVersionInRange(currentDependencyVersion, versionRange)) continue;
            Constants.LOG.warn("Dependency {} version {} is not in range {}", new Object[]{dependency.getModId(), currentDependencyVersion, versionRange});
            return false;
        }
        return true;
    }

    public int getRandomEventsCount(String eventPackId) {
        return ((List)this.eventsByMod.getOrDefault(eventPackId, new ArrayList())).size();
    }

    public RandomEventReader getEventById(String eventPackId, int id) {
        for (RandomEventReader event : (List)this.eventsByMod.getOrDefault(eventPackId, new ArrayList())) {
            if (event.getId() != id) continue;
            return event;
        }
        return null;
    }
}

