/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.utils;

import io.github.sycamore0.myluckyblock.utils.LuckyEventFunctions;
import io.github.sycamore0.myluckyblock.utils.PosSrc;
import io.github.sycamore0.myluckyblock.utils.RandomEventReader;
import io.github.sycamore0.myluckyblock.utils.helper.PosHelper;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class LuckyEventExecutor {
    public static void executeLuckyFunction(class_3218 serverLevel, @Nullable class_1657 player, class_2338 blockPos, RandomEventReader function) {
        if (function.hasDropItems()) {
            for (RandomEventReader.DropItem dropItem : function.getDropItems()) {
                int count;
                boolean isUseRandom = dropItem.isUseRandom();
                if (isUseRandom) {
                    int min = dropItem.getRandomNum().getMin();
                    int max = dropItem.getRandomNum().getMax();
                    count = LuckyEventExecutor.getRandomNumber(min, max);
                } else {
                    count = dropItem.getNum();
                }
                class_243 dropItemPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, dropItem.getOffset(), "DropItems");
                if (player != null && dropItem.getPosSrc() != PosSrc.BLOCK) {
                    dropItemPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.method_24515()), dropItem.getPosSrc(), dropItem.getOffset(), "DropItems");
                }
                LuckyEventFunctions.dropItems(serverLevel, dropItemPos, dropItem.getId(), count, dropItem.getName(), dropItem.isNameVisible(), dropItem.getDesc(), dropItem.getNbt());
            }
        }
        if (function.hasPlaceBlocks()) {
            for (RandomEventReader.PlaceBlock placeBlock : function.getPlaceBlocks()) {
                class_243 placeBlockPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, placeBlock.getOffset(), "PlaceBlocks");
                if (player != null && placeBlock.getPosSrc() != PosSrc.BLOCK) {
                    placeBlockPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.method_24515()), placeBlock.getPosSrc(), placeBlock.getOffset(), "PlaceBlocks");
                }
                LuckyEventFunctions.placeBlock(serverLevel, placeBlockPos, placeBlock.getId());
            }
        }
        if (function.hasPlaceChests()) {
            for (RandomEventReader.PlaceChest placeChest : function.getPlaceChests()) {
                class_5321 lootTable = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)placeChest.getId()));
                class_243 placeChestPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, placeChest.getOffset(), "PlaceChests");
                if (player != null && placeChest.getPosSrc() != PosSrc.BLOCK) {
                    placeChestPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.method_24515()), placeChest.getPosSrc(), placeChest.getOffset(), "PlaceChests");
                }
                LuckyEventFunctions.placeChest(serverLevel, PosHelper.parseVec3d(placeChestPos), placeChest.getChestId(), (class_5321<class_52>)lootTable);
            }
        }
        if (function.hasFallBlocks()) {
            for (RandomEventReader.FallBlock fallBlock : function.getFallBlocks()) {
                Optional blockIdOptional = class_7923.field_41175.method_10223(class_2960.method_60654((String)fallBlock.getId()));
                if (!blockIdOptional.isPresent()) continue;
                class_2248 blockId = (class_2248)((class_6880.class_6883)blockIdOptional.get()).comp_349();
                class_243 fallBlockPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, fallBlock.getOffset(), "FallBlocks");
                if (player != null && fallBlock.getPosSrc() != PosSrc.BLOCK) {
                    fallBlockPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.method_24515()), fallBlock.getPosSrc(), fallBlock.getOffset(), "FallBlocks");
                }
                LuckyEventFunctions.fallBlock(serverLevel, PosHelper.parseVec3d(fallBlockPos), blockId, fallBlock.getVelocity());
            }
        }
        if (function.hasGivePotionEffects()) {
            for (RandomEventReader.GivePotionEffect givePotionEffect : function.getGivePotionEffects()) {
                if (player == null) continue;
                class_6880.class_6883 effect = (class_6880.class_6883)class_7923.field_41174.method_10223(class_2960.method_60654((String)givePotionEffect.getId())).orElseThrow();
                LuckyEventFunctions.givePotionEffect(player, (class_6880<class_1291>)effect, givePotionEffect.getDuration(), givePotionEffect.getAmplifier());
            }
        }
        if (function.hasSpawnMobs()) {
            for (RandomEventReader.SpawnMob spawnMob : function.getSpawnMobs()) {
                Optional entityTypeOptional = class_7923.field_41177.method_10223(class_2960.method_60654((String)spawnMob.getId()));
                if (!entityTypeOptional.isPresent()) continue;
                class_1299 entityType = (class_1299)((class_6880.class_6883)entityTypeOptional.get()).comp_349();
                boolean isUseRandom = spawnMob.isUseRandom();
                int count = isUseRandom ? LuckyEventExecutor.getRandomNumber(spawnMob.getRandomNum().getMin(), spawnMob.getRandomNum().getMax()) : spawnMob.getNum();
                class_243 spawnMobPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, spawnMob.getOffset(), "SpawnMobs");
                if (player != null && spawnMob.getPosSrc() != PosSrc.BLOCK) {
                    spawnMobPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.method_24515()), spawnMob.getPosSrc(), spawnMob.getOffset(), "SpawnMobs");
                }
                String nbtString = spawnMob.getNbt();
                for (int i = 0; i < count; ++i) {
                    if (entityType == class_1299.field_6052) {
                        LuckyEventFunctions.dropItemsByNbt(serverLevel, spawnMobPos, spawnMob.getName(), spawnMob.isNameVisible(), spawnMob.getDesc(), nbtString);
                        continue;
                    }
                    if (nbtString != null) {
                        LuckyEventFunctions.spawnMob(serverLevel, spawnMobPos, entityType, spawnMob.getRandomize(), spawnMob.getName(), (boolean)spawnMob.isNameVisible(), spawnMob.getVelocity(), nbtString);
                        continue;
                    }
                    LuckyEventFunctions.spawnMob(serverLevel, spawnMobPos, entityType, spawnMob.getRandomize(), spawnMob.getName(), (boolean)spawnMob.isNameVisible(), spawnMob.isBaby(), spawnMob.getVelocity());
                }
            }
        }
        if (function.hasSendMessages()) {
            for (RandomEventReader.SendMessage sendMessage : function.getSendMessages()) {
                if (player == null) continue;
                LuckyEventFunctions.sendMessage(player, sendMessage.getMsg());
            }
        }
        if (function.hasDisplayMessages()) {
            for (RandomEventReader.DisplayMessage displayMessage : function.getDisplayMessages()) {
                if (player == null) continue;
                LuckyEventFunctions.displayClientMessage(player, displayMessage.getMsg(), displayMessage.getOverlay());
            }
        }
        if (function.hasCreateExplosions()) {
            for (RandomEventReader.CreateExplosion createExplosion : function.getCreateExplosions()) {
                class_243 createExplosionPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, createExplosion.getOffset(), "CreateExplosions");
                if (player != null && createExplosion.getPosSrc() != PosSrc.BLOCK) {
                    createExplosionPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.method_24515()), createExplosion.getPosSrc(), createExplosion.getOffset(), "CreateExplosions");
                }
                LuckyEventFunctions.createExplosion(serverLevel, createExplosionPos, createExplosion.getPower(), createExplosion.isCreateFire());
            }
        }
        if (function.hasAddParticles()) {
            for (RandomEventReader.AddParticle addParticle : function.getAddParticles()) {
                Optional particleTypeOptional = class_7923.field_41180.method_10223(class_2960.method_60654((String)addParticle.getId()));
                if (!particleTypeOptional.isPresent()) continue;
                class_2396 particleType = (class_2396)((class_6880.class_6883)particleTypeOptional.get()).comp_349();
                class_2394 particle = (class_2394)particleType;
                class_243 addParticlePos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, addParticle.getOffset(), "AddParticles");
                if (player != null && addParticle.getPosSrc() != PosSrc.BLOCK) {
                    addParticlePos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.method_24515()), addParticle.getPosSrc(), addParticle.getOffset(), "AddParticles");
                }
                LuckyEventFunctions.addParticles(serverLevel, particle, addParticlePos, addParticle.getCount(), addParticle.getVelocity().getX(), addParticle.getVelocity().getY(), addParticle.getVelocity().getZ(), addParticle.getSpeed());
            }
        }
        if (function.hasPlaySounds()) {
            for (RandomEventReader.PlaySound playSound : function.getPlaySounds()) {
                Optional soundEventOptional;
                if (player == null || !(soundEventOptional = class_7923.field_41172.method_10223(class_2960.method_60654((String)playSound.getId()))).isPresent()) continue;
                class_3414 soundEvent = (class_3414)((class_6880.class_6883)soundEventOptional.get()).comp_349();
                LuckyEventFunctions.playSound((class_1297)player, serverLevel, PosHelper.parseBlockPos(blockPos), soundEvent, playSound.getVolume(), playSound.getPitch());
            }
        }
        if (function.hasLoadStructures()) {
            for (RandomEventReader.LoadStructure loadStructure : function.getLoadStructures()) {
                class_243 loadStructurePos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, loadStructure.getOffset(), "LoadStructures");
                if (player != null && loadStructure.getPosSrc() != PosSrc.BLOCK) {
                    loadStructurePos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.method_24515()), loadStructure.getPosSrc(), loadStructure.getOffset(), "LoadStructures");
                }
                LuckyEventFunctions.loadStructure(serverLevel, PosHelper.parseVec3d(loadStructurePos), loadStructure.getModId(), loadStructure.getId());
            }
        }
        if (function.hasExecuteCommands()) {
            for (RandomEventReader.ExecuteCommand executeCommand : function.getExecuteCommands()) {
                class_243 executeCommandPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(blockPos), PosSrc.BLOCK, executeCommand.getOffset(), "ExecuteCommands");
                if (player != null && executeCommand.getPosSrc() != PosSrc.BLOCK) {
                    executeCommandPos = PosHelper.calcPos(PosHelper.parseBlockPos(blockPos), PosHelper.parseBlockPos(player.method_24515()), executeCommand.getPosSrc(), executeCommand.getOffset(), "ExecuteCommands");
                }
                LuckyEventFunctions.executeCommand(serverLevel, executeCommandPos, executeCommand.getCommand());
            }
        }
    }

    private static int getRandomNumber(int min, int max) {
        return min + new Random().nextInt(max - min + 1);
    }
}

