/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.melanx.simplebackups.BackupData;
import de.melanx.simplebackups.BackupThread;
import de.melanx.simplebackups.SimpleBackups;
import de.melanx.simplebackups.commands.BackupCommand;
import de.melanx.simplebackups.commands.MergeCommand;
import de.melanx.simplebackups.commands.PauseCommand;
import de.melanx.simplebackups.config.CommonConfig;
import de.melanx.simplebackups.config.ServerConfig;
import de.melanx.simplebackups.network.Pause;
import net.minecraft.commands.Commands;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.NetworkRegistry;

public class EventListener {
    private boolean doBackup;

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"simplebackups").requires(stack -> ServerConfig.commandsCheatsDisabled() || stack.hasPermission(2))).then(BackupCommand.register())).then(PauseCommand.register())).then(MergeCommand.register()));
    }

    @SubscribeEvent
    public void onServerTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!level2.isClientSide && level2.getGameTime() % 20L == 0L && level2 == level2.getServer().overworld()) {
                EventListener.checkForTickCounterConfigUpdate(event.getLevel().getServer());
                if (!level2.getServer().getPlayerList().getPlayers().isEmpty() || this.doBackup || CommonConfig.doNoPlayerBackups()) {
                    this.doBackup = false;
                    boolean done = BackupThread.tryCreateBackup(level2.getServer());
                    if (done) {
                        SimpleBackups.LOGGER.info("Backup done.");
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (CommonConfig.isEnabled() && event.getEntity().getServer() != null && NetworkRegistry.hasChannel((Connection)player.connection.connection, null, (ResourceLocation)Pause.ID)) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new Pause(BackupData.get(event.getEntity().getServer()).isPaused()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).getServer().getPlayerList().getPlayers().isEmpty()) {
            this.doBackup = true;
        }
    }

    private static void checkForTickCounterConfigUpdate(MinecraftServer server) {
        BackupData backupData = BackupData.get(server);
        boolean usesTickCounter = CommonConfig.useTickCounter();
        if (usesTickCounter != backupData.usesTickCounter()) {
            SimpleBackups.LOGGER.info("Tick counter config updated, usesTickCounter: {}", (Object)usesTickCounter);
            backupData.setUsesTickCounter(usesTickCounter);
            long lastTimeSaved = backupData.getLastSaved();
            int commonConfigTimer = CommonConfig.getTimer();
            SimpleBackups.LOGGER.info("Initial lastTimeSaved: {}", (Object)lastTimeSaved);
            SimpleBackups.LOGGER.info("Config timer in minutes: {}", (Object)commonConfigTimer);
            if (usesTickCounter) {
                long millisecondsTimeDifference = System.currentTimeMillis() - lastTimeSaved;
                long tickTimeDifference = millisecondsTimeDifference / 50L;
                lastTimeSaved = server.overworld().getGameTime() - tickTimeDifference;
                long timerInTicks = (long)commonConfigTimer * 60L * 20L;
                SimpleBackups.LOGGER.info("Milliseconds difference: {}, Tick difference: {}", (Object)millisecondsTimeDifference, (Object)tickTimeDifference);
                SimpleBackups.LOGGER.info("Updated lastTimeSaved in ticks: {}", (Object)lastTimeSaved);
                SimpleBackups.LOGGER.info("Timer value in ticks: {}", (Object)timerInTicks);
                lastTimeSaved = Math.max(lastTimeSaved, timerInTicks);
                SimpleBackups.LOGGER.info("Final lastTimeSaved after max comparison (ticks): {}", (Object)lastTimeSaved);
            } else {
                long tickTimeDifference = server.overworld().getGameTime() - lastTimeSaved;
                long millisecondsTimeDifference = tickTimeDifference * 50L;
                lastTimeSaved = System.currentTimeMillis() - millisecondsTimeDifference;
                long timerInMilliseconds = (long)commonConfigTimer * 60L * 1000L;
                SimpleBackups.LOGGER.info("Tick difference: {}, Milliseconds difference: {}", (Object)tickTimeDifference, (Object)millisecondsTimeDifference);
                SimpleBackups.LOGGER.info("Updated lastTimeSaved in milliseconds: {}", (Object)lastTimeSaved);
                SimpleBackups.LOGGER.info("Timer value in milliseconds: {}", (Object)timerInMilliseconds);
                lastTimeSaved = Math.max(lastTimeSaved, timerInMilliseconds);
                SimpleBackups.LOGGER.info("Final lastTimeSaved after max comparison (milliseconds): {}", (Object)lastTimeSaved);
            }
        }
    }
}

